/*
 * Decompiled with CFR 0.152.
 */
package io.github.chakyl.splendidslimes;

import dev.shadowsoffire.placebo.config.Configuration;
import dev.shadowsoffire.placebo.network.MessageHelper;
import dev.shadowsoffire.placebo.network.MessageProvider;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class SlimyConfig {
    public static int slimeStarvingTime;
    public static int slimeMaxHappiness;
    public static int slimeHappyThreshold;
    public static int slimeUnhappyThreshold;
    public static int slimeFuriousThreshold;
    public static int slimeEffectCooldown;
    public static boolean slimeOwnerOfflineCheck;
    public static boolean enableTarrs;
    public static int incubationTime;
    public static int plortPressingTime;
    public static int slimeSpawnerTime;

    public static void load() {
        Configuration cfg = new Configuration("splendid_slimes");
        cfg.setTitle("\ua4b7\ua4a6\ua4b7\ua4a6\ua4b7\ua4a6\ua4b7\ua4a6\ua4b7\ua4a6\ua4b7\ua4a6 Splendid Slimes Config! \ua4a6\ua4b7\ua4a6\ua4b7\ua4a6\ua4b7\ua4a6\ua4b7\ua4a6\ua4b7\ua4a6\ua4b7");
        cfg.setComment("All entries in this config file are synced from server to client.");
        slimeStarvingTime = cfg.getInt("Slime Starving time", "slimes", 24000, 20, Integer.MAX_VALUE, "How long it takes for Splendid Slimes to start starving, in ticks. Slimes can eat halfway through this duration");
        slimeMaxHappiness = cfg.getInt("Slime Max Happiness", "slimes", 1000, 3, 2147483147, "Maximum happiness value for a Splendid Slime.");
        slimeHappyThreshold = cfg.getInt("Slime Happy Threshold", "slimes", 600, 0, Integer.MAX_VALUE, "Minimum amount of happiness a Splendid Slime can have before being considered 'Happy'.");
        slimeUnhappyThreshold = cfg.getInt("Slime Unhappy Threshold", "slimes", 400, 0, Integer.MAX_VALUE, "Maximum amount of happiness a Splendid Slime can have before being considered 'Unhappy'.");
        slimeFuriousThreshold = cfg.getInt("Slime Furious Threshold", "slimes", 200, 0, Integer.MAX_VALUE, "Maximum amount of happiness a Splendid Slime can have before being considered 'Furious'.");
        slimeEffectCooldown = cfg.getInt("Slime Effect Cooldown", "slimes", 800, 20, Integer.MAX_VALUE, "How many ticks it takes for a Splendid Slime to try and perform Negative/Positive effects/commands. Setting this value too low may cause performance issues.");
        slimeOwnerOfflineCheck = cfg.getBoolean("Slime Owner Offline Check", "slimes", true, "When true, Slimes will not get hungry or perform effects when their owner is offline. This can help prevent disasters on Multiplayer servers and has no effect in single player.");
        enableTarrs = cfg.getBoolean("Enable Tarrs", "slimes", true, "If true, Largo Slimes will turn into Tarrs after eating a 3rd Plort instead of just dying.");
        incubationTime = cfg.getInt("Slime Incubation Time", "machines", 6000, 1, Integer.MAX_VALUE, "Time it takes for Splendid Slimes to incubate in Slime Incubator");
        plortPressingTime = cfg.getInt("Plort Pressing Time", "machines", 1200, 20, 0x7FFFFFF5, "Time it takes to craft items in a Plort Press");
        slimeSpawnerTime = cfg.getInt("Slime Spawner Time", "spawner", 6000, 20, Integer.MAX_VALUE, "Time it takes for Slime Spawners to be able to dispense Slimes again");
        if (cfg.hasChanged()) {
            cfg.save();
        }
    }

    record ConfigMessage(int slimeStarvingTime, int slimeMaxHappiness, int slimeHappyThreshold, int slimeUnhappyThreshold, int slimeFuriousThreshold, int slimeEffectCooldown, boolean slimeOwnerOfflineCheck, boolean enableTarrs, int incubationTime, int plortPressingTime, int slimeSpawnerTime) {
        public ConfigMessage() {
            this(slimeStarvingTime, slimeMaxHappiness, slimeHappyThreshold, slimeUnhappyThreshold, slimeFuriousThreshold, slimeEffectCooldown, slimeOwnerOfflineCheck, enableTarrs, incubationTime, plortPressingTime, slimeSpawnerTime);
        }

        public static class Provider
        implements MessageProvider<ConfigMessage> {
            public Class<?> getMsgClass() {
                return ConfigMessage.class;
            }

            public void write(ConfigMessage msg, FriendlyByteBuf buf) {
                buf.writeInt(msg.slimeStarvingTime);
                buf.writeInt(msg.slimeMaxHappiness);
                buf.writeInt(msg.slimeHappyThreshold);
                buf.writeInt(msg.slimeUnhappyThreshold);
                buf.writeInt(msg.slimeFuriousThreshold);
                buf.writeInt(msg.slimeEffectCooldown);
                buf.writeBoolean(msg.slimeOwnerOfflineCheck);
                buf.writeBoolean(msg.enableTarrs);
                buf.writeInt(msg.incubationTime);
                buf.writeInt(msg.plortPressingTime);
                buf.writeInt(msg.slimeSpawnerTime);
            }

            public ConfigMessage read(FriendlyByteBuf buf) {
                return new ConfigMessage(buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readBoolean(), buf.readBoolean(), buf.readInt(), buf.readInt(), buf.readInt());
            }

            public void handle(ConfigMessage msg, Supplier<NetworkEvent.Context> ctx) {
                MessageHelper.handlePacket(() -> {
                    SlimyConfig.slimeStarvingTime = msg.slimeStarvingTime;
                    SlimyConfig.slimeMaxHappiness = msg.slimeMaxHappiness;
                    SlimyConfig.slimeHappyThreshold = msg.slimeHappyThreshold;
                    SlimyConfig.slimeUnhappyThreshold = msg.slimeUnhappyThreshold;
                    SlimyConfig.slimeFuriousThreshold = msg.slimeFuriousThreshold;
                    SlimyConfig.slimeEffectCooldown = msg.slimeEffectCooldown;
                    SlimyConfig.slimeOwnerOfflineCheck = msg.slimeOwnerOfflineCheck;
                    SlimyConfig.enableTarrs = msg.slimeOwnerOfflineCheck;
                    SlimyConfig.incubationTime = msg.incubationTime;
                    SlimyConfig.plortPressingTime = msg.plortPressingTime;
                    SlimyConfig.slimeSpawnerTime = msg.slimeSpawnerTime;
                }, ctx);
            }

            public Optional<NetworkDirection> getNetworkDirection() {
                return Optional.of(NetworkDirection.PLAY_TO_CLIENT);
            }
        }
    }
}

