/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.item;

import com.refinedmods.refinedstorage.RSItems;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPattern;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPatternProvider;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.AllowedTagList;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.CraftingPattern;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.CraftingPatternFactory;
import com.refinedmods.refinedstorage.render.Styles;
import com.refinedmods.refinedstorage.render.blockentity.PatternItemBlockEntityRenderer;
import com.refinedmods.refinedstorage.util.ItemStackKey;
import com.refinedmods.refinedstorage.util.RenderUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.fluids.FluidStack;

public class PatternItem
extends Item
implements ICraftingPatternProvider {
    private static final Map<ItemStackKey, ICraftingPattern> CACHE = new HashMap<ItemStackKey, ICraftingPattern>();
    private static final String NBT_VERSION = "Version";
    private static final String NBT_INPUT_SLOT = "Input_%d";
    private static final String NBT_OUTPUT_SLOT = "Output_%d";
    private static final String NBT_FLUID_INPUT_SLOT = "FluidInput_%d";
    private static final String NBT_FLUID_OUTPUT_SLOT = "FluidOutput_%d";
    private static final String NBT_EXACT = "Exact";
    private static final String NBT_PROCESSING = "Processing";
    private static final String NBT_ALLOWED_TAGS = "AllowedTags";
    private static final int VERSION = 1;

    public PatternItem() {
        super(new Item.Properties());
    }

    public static ICraftingPattern fromCache(Level level, ItemStack stack) {
        ICraftingPattern pattern = CACHE.computeIfAbsent(new ItemStackKey(stack), s -> CraftingPatternFactory.INSTANCE.create(level, null, s.getStack()));
        if (CACHE.size() > 16384) {
            CACHE.clear();
        }
        return pattern;
    }

    public static void setInputSlot(ItemStack pattern, int slot, ItemStack stack) {
        if (!pattern.m_41782_()) {
            pattern.m_41751_(new CompoundTag());
        }
        pattern.m_41783_().m_128365_(String.format(NBT_INPUT_SLOT, slot), (Tag)stack.serializeNBT());
    }

    @Nonnull
    public static ItemStack getInputSlot(ItemStack pattern, int slot) {
        String id = String.format(NBT_INPUT_SLOT, slot);
        if (!pattern.m_41782_() || !pattern.m_41783_().m_128441_(id)) {
            return ItemStack.f_41583_;
        }
        return ItemStack.m_41712_((CompoundTag)pattern.m_41783_().m_128469_(id));
    }

    public static void setOutputSlot(ItemStack pattern, int slot, ItemStack stack) {
        if (!pattern.m_41782_()) {
            pattern.m_41751_(new CompoundTag());
        }
        pattern.m_41783_().m_128365_(String.format(NBT_OUTPUT_SLOT, slot), (Tag)stack.serializeNBT());
    }

    @Nonnull
    public static ItemStack getOutputSlot(ItemStack pattern, int slot) {
        String id = String.format(NBT_OUTPUT_SLOT, slot);
        if (!pattern.m_41782_() || !pattern.m_41783_().m_128441_(id)) {
            return ItemStack.f_41583_;
        }
        return ItemStack.m_41712_((CompoundTag)pattern.m_41783_().m_128469_(id));
    }

    public static void setFluidInputSlot(ItemStack pattern, int slot, FluidStack stack) {
        if (!pattern.m_41782_()) {
            pattern.m_41751_(new CompoundTag());
        }
        pattern.m_41783_().m_128365_(String.format(NBT_FLUID_INPUT_SLOT, slot), (Tag)stack.writeToNBT(new CompoundTag()));
    }

    public static FluidStack getFluidInputSlot(ItemStack pattern, int slot) {
        String id = String.format(NBT_FLUID_INPUT_SLOT, slot);
        if (!pattern.m_41782_() || !pattern.m_41783_().m_128441_(id)) {
            return FluidStack.EMPTY;
        }
        return FluidStack.loadFluidStackFromNBT((CompoundTag)pattern.m_41783_().m_128469_(id));
    }

    public static void setFluidOutputSlot(ItemStack pattern, int slot, FluidStack stack) {
        if (!pattern.m_41782_()) {
            pattern.m_41751_(new CompoundTag());
        }
        pattern.m_41783_().m_128365_(String.format(NBT_FLUID_OUTPUT_SLOT, slot), (Tag)stack.writeToNBT(new CompoundTag()));
    }

    public static FluidStack getFluidOutputSlot(ItemStack pattern, int slot) {
        String id = String.format(NBT_FLUID_OUTPUT_SLOT, slot);
        if (!pattern.m_41782_() || !pattern.m_41783_().m_128441_(id)) {
            return FluidStack.EMPTY;
        }
        return FluidStack.loadFluidStackFromNBT((CompoundTag)pattern.m_41783_().m_128469_(id));
    }

    public static boolean isProcessing(ItemStack pattern) {
        return pattern.m_41782_() && pattern.m_41783_().m_128441_(NBT_PROCESSING) && pattern.m_41783_().m_128471_(NBT_PROCESSING);
    }

    public static void setProcessing(ItemStack pattern, boolean processing) {
        if (!pattern.m_41782_()) {
            pattern.m_41751_(new CompoundTag());
        }
        pattern.m_41783_().m_128379_(NBT_PROCESSING, processing);
    }

    public static boolean isExact(ItemStack pattern) {
        if (!pattern.m_41782_() || !pattern.m_41783_().m_128441_(NBT_EXACT)) {
            return false;
        }
        return pattern.m_41783_().m_128471_(NBT_EXACT);
    }

    public static void setExact(ItemStack pattern, boolean exact) {
        if (!pattern.m_41782_()) {
            pattern.m_41751_(new CompoundTag());
        }
        pattern.m_41783_().m_128379_(NBT_EXACT, exact);
    }

    public static void setToCurrentVersion(ItemStack pattern) {
        if (!pattern.m_41782_()) {
            pattern.m_41751_(new CompoundTag());
        }
        pattern.m_41783_().m_128405_(NBT_VERSION, 1);
    }

    public static void setAllowedTags(ItemStack pattern, AllowedTagList allowedTagList) {
        if (!pattern.m_41782_()) {
            pattern.m_41751_(new CompoundTag());
        }
        pattern.m_41783_().m_128365_(NBT_ALLOWED_TAGS, (Tag)allowedTagList.writeToNbt());
    }

    @Nullable
    public static AllowedTagList getAllowedTags(ItemStack pattern) {
        if (!pattern.m_41782_() || !pattern.m_41783_().m_128441_(NBT_ALLOWED_TAGS)) {
            return null;
        }
        AllowedTagList allowedTagList = new AllowedTagList(null, 81);
        allowedTagList.readFromNbt(pattern.m_41783_().m_128469_(NBT_ALLOWED_TAGS));
        return allowedTagList;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return PatternItemBlockEntityRenderer.getInstance();
            }
        });
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        if (!stack.m_41782_() || level == null) {
            return;
        }
        ICraftingPattern pattern = PatternItem.fromCache(level, stack);
        if (pattern.isValid()) {
            if (Screen.m_96638_() || PatternItem.isProcessing(stack)) {
                tooltip.add((Component)Component.m_237115_((String)"misc.refinedstorage.pattern.inputs").m_6270_(Styles.YELLOW));
                RenderUtils.addCombinedItemsToTooltip(tooltip, true, pattern.getInputs().stream().map(i -> !i.isEmpty() ? (ItemStack)i.get(0) : ItemStack.f_41583_).collect(Collectors.toList()));
                RenderUtils.addCombinedFluidsToTooltip(tooltip, true, pattern.getFluidInputs().stream().map(i -> !i.isEmpty() ? (FluidStack)i.get(0) : FluidStack.EMPTY).collect(Collectors.toList()));
                tooltip.add((Component)Component.m_237115_((String)"misc.refinedstorage.pattern.outputs").m_6270_(Styles.YELLOW));
            }
            RenderUtils.addCombinedItemsToTooltip(tooltip, true, pattern.getOutputs());
            RenderUtils.addCombinedFluidsToTooltip(tooltip, true, pattern.getFluidOutputs());
            if (pattern instanceof CraftingPattern && ((CraftingPattern)pattern).getAllowedTagList() != null) {
                this.addAllowedTags(tooltip, (CraftingPattern)pattern);
            }
            if (PatternItem.isExact(stack)) {
                tooltip.add((Component)Component.m_237115_((String)"misc.refinedstorage.pattern.exact").m_6270_(Styles.BLUE));
            }
            if (PatternItem.isProcessing(stack)) {
                tooltip.add((Component)Component.m_237115_((String)"misc.refinedstorage.processing").m_6270_(Styles.BLUE));
            }
        } else {
            tooltip.add((Component)Component.m_237115_((String)"misc.refinedstorage.pattern.invalid").m_6270_(Styles.RED));
            tooltip.add((Component)pattern.getErrorMessage().m_6879_().m_6270_(Styles.GRAY));
        }
    }

    public void addAllowedTags(List<Component> tooltip, CraftingPattern pattern) {
        Set<ResourceLocation> allowedTags;
        int i;
        for (i = 0; i < pattern.getAllowedTagList().getAllowedItemTags().size(); ++i) {
            allowedTags = pattern.getAllowedTagList().getAllowedItemTags().get(i);
            for (ResourceLocation tag : allowedTags) {
                tooltip.add((Component)Component.m_237110_((String)"misc.refinedstorage.pattern.allowed_item_tag", (Object[])new Object[]{tag.toString(), ((ItemStack)pattern.getInputs().get(i).get(0)).m_41786_()}).m_6270_(Styles.AQUA));
            }
        }
        for (i = 0; i < pattern.getAllowedTagList().getAllowedFluidTags().size(); ++i) {
            allowedTags = pattern.getAllowedTagList().getAllowedFluidTags().get(i);
            for (ResourceLocation tag : allowedTags) {
                tooltip.add((Component)Component.m_237110_((String)"misc.refinedstorage.pattern.allowed_fluid_tag", (Object[])new Object[]{tag.toString(), ((FluidStack)pattern.getFluidInputs().get(i).get(0)).getDisplayName()}).m_6270_(Styles.AQUA));
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (!level.f_46443_ && player.m_6047_()) {
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)new ItemStack((ItemLike)RSItems.PATTERN.get(), player.m_21120_(hand).m_41613_()));
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)player.m_21120_(hand));
    }

    @Override
    @Nonnull
    public ICraftingPattern create(Level level, ItemStack stack, ICraftingPatternContainer container) {
        return CraftingPatternFactory.INSTANCE.create(level, container, stack);
    }
}

