/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.integration.jei;

import com.refinedmods.refinedstorage.container.BaseContainerMenu;
import com.refinedmods.refinedstorage.container.slot.filter.FluidFilterSlot;
import com.refinedmods.refinedstorage.integration.jei.JeiHelper;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import com.refinedmods.refinedstorage.screen.grid.GridScreen;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.SideButton;
import com.refinedmods.refinedstorage.util.RenderUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.runtime.IClickableIngredient;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraftforge.fluids.FluidStack;

public class GuiContainerHandler
implements IGuiContainerHandler<AbstractContainerScreen<?>> {
    private final JeiHelper jeiHelper;

    public GuiContainerHandler(JeiHelper jeiHelper) {
        this.jeiHelper = jeiHelper;
    }

    public List<Rect2i> getGuiExtraAreas(AbstractContainerScreen<?> screen) {
        if (screen instanceof BaseScreen) {
            List<SideButton> sideButtons = ((BaseScreen)screen).getSideButtons();
            ArrayList<Rect2i> rectangles = new ArrayList<Rect2i>();
            for (SideButton sideButton : sideButtons) {
                rectangles.add(new Rect2i(sideButton.m_252754_(), sideButton.m_252907_(), sideButton.m_5711_(), sideButton.m_93694_()));
            }
            return rectangles;
        }
        return Collections.emptyList();
    }

    public Optional<IClickableIngredient<?>> getClickableIngredientUnderMouse(AbstractContainerScreen screen, double mouseX, double mouseY) {
        GridScreen grid;
        if (screen instanceof GridScreen && !(grid = (GridScreen)screen).getSearchField().m_93696_() && grid.isOverSlotArea(mouseX -= (double)screen.getGuiLeft(), mouseY -= (double)screen.getGuiTop())) {
            boolean inRange = grid.getSlotNumber() >= 0 && grid.getSlotNumber() < grid.getView().getStacks().size();
            Rect2i area = new Rect2i(grid.getSlotNumberX(), grid.getSlotNumberY(), 18, 18);
            return inRange ? this.jeiHelper.makeClickableIngredient(grid.getView().getStacks().get(grid.getSlotNumber()).getIngredient(), area) : Optional.empty();
        }
        if (screen.m_6262_() instanceof BaseContainerMenu) {
            for (FluidFilterSlot slot : ((BaseContainerMenu)screen.m_6262_()).getFluidSlots()) {
                FluidStack fluidInSlot = slot.getFluidInventory().getFluid(slot.getSlotIndex());
                if (fluidInSlot.isEmpty() || !RenderUtils.inBounds(slot.f_40220_, slot.f_40221_, 18, 18, mouseX, mouseY)) continue;
                Rect2i area = new Rect2i(slot.f_40220_, slot.f_40221_, 18, 18);
                return this.jeiHelper.makeClickableIngredient(fluidInSlot, area);
            }
        }
        return Optional.empty();
    }
}

