/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.monitor;

import com.refinedmods.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElement;
import com.refinedmods.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElementList;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDisk;
import com.refinedmods.refinedstorage.api.util.StackListEntry;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.craftingmonitor.ErrorCraftingMonitorElement;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.craftingmonitor.FluidCraftingMonitorElement;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.craftingmonitor.ItemCraftingMonitorElement;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.node.CraftingNode;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.node.Node;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.node.ProcessingNode;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.node.ProcessingState;
import java.util.Collection;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class CraftingMonitorElementFactory {
    public List<ICraftingMonitorElement> getElements(Collection<Node> nodes, IStorageDisk<ItemStack> internalStorage, IStorageDisk<FluidStack> internalFluidStorage) {
        ICraftingMonitorElementList list = API.instance().createCraftingMonitorElementList();
        for (Node node : nodes) {
            if (node instanceof CraftingNode) {
                this.addForRecipe(list, (CraftingNode)node);
                continue;
            }
            this.addForProcessing(list, (ProcessingNode)node);
        }
        for (ItemStack stack : internalStorage.getStacks()) {
            list.addStorage(new ItemCraftingMonitorElement(stack, stack.m_41613_(), 0, 0, 0, 0));
        }
        for (ItemStack stack : internalFluidStorage.getStacks()) {
            list.addStorage(new FluidCraftingMonitorElement((FluidStack)stack, stack.getAmount(), 0, 0, 0, 0));
        }
        list.commit();
        return list.getElements();
    }

    private void addForProcessing(ICraftingMonitorElementList list, ProcessingNode node) {
        ICraftingMonitorElement element;
        if (node.getState() == ProcessingState.PROCESSED) {
            return;
        }
        for (StackListEntry<ItemStack> stackListEntry : node.getSingleItemSetToRequire().getStacks()) {
            if (node.getCurrentlyProcessing() <= 0) continue;
            ItemCraftingMonitorElement element2 = ItemCraftingMonitorElement.Builder.forStack(stackListEntry.getStack()).processing(stackListEntry.getStack().m_41613_() * node.getCurrentlyProcessing()).build();
            list.add(element2, true);
        }
        for (StackListEntry<ItemStack> stackListEntry : node.getSingleItemSetToReceive().getStacks()) {
            int needed = node.getNeeded(stackListEntry.getStack());
            if (needed <= 0) continue;
            element = ItemCraftingMonitorElement.Builder.forStack(stackListEntry.getStack()).scheduled(needed).build();
            element = this.wrapWithProcessingState(element, node.getState(), "item");
            list.add(element, true);
        }
        for (StackListEntry<ItemStack> stackListEntry : node.getSingleFluidSetToRequire().getStacks()) {
            if (node.getCurrentlyProcessing() <= 0) continue;
            FluidCraftingMonitorElement element3 = FluidCraftingMonitorElement.Builder.forStack((FluidStack)stackListEntry.getStack()).processing(((FluidStack)stackListEntry.getStack()).getAmount() * node.getCurrentlyProcessing()).build();
            list.add(element3, true);
        }
        for (StackListEntry<ItemStack> stackListEntry : node.getSingleFluidSetToReceive().getStacks()) {
            int needed = node.getNeeded((FluidStack)stackListEntry.getStack());
            if (needed <= 0) continue;
            element = FluidCraftingMonitorElement.Builder.forStack((FluidStack)stackListEntry.getStack()).scheduled(needed).build();
            element = this.wrapWithProcessingState(element, node.getState(), "fluid");
            list.add(element, true);
        }
    }

    private ICraftingMonitorElement wrapWithProcessingState(ICraftingMonitorElement element, ProcessingState state, String type) {
        if (state == ProcessingState.MACHINE_DOES_NOT_ACCEPT) {
            return new ErrorCraftingMonitorElement(element, "gui.refinedstorage.crafting_monitor.machine_does_not_accept_" + type);
        }
        if (state == ProcessingState.MACHINE_NONE) {
            return new ErrorCraftingMonitorElement(element, "gui.refinedstorage.crafting_monitor.machine_none");
        }
        if (state == ProcessingState.LOCKED) {
            return new ErrorCraftingMonitorElement(element, "gui.refinedstorage.crafting_monitor.crafter_is_locked");
        }
        return element;
    }

    private void addForRecipe(ICraftingMonitorElementList list, CraftingNode node) {
        if (node.getQuantity() > 0) {
            for (ItemStack receive : node.getPattern().getOutputs()) {
                list.add(new ItemCraftingMonitorElement(receive, 0, 0, 0, 0, receive.m_41613_() * node.getQuantity()), false);
            }
        }
    }
}

