/*
 * Decompiled with CFR 0.152.
 */
package com.Pink_Cats.createentitycontroller.addition;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class StructureBlockStorage {
    private static final List<BlockInfoEntry> blockEntries = new ArrayList<BlockInfoEntry>();

    public static UUID generateRandomUUID() {
        return UUID.randomUUID();
    }

    public static void removeOldEntries(long threshold) {
        long currentTimestamp = System.currentTimeMillis();
        blockEntries.removeIf(entry -> currentTimestamp - entry.getTimestamp() > threshold);
    }

    public static void storeData(UUID id, Map<BlockPos, StructureTemplate.StructureBlockInfo> data) {
        long currentTimestamp = System.currentTimeMillis();
        blockEntries.add(new BlockInfoEntry(id, data, currentTimestamp));
    }

    public static Map<BlockPos, StructureTemplate.StructureBlockInfo> getDataById(UUID id) {
        for (BlockInfoEntry entry : blockEntries) {
            if (!entry.getUuid().equals(id)) continue;
            return entry.getData();
        }
        return null;
    }

    public static List<BlockInfoEntry> getAllBlockEntries() {
        return blockEntries;
    }

    public static Long getTimestampById(UUID id) {
        for (BlockInfoEntry entry : blockEntries) {
            if (!entry.getUuid().equals(id)) continue;
            return entry.getTimestamp();
        }
        return null;
    }

    public static class BlockInfoEntry {
        private final UUID uuid;
        private final Map<BlockPos, StructureTemplate.StructureBlockInfo> data;
        private final long timestamp;

        public BlockInfoEntry(UUID uuid, Map<BlockPos, StructureTemplate.StructureBlockInfo> data, long timestamp) {
            this.uuid = uuid;
            this.data = data;
            this.timestamp = timestamp;
        }

        public UUID getUuid() {
            return this.uuid;
        }

        public Map<BlockPos, StructureTemplate.StructureBlockInfo> getData() {
            return this.data;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }
}

