/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.customvillagertrades.events;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import uk.co.dotcode.customvillagertrades.ConfigHandler;
import uk.co.dotcode.customvillagertrades.TradeUtil;
import uk.co.dotcode.customvillagertrades.trades.MyTrade;
import uk.co.dotcode.customvillagertrades.trades.MyTradeConverted;
import uk.co.dotcode.customvillagertrades.trades.MyWandererTrade;
import uk.co.dotcode.customvillagertrades.trades.TradeCollection;
import uk.co.dotcode.customvillagertrades.trades.WandererTradeCollection;

public class TradeRegistry {
    public static HashMap<String, String> usedUTIDs = new HashMap();

    public static void registerWanderingTrades() {
        boolean isValid;
        WandererTradeCollection tradeCollectionWanderer = ConfigHandler.loadWandererTrades("wanderer");
        if (tradeCollectionWanderer != null && (isValid = tradeCollectionWanderer.validate())) {
            HashMap converted = new HashMap();
            HashMap<Integer, VillagerTrades.ItemListing[]> levelSortedListings = new HashMap<Integer, VillagerTrades.ItemListing[]>();
            for (MyWandererTrade t : tradeCollectionWanderer.trades) {
                ArrayList<MyTradeConverted> currentList;
                if (t.isRare) {
                    currentList = converted.getOrDefault(2, new ArrayList());
                    currentList.add(new MyTradeConverted(t));
                    converted.put(2, currentList);
                    continue;
                }
                currentList = converted.getOrDefault(1, new ArrayList());
                currentList.add(new MyTradeConverted(t));
                converted.put(1, currentList);
            }
            for (Integer level : converted.keySet()) {
                levelSortedListings.put(level, ((ArrayList)converted.get(level)).toArray(new VillagerTrades.ItemListing[0]));
            }
            ConfigHandler.registeredCustomWandererTrades = levelSortedListings;
        }
    }

    public static void registerTrades(VillagerProfession profession) {
        if (profession == VillagerProfession.f_35585_ && profession == VillagerProfession.f_35596_) {
            return;
        }
        TradeCollection tradeCollection = ConfigHandler.loadTrades(TradeUtil.getKeyFromProfession(profession));
        TradeRegistry.registerCollection(TradeUtil.getKeyFromProfession(profession), tradeCollection, false);
    }

    private static void registerCollection(String profession, TradeCollection tradeCollection, boolean reloadTrades) {
        boolean isValid;
        if (tradeCollection != null && (isValid = tradeCollection.validate())) {
            tradeCollection = TradeRegistry.manageUTIDs(tradeCollection);
            if (tradeCollection.shouldUpdateFile) {
                ConfigHandler.overwriteTradeCollection(tradeCollection);
            }
            if (reloadTrades) {
                ConfigHandler.init();
                tradeCollection = ConfigHandler.loadTrades(profession);
            }
            HashMap converted = new HashMap();
            HashMap<Integer, VillagerTrades.ItemListing[]> levelSortedListings = new HashMap<Integer, VillagerTrades.ItemListing[]>();
            for (MyTrade t : tradeCollection.trades) {
                ArrayList<MyTradeConverted> currentList = converted.getOrDefault(t.tradeLevel, new ArrayList());
                currentList.add(new MyTradeConverted(t));
                converted.put(t.tradeLevel, currentList);
            }
            for (Integer level : converted.keySet()) {
                levelSortedListings.put(level, ((ArrayList)converted.get(level)).toArray(new VillagerTrades.ItemListing[0]));
            }
            ConfigHandler.registeredCustomTrades.put(profession, levelSortedListings);
        }
    }

    public static void registerTradesAllCategory() {
        boolean isAllValid;
        TradeCollection tradeCollectionAll = ConfigHandler.loadTrades("all");
        if (tradeCollectionAll != null && (isAllValid = tradeCollectionAll.validate())) {
            tradeCollectionAll = TradeRegistry.manageUTIDs(tradeCollectionAll);
            if (tradeCollectionAll.shouldUpdateFile) {
                ConfigHandler.overwriteTradeCollection(tradeCollectionAll);
            }
            HashMap converted = new HashMap();
            HashMap<Integer, VillagerTrades.ItemListing[]> levelSortedListings = new HashMap<Integer, VillagerTrades.ItemListing[]>();
            for (MyTrade t : tradeCollectionAll.trades) {
                ArrayList<MyTradeConverted> currentList = converted.getOrDefault(t.tradeLevel, new ArrayList());
                currentList.add(new MyTradeConverted(t));
                converted.put(t.tradeLevel, currentList);
            }
            for (Integer level : converted.keySet()) {
                levelSortedListings.put(level, ((ArrayList)converted.get(level)).toArray(new VillagerTrades.ItemListing[0]));
            }
            ConfigHandler.registeredAllCategoryTrades = levelSortedListings;
        }
    }

    public static TradeCollection manageUTIDs(TradeCollection coll) {
        TradeCollection newCollection = new TradeCollection();
        newCollection.profession = coll.profession;
        newCollection.removeOtherTrades = coll.removeOtherTrades;
        newCollection.trades = new MyTrade[coll.trades.length];
        newCollection.shouldUpdateFile = coll.shouldUpdateFile;
        int tradeCounter = 0;
        ArrayList<MyTrade> toLabel = new ArrayList<MyTrade>();
        for (MyTrade trade : coll.trades) {
            if (trade.UTID == null || trade.UTID.isEmpty()) {
                toLabel.add(trade);
                continue;
            }
            usedUTIDs.put(trade.UTID, coll.profession);
            newCollection.trades[tradeCounter] = trade;
            ++tradeCounter;
        }
        if (toLabel.size() > 0) {
            for (MyTrade trade : toLabel) {
                newCollection.trades[tradeCounter] = trade = TradeUtil.generateUTID(coll.profession, trade);
                ++tradeCounter;
            }
            newCollection.shouldUpdateFile = true;
        }
        return newCollection;
    }

    public static String addNewTrade(String profession, MyTrade trade) {
        TradeCollection tradeCollection;
        if (trade.UTID == null || trade.UTID.isEmpty()) {
            trade = TradeUtil.generateUTID(profession, trade);
        }
        usedUTIDs.put(trade.UTID, profession);
        if (ConfigHandler.customTrades.containsKey(profession)) {
            tradeCollection = ConfigHandler.customTrades.get(profession);
            MyTrade[] copy = Arrays.copyOf(tradeCollection.trades, tradeCollection.trades.length + 1);
            copy[copy.length - 1] = trade;
            tradeCollection.trades = copy;
        } else {
            tradeCollection = new TradeCollection();
            tradeCollection.profession = profession;
            tradeCollection.removeOtherTrades = false;
            tradeCollection.trades = new MyTrade[1];
            tradeCollection.trades[0] = trade;
        }
        tradeCollection.shouldUpdateFile = true;
        TradeRegistry.registerCollection(profession, tradeCollection, true);
        return trade.UTID;
    }

    public static String removeTrade(String UTID) {
        boolean success = false;
        if (usedUTIDs.containsKey(UTID)) {
            for (Map.Entry<String, String> entry : usedUTIDs.entrySet()) {
                if (!entry.getKey().equals(UTID)) continue;
                TradeCollection newCollection = ConfigHandler.customTrades.get(entry.getValue());
                ArrayList<MyTrade> newArray = new ArrayList<MyTrade>();
                for (MyTrade trade : newCollection.trades) {
                    if (trade.UTID.equals(UTID)) continue;
                    newArray.add(trade);
                }
                newCollection.trades = newArray.toArray(new MyTrade[newArray.size()]);
                newCollection.shouldUpdateFile = true;
                TradeRegistry.registerCollection(newCollection.profession, newCollection, true);
                success = true;
            }
        }
        if (success) {
            return "Successfully removed trade " + UTID;
        }
        return "Failed to removed trade " + UTID + " - Could not find UTID";
    }
}

