/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.core.mixin.leashable.common.entities;

import com.blackgear.vanillabackport.common.api.leash.InterpolationHandler;
import com.blackgear.vanillabackport.common.api.leash.Leashable;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Boat.class})
public abstract class BoatMixin
extends Entity
implements Leashable {
    @Unique
    private final InterpolationHandler interpolation = new InterpolationHandler(this, 3);
    @Unique
    @Nullable
    Entity leashHolder;
    @Unique
    private int delayedLeashHolderId;
    @Unique
    @Nullable
    CompoundTag leashInfoTag;
    @Unique
    private double angularMomentum;

    public BoatMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public double angularMomentum() {
        return this.angularMomentum;
    }

    @Override
    public void setAngularMomentum(double angularMomentum) {
        this.angularMomentum = angularMomentum;
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void vb$onTick(CallbackInfo ci) {
        if (!this.m_9236_().f_46443_) {
            this.vb$tickLeash();
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void vb$addAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        if (this.leashHolder != null) {
            CompoundTag data = new CompoundTag();
            if (this.leashHolder instanceof LivingEntity) {
                UUID uuid = this.leashHolder.m_20148_();
                data.m_128362_("UUID", uuid);
            } else if (this.leashHolder instanceof HangingEntity) {
                BlockPos pos = ((HangingEntity)this.leashHolder).m_31748_();
                data.m_128405_("X", pos.m_123341_());
                data.m_128405_("Y", pos.m_123342_());
                data.m_128405_("Z", pos.m_123343_());
            }
            tag.m_128365_("Leash", (Tag)data);
        } else if (this.leashInfoTag != null) {
            tag.m_128365_("Leash", (Tag)this.leashInfoTag.m_6426_());
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void vb$readAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        if (tag.m_128425_("Leash", 10)) {
            this.leashInfoTag = tag.m_128469_("Leash");
        }
    }

    @Unique
    private void vb$tickLeash() {
        if (this.leashInfoTag != null) {
            this.vb$restoreLeashFromSave();
        }
        if (!(this.leashHolder == null || this.m_6084_() && this.leashHolder.m_6084_())) {
            this.dropLeash(true, true);
        }
        Leashable.onTickLeash(this);
    }

    @Override
    public void dropLeash(boolean broadcast, boolean dropItem) {
        if (this.leashHolder != null) {
            Level level;
            this.leashHolder = null;
            this.leashInfoTag = null;
            if (!this.m_9236_().f_46443_ && dropItem) {
                this.m_19998_((ItemLike)Items.f_42655_);
            }
            if (!this.m_9236_().f_46443_ && broadcast && (level = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                server.m_7726_().m_8445_((Entity)this, (Packet)new ClientboundSetEntityLinkPacket((Entity)this, null));
            }
        }
    }

    protected Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.88f * this.m_20206_()), (double)(0.64f * this.m_20205_()));
    }

    @Override
    public boolean isLeashed() {
        return this.leashHolder != null;
    }

    public void m_142687_(Entity.RemovalReason reason) {
        if (!this.m_9236_().f_46443_ && reason.m_146965_() && this.isLeashed()) {
            this.dropLeash(true, true);
        }
        super.m_142687_(reason);
    }

    @Override
    @Nullable
    public Entity getLeashHolder() {
        if (this.leashHolder == null && this.delayedLeashHolderId != 0 && this.m_9236_().f_46443_) {
            this.leashHolder = this.m_9236_().m_6815_(this.delayedLeashHolderId);
        }
        return this.leashHolder;
    }

    @Override
    public void setLeashedTo(Entity entity, boolean sendAttachPacket) {
        Level level;
        this.leashHolder = entity;
        this.leashInfoTag = null;
        if (!this.m_9236_().f_46443_ && sendAttachPacket && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            server.m_7726_().m_8445_((Entity)this, (Packet)new ClientboundSetEntityLinkPacket((Entity)this, this.leashHolder));
        }
        if (this.m_20159_()) {
            this.m_8127_();
        }
    }

    @Override
    public void setBoatDelayedLeashHolderId(int leashHolderId) {
        this.delayedLeashHolderId = leashHolderId;
        this.dropLeash(false, false);
    }

    @Unique
    private void vb$restoreLeashFromSave() {
        Level level;
        if (this.leashInfoTag != null && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if (this.leashInfoTag.m_128403_("UUID")) {
                UUID uuid = this.leashInfoTag.m_128342_("UUID");
                Entity entity = server.m_8791_(uuid);
                if (entity != null) {
                    this.setLeashedTo(entity, true);
                    return;
                }
            } else if (this.leashInfoTag.m_128425_("X", 99) && this.leashInfoTag.m_128425_("Y", 99) && this.leashInfoTag.m_128425_("Z", 99)) {
                BlockPos pos = NbtUtils.m_129239_((CompoundTag)this.leashInfoTag);
                this.setLeashedTo((Entity)LeashFenceKnotEntity.m_31844_((Level)this.m_9236_(), (BlockPos)pos), true);
                return;
            }
            if (this.f_19797_ > 100) {
                this.m_19998_((ItemLike)Items.f_42655_);
                this.leashInfoTag = null;
            }
        }
    }

    protected void m_6089_() {
        super.m_6089_();
        this.dropLeash(true, false);
    }

    @Inject(method={"lerpTo"}, at={@At(value="HEAD")}, cancellable=true)
    private void vb$lerpTo(double x, double y, double z, float yRot, float xRot, int lerpSteps, boolean teleport, CallbackInfo ci) {
        ci.cancel();
        this.interpolation.interpolateTo(new Vec3(x, y, z), yRot, xRot);
    }

    @Inject(method={"tickLerp"}, at={@At(value="HEAD")}, cancellable=true)
    private void vb$tickLerp(CallbackInfo ci) {
        ci.cancel();
        if (this.m_6109_()) {
            this.interpolation.cancel();
            this.m_217006_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        this.interpolation.interpolate();
    }
}

