/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.level.entities.happyghast;

import com.blackgear.vanillabackport.common.level.entities.happyghast.HappyGhast;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class HappyGhastTemptGoal
extends Goal {
    private static final TargetingConditions TEMP_TARGETING = TargetingConditions.m_148353_().m_26883_(10.0).m_148355_();
    private final TargetingConditions targetingConditions;
    protected final HappyGhast ghast;
    private final double speedModifier;
    private double px;
    private double py;
    private double pz;
    private double pRotX;
    private double pRotY;
    @Nullable
    protected Player player;
    private int calmDown;
    private final Predicate<ItemStack> items;
    private final boolean canScare;
    private final double stopDistance;

    public HappyGhastTemptGoal(HappyGhast ghast, double speedModifier, Predicate<ItemStack> items, boolean canScare, double stopDistance) {
        this.ghast = ghast;
        this.speedModifier = speedModifier;
        this.items = items;
        this.canScare = canScare;
        this.stopDistance = stopDistance;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.targetingConditions = TEMP_TARGETING.m_148354_().m_26888_(this::shouldFollow);
    }

    public boolean m_8036_() {
        if (this.calmDown > 0) {
            --this.calmDown;
            return false;
        }
        this.player = this.ghast.m_9236_().m_45946_(this.targetingConditions.m_26883_(16.0), (LivingEntity)this.ghast);
        return this.player != null;
    }

    private boolean shouldFollow(LivingEntity entity) {
        return this.items.test(entity.m_21205_()) || this.items.test(entity.m_21206_());
    }

    public boolean m_8045_() {
        if (this.canScare() && this.player != null) {
            if (this.ghast.m_20280_((Entity)this.player) < 36.0) {
                if (this.player.m_20275_(this.px, this.py, this.pz) > 0.01) {
                    return false;
                }
                if (Math.abs((double)this.player.m_146909_() - this.pRotX) > 5.0 || Math.abs((double)this.player.m_146908_() - this.pRotY) > 5.0) {
                    return false;
                }
            } else {
                this.px = this.player.m_20185_();
                this.py = this.player.m_20186_();
                this.pz = this.player.m_20189_();
            }
            this.pRotX = this.player.m_146909_();
            this.pRotY = this.player.m_146908_();
        }
        return this.m_8036_();
    }

    protected boolean canScare() {
        return this.canScare;
    }

    public void m_8056_() {
        if (this.player == null) {
            return;
        }
        this.px = this.player.m_20185_();
        this.py = this.player.m_20186_();
        this.pz = this.player.m_20189_();
    }

    public void m_8041_() {
        this.player = null;
        this.ghast.m_21573_().m_26573_();
        this.calmDown = HappyGhastTemptGoal.m_186073_((int)100);
    }

    public void m_8037_() {
        if (this.player == null) {
            return;
        }
        this.ghast.m_21563_().m_24960_((Entity)this.player, (float)(this.ghast.m_8085_() + 20), (float)this.ghast.m_8132_());
        if (this.ghast.m_20280_((Entity)this.player) < this.stopDistance * this.stopDistance) {
            this.ghast.m_21566_().f_24981_ = MoveControl.Operation.WAIT;
        } else {
            Vec3 vec3 = this.player.m_146892_().m_82546_(this.ghast.m_20182_()).m_82490_(this.ghast.m_217043_().m_188500_()).m_82549_(this.ghast.m_20182_());
            this.ghast.m_21566_().m_6849_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, this.speedModifier);
        }
    }
}

