/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common;

import com.blackgear.platform.common.data.LootModifier;
import com.blackgear.platform.common.integration.BlockIntegration;
import com.blackgear.platform.common.integration.MobIntegration;
import com.blackgear.platform.common.integration.MobInteraction;
import com.blackgear.platform.common.integration.TradeIntegration;
import com.blackgear.platform.common.worldgen.placement.BiomePlacement;
import com.blackgear.platform.core.ParallelDispatch;
import com.blackgear.vanillabackport.common.api.leash.LeashIntegration;
import com.blackgear.vanillabackport.common.level.dispenser.PaleOakBoatDispenseBehavior;
import com.blackgear.vanillabackport.common.level.entities.creaking.Creaking;
import com.blackgear.vanillabackport.common.level.entities.happyghast.HappyGhast;
import com.blackgear.vanillabackport.common.registries.ModBlocks;
import com.blackgear.vanillabackport.common.registries.ModEntities;
import com.blackgear.vanillabackport.common.registries.ModItems;
import com.blackgear.vanillabackport.common.worldgen.BiomeGeneration;
import com.blackgear.vanillabackport.core.VanillaBackport;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.EntityFlagsPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.TagPredicate;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.DamageSourceCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class CommonSetup {
    public static void setup() {
        MobIntegration.registerIntegrations(CommonSetup::mobIntegrations);
    }

    public static void asyncSetup(ParallelDispatch dispatch) {
        dispatch.enqueueWork(() -> {
            BiomePlacement.registerBiomePlacements(BiomeGeneration::bootstrap);
            BlockIntegration.registerIntegrations(CommonSetup::blockIntegrations);
            TradeIntegration.registerVillagerTrades(CommonSetup::tradeIntegrations);
        });
        LootModifier.modify(CommonSetup::lootIntegrations);
    }

    public static void blockIntegrations(BlockIntegration.Event event) {
        event.registerFlammableBlock(ModBlocks.PALE_OAK_PLANKS.get(), 5, 20);
        event.registerFlammableBlock(ModBlocks.PALE_OAK_SLAB.get(), 5, 20);
        event.registerFlammableBlock(ModBlocks.PALE_OAK_FENCE_GATE.get(), 5, 20);
        event.registerFlammableBlock(ModBlocks.PALE_OAK_FENCE.get(), 5, 20);
        event.registerFlammableBlock(ModBlocks.PALE_OAK_STAIRS.get(), 5, 20);
        event.registerFlammableBlock(ModBlocks.PALE_OAK_LOG.get(), 5, 5);
        event.registerFlammableBlock(ModBlocks.STRIPPED_PALE_OAK_LOG.get(), 5, 5);
        event.registerFlammableBlock(ModBlocks.STRIPPED_PALE_OAK_WOOD.get(), 5, 5);
        event.registerFlammableBlock(ModBlocks.PALE_OAK_WOOD.get(), 5, 5);
        event.registerFlammableBlock(ModBlocks.PALE_OAK_LEAVES.get(), 30, 60);
        event.registerFlammableBlock(ModBlocks.PALE_MOSS_BLOCK.get(), 5, 100);
        event.registerFlammableBlock(ModBlocks.PALE_MOSS_CARPET.get(), 5, 100);
        event.registerFlammableBlock(ModBlocks.PALE_HANGING_MOSS.get(), 5, 100);
        event.registerFlammableBlock(ModBlocks.OPEN_EYEBLOSSOM.get(), 60, 100);
        event.registerFlammableBlock(ModBlocks.CLOSED_EYEBLOSSOM.get(), 60, 100);
        event.registerCompostableItem((ItemLike)ModBlocks.PALE_OAK_LEAVES.get(), 0.3f);
        event.registerCompostableItem((ItemLike)ModBlocks.PALE_OAK_SAPLING.get(), 0.3f);
        event.registerCompostableItem((ItemLike)ModBlocks.PALE_MOSS_CARPET.get(), 0.3f);
        event.registerCompostableItem((ItemLike)ModBlocks.PALE_HANGING_MOSS.get(), 0.3f);
        event.registerCompostableItem((ItemLike)ModBlocks.PALE_MOSS_BLOCK.get(), 0.3f);
        event.registerCompostableItem((ItemLike)ModBlocks.OPEN_EYEBLOSSOM.get(), 0.65f);
        event.registerCompostableItem((ItemLike)ModBlocks.CLOSED_EYEBLOSSOM.get(), 0.65f);
        event.registerStrippableBlock(ModBlocks.PALE_OAK_LOG.get(), ModBlocks.STRIPPED_PALE_OAK_LOG.get());
        event.registerStrippableBlock(ModBlocks.PALE_OAK_WOOD.get(), ModBlocks.STRIPPED_PALE_OAK_WOOD.get());
        event.registerDispenserBehavior((ItemLike)ModItems.PALE_OAK_BOAT.get(), (DispenseItemBehavior)new PaleOakBoatDispenseBehavior());
        event.registerDispenserBehavior((ItemLike)ModItems.PALE_OAK_CHEST_BOAT.get(), (DispenseItemBehavior)new PaleOakBoatDispenseBehavior(true));
    }

    public static void tradeIntegrations(TradeIntegration.Event event) {
        if (((Boolean)VanillaBackport.CONFIG.paleTradesFromWanderer.get()).booleanValue()) {
            event.registerWandererTrade(true, new VillagerTrades.ItemListing[]{new VillagerTrades.ItemsForEmeralds(ModBlocks.PALE_OAK_LOG.get(), 1, 8, 4, 1), new VillagerTrades.ItemsForEmeralds(ModBlocks.PALE_OAK_SAPLING.get(), 5, 1, 8, 1), new VillagerTrades.ItemsForEmeralds(ModBlocks.PALE_HANGING_MOSS.get(), 1, 3, 4, 1), new VillagerTrades.ItemsForEmeralds(ModBlocks.PALE_MOSS_BLOCK.get(), 1, 2, 5, 1), new VillagerTrades.ItemsForEmeralds(ModBlocks.OPEN_EYEBLOSSOM.get(), 1, 1, 7, 1)});
        }
    }

    public static void mobIntegrations(MobIntegration.Event event) {
        event.registerMobInteraction((MobInteraction)new LeashIntegration());
        event.registerAttributes(ModEntities.CREAKING, Creaking::createAttributes);
        event.registerAttributes(ModEntities.HAPPY_GHAST, HappyGhast::createAttributes);
        event.registerGoal(EntityType.f_20493_, 1, mob -> new AvoidEntityGoal((PathfinderMob)mob, Creaking.class, 8.0f, 0.6, 1.2));
        event.registerGoal(EntityType.f_20513_, 1, mob -> new AvoidEntityGoal((PathfinderMob)mob, Creaking.class, 8.0f, 0.6, 1.2));
        event.registerGoal(EntityType.f_20459_, 3, mob -> new AvoidEntityGoal((PathfinderMob)mob, Creaking.class, 8.0f, 0.6, 1.2));
        event.registerGoal(EntityType.f_20568_, 3, mob -> new AvoidEntityGoal((PathfinderMob)mob, Creaking.class, 8.0f, 0.6, 1.2));
    }

    public static void lootIntegrations(ResourceLocation path, LootModifier.LootTableContext context, boolean builtin) {
        if (path.equals((Object)EntityType.f_20453_.m_20677_())) {
            context.addPool(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.MUSIC_DISC_TEARS.get()))).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79080_(DamageSourceCondition.m_81589_((DamageSourcePredicate.Builder)DamageSourcePredicate.Builder.m_25471_().m_269507_(TagPredicate.m_269314_((TagKey)DamageTypeTags.f_268524_)).m_25472_(EntityPredicate.Builder.m_36633_().m_36636_(EntityType.f_20463_)))).m_79080_(LootItemKilledByPlayerCondition.m_81901_()));
        }
        if (path.equals((Object)BuiltInLootTables.f_78738_)) {
            context.addToPool(new LootPoolEntryContainer[]{LootItem.m_79579_((ItemLike)((ItemLike)ModBlocks.DRIED_GHAST.get())).m_79707_(10).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_7512_()});
        }
        if (path.equals((Object)EntityType.f_20501_.m_20677_())) {
            context.addPool(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.MUSIC_DISC_LAVA_CHICKEN.get()))).m_79080_(LootItemKilledByPlayerCondition.m_81901_()).m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36642_(EntityFlagsPredicate.Builder.m_33713_().m_33717_(Boolean.valueOf(true)).m_33716_()).m_36644_(EntityPredicate.Builder.m_36633_().m_36636_(EntityType.f_20555_).m_36662_()))));
        }
    }
}

