/*
 * Decompiled with CFR 0.152.
 */
package tfar.shippingbin.menu;

import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import tfar.shippingbin.init.ModMenuTypes;
import tfar.shippingbin.init.ModSounds;
import tfar.shippingbin.inventory.CommonHandler;

public class ShippingBinMenu<H extends CommonHandler>
extends AbstractContainerMenu {
    private final H inputWrapper;
    private final H outputWrapper;

    public ShippingBinMenu(int id, Inventory inventory) {
        this(id, inventory, CommonHandler.create(27), CommonHandler.create(27));
    }

    public ShippingBinMenu(int id, Inventory inventory, H input, H output) {
        this(ModMenuTypes.SHIPPING_BIN, id, inventory, input, output);
    }

    public ShippingBinMenu(MenuType<?> type, int id, Inventory inventory, H input, H output) {
        super(type, id);
        int j;
        int i;
        this.inputWrapper = new HandlerWrapper(this, input);
        this.outputWrapper = new OutputWrapper(this, output);
        if (!inventory.f_35978_.m_9236_().f_46443_) {
            this.playSound(inventory.f_35978_, ModSounds.OPEN);
        }
        int containerX = 8;
        int containerY = 18;
        int height = 3;
        int width = 9;
        int playerX = 8;
        int playerY = 153;
        for (i = 0; i < height; ++i) {
            for (j = 0; j < width; ++j) {
                this.m_38897_(this.inputWrapper.addInvSlot(j + width * i, containerX + j * 18, containerY + i * 18));
            }
        }
        for (i = 0; i < height; ++i) {
            for (j = 0; j < width; ++j) {
                this.m_38897_(this.outputWrapper.addInvSlot(j + width * i, containerX + j * 18, containerY + i * 18 + 54 + 13));
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inventory, j + i * 9 + 9, j * 18 + playerX, i * 18 + playerY));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)inventory, i, i * 18 + playerX, playerY + 58));
        }
    }

    void playSound(Player player, SoundEvent pSound) {
        Vec3i vec3i = Direction.UP.m_122436_();
        double d0 = player.m_20185_() + 0.5 + (double)vec3i.m_123341_() / 2.0;
        double d1 = player.m_20186_() + 0.5 + (double)vec3i.m_123342_() / 2.0;
        double d2 = player.m_20189_() + 0.5 + (double)vec3i.m_123343_() / 2.0;
        player.m_9236_().m_6263_(null, d0, d1, d2, pSound, SoundSource.BLOCKS, 0.5f, player.m_9236_().f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    public boolean m_5622_(Slot slot) {
        return slot.f_40219_ >= this.inputWrapper.$getSlotCount() + this.outputWrapper.$getSlotCount();
    }

    public ItemStack m_7648_(Player player, int slotId) {
        Slot slot = (Slot)this.f_38839_.get(slotId);
        ItemStack stack = ItemStack.f_41583_;
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            stack = slotStack.m_41777_();
            if (slotId < this.inputWrapper.$getSlotCount()) {
                ItemStack taken = this.inputWrapper.$extractStack(slotId, stack.m_41613_(), false);
                if (!taken.m_41619_()) {
                    slot.m_142406_(player, stack);
                    player.m_36356_(taken);
                    if (!taken.m_41619_()) {
                        player.m_36176_(taken, false);
                    }
                }
                return taken;
            }
            if (slotId - this.inputWrapper.$getSlotCount() < this.outputWrapper.$getSlotCount()) {
                ItemStack taken = this.outputWrapper.$extractStack(slotId - this.inputWrapper.$getSlotCount(), stack.m_41613_(), false);
                if (!taken.m_41619_()) {
                    slot.m_142406_(player, stack);
                    player.m_36356_(taken);
                    if (!taken.m_41619_()) {
                        player.m_36176_(taken, false);
                    }
                }
                return taken;
            }
            if (!this.m_38903_(slotStack, 0, this.inputWrapper.$getSlotCount(), false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == stack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slotStack);
        }
        return stack;
    }

    protected boolean m_38903_(ItemStack pStack, int pStartIndex, int pEndIndex, boolean pReverseDirection) {
        boolean flag = false;
        int i = pStartIndex;
        if (pReverseDirection) {
            i = pEndIndex - 1;
        }
        if (pStack.m_41753_()) {
            while (!pStack.m_41619_() && !(!pReverseDirection ? i >= pEndIndex : i < pStartIndex)) {
                Slot slot = (Slot)this.f_38839_.get(i);
                ItemStack itemstack = slot.m_7993_();
                if (!itemstack.m_41619_() && slot.m_5857_(pStack) && ItemStack.m_150942_((ItemStack)pStack, (ItemStack)itemstack)) {
                    int maxSize;
                    int j = itemstack.m_41613_() + pStack.m_41613_();
                    if (j <= (maxSize = Math.min(slot.m_6641_(), pStack.m_41741_()))) {
                        pStack.m_41764_(0);
                        itemstack.m_41764_(j);
                        slot.m_6654_();
                        flag = true;
                    } else if (itemstack.m_41613_() < maxSize) {
                        pStack.m_41774_(maxSize - itemstack.m_41613_());
                        itemstack.m_41764_(maxSize);
                        slot.m_6654_();
                        flag = true;
                    }
                }
                if (pReverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!pStack.m_41619_()) {
            i = pReverseDirection ? pEndIndex - 1 : pStartIndex;
            while (!(!pReverseDirection ? i >= pEndIndex : i < pStartIndex)) {
                Slot slot1 = (Slot)this.f_38839_.get(i);
                ItemStack itemstack1 = slot1.m_7993_();
                if (itemstack1.m_41619_() && slot1.m_5857_(pStack)) {
                    if (pStack.m_41613_() > slot1.m_6641_()) {
                        slot1.m_269060_(pStack.m_41620_(slot1.m_6641_()));
                    } else {
                        slot1.m_269060_(pStack.m_41620_(pStack.m_41613_()));
                    }
                    slot1.m_6654_();
                    flag = true;
                    break;
                }
                if (pReverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public void m_6877_(Player $$0) {
        super.m_6877_($$0);
        if ($$0 instanceof ServerPlayer) {
            this.playSound($$0, ModSounds.CLOSE);
        }
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public static class HandlerWrapper
    implements CommonHandler {
        protected final H wrapped;
        final /* synthetic */ ShippingBinMenu this$0;

        public HandlerWrapper(H wrapped) {
            this.this$0 = this$0;
            this.wrapped = wrapped;
        }

        @Override
        public int $getSlotCount() {
            return this.wrapped.$getSlotCount();
        }

        @Override
        public ItemStack $getStack(int slot) {
            return this.wrapped.$getStack(slot);
        }

        @Override
        public void $setStack(int slot, ItemStack stack) {
            this.wrapped.$setStack(slot, stack);
        }

        @Override
        public CompoundTag $serialize() {
            return null;
        }

        @Override
        public void $deserialize(CompoundTag invTag) {
        }

        @Override
        public int $getMaxStackSize(int slot) {
            return this.wrapped.$getMaxStackSize(slot);
        }

        @Override
        public ItemStack $insertStack(int slot, @NotNull ItemStack stack, boolean simulate) {
            return this.wrapped.$insertStack(slot, stack, simulate);
        }

        @Override
        public ItemStack $slotlessInsertStack(@NotNull ItemStack stack, int amount, boolean simulate) {
            return this.wrapped.$slotlessInsertStack(stack, amount, simulate);
        }

        @Override
        public ItemStack $extractStack(int slot, int amount, boolean simulate) {
            return this.wrapped.$extractStack(slot, amount, simulate);
        }

        @Override
        public boolean $isValid(ItemStack stack) {
            return this.wrapped.$isValid(stack);
        }

        @Override
        public void $setPredicate(Predicate<ItemStack> predicate) {
            this.wrapped.$setPredicate(predicate);
        }

        @Override
        public Slot addInvSlot(final int slot, int x, int y) {
            return new Slot((Container)new SimpleContainer(0), slot, x, y){

                public ItemStack m_7993_() {
                    return HandlerWrapper.this.$getStack(slot);
                }

                public void m_5852_(ItemStack stack) {
                    HandlerWrapper.this.$setStack(slot, stack);
                    this.m_6654_();
                }

                public void m_6654_() {
                }

                public int m_6641_() {
                    return HandlerWrapper.this.$getMaxStackSize(slot);
                }

                @NotNull
                public ItemStack m_6201_(int amount) {
                    return HandlerWrapper.this.$extractStack(slot, amount, false);
                }

                public ItemStack m_150647_(int count, int decrement, Player player) {
                    Optional<ItemStack> $$3 = this.m_150641_(count, decrement, player);
                    $$3.ifPresent(stack -> this.m_142406_(player, (ItemStack)stack));
                    return $$3.orElse(ItemStack.f_41583_);
                }

                public void m_269060_(ItemStack stack) {
                    super.m_269060_(stack);
                }

                public Optional<ItemStack> m_150641_(int count, int decrement, Player player) {
                    ItemStack extract = HandlerWrapper.this.$extractStack(slot, Math.min(count, decrement), false);
                    return Optional.of(extract);
                }

                public boolean m_5857_(ItemStack stack) {
                    return HandlerWrapper.this != HandlerWrapper.this.this$0.outputWrapper && HandlerWrapper.this.$isValid(stack);
                }

                public ItemStack m_150656_(ItemStack stack, int amount) {
                    if (HandlerWrapper.this == HandlerWrapper.this.this$0.outputWrapper) {
                        return stack;
                    }
                    ItemStack stack1 = HandlerWrapper.this.$slotlessInsertStack(stack, amount, false);
                    return stack1;
                }
            };
        }
    }

    public static class OutputWrapper
    extends HandlerWrapper {
        final /* synthetic */ ShippingBinMenu this$0;

        public OutputWrapper(H wrapped) {
            this.this$0 = this$0;
            super((ShippingBinMenu)this$0, wrapped);
        }

        @Override
        public boolean $isValid(ItemStack stack) {
            return false;
        }

        @Override
        public ItemStack $insertStack(int slot, @NotNull ItemStack stack, boolean simulate) {
            return stack;
        }
    }
}

