/*
 * Decompiled with CFR 0.152.
 */
package tfar.shippingbin.level;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.saveddata.SavedData;
import org.apache.commons.lang3.tuple.Pair;
import tfar.shippingbin.ShippingBin;
import tfar.shippingbin.inventory.CommonHandler;

public class ShippingBinInventories
extends SavedData {
    protected final ServerLevel level;
    Map<UUID, Pair<CommonHandler, CommonHandler>> handlerMap = new HashMap<UUID, Pair<CommonHandler, CommonHandler>>();
    public static final Predicate<ItemStack> ONLY_INPUTS = stack -> ShippingBin.getTradeManager().isInput((ItemStack)stack);

    public ShippingBinInventories(ServerLevel level) {
        this.level = level;
    }

    public CompoundTag m_7176_(CompoundTag compoundTag) {
        ListTag listTag = new ListTag();
        for (Map.Entry<UUID, Pair<CommonHandler, CommonHandler>> handlerEntry : this.handlerMap.entrySet()) {
            CompoundTag tag = new CompoundTag();
            tag.m_128362_("uuid", handlerEntry.getKey());
            Pair<CommonHandler, CommonHandler> pair = handlerEntry.getValue();
            tag.m_128365_("input", (Tag)((CommonHandler)pair.getKey()).$serialize());
            tag.m_128365_("output", (Tag)((CommonHandler)pair.getValue()).$serialize());
            listTag.add((Object)tag);
        }
        compoundTag.m_128365_("contents", (Tag)listTag);
        return compoundTag;
    }

    public Map<UUID, Pair<CommonHandler, CommonHandler>> getHandlerMap() {
        return this.handlerMap;
    }

    public Pair<CommonHandler, CommonHandler> getInventory(UUID uuid) {
        return this.handlerMap.computeIfAbsent(uuid, uuid1 -> {
            Object input = CommonHandler.create(27);
            input.$setPredicate(ONLY_INPUTS);
            return Pair.of(input, CommonHandler.create(27));
        });
    }

    protected void load(CompoundTag compoundTag) {
        ListTag listTag = compoundTag.m_128437_("contents", 10);
        for (Tag tag : listTag) {
            CompoundTag compoundTag1 = (CompoundTag)tag;
            UUID uuid = compoundTag1.m_128342_("uuid");
            Object commonHandler = CommonHandler.create(27);
            commonHandler.$setPredicate(ONLY_INPUTS);
            commonHandler.$deserialize(compoundTag1.m_128469_("input"));
            Object output = CommonHandler.create(27);
            output.$deserialize(compoundTag1.m_128469_("output"));
            this.handlerMap.put(uuid, (Pair<CommonHandler, CommonHandler>)Pair.of(commonHandler, output));
        }
    }

    public void m_77757_(File file) {
        super.m_77757_(file);
    }

    public static ShippingBinInventories getOrCreateInstance(MinecraftServer server) {
        ServerLevel overworld = server.m_129783_();
        return (ShippingBinInventories)overworld.m_8895_().m_164861_(compoundTag -> ShippingBinInventories.loadStatic(compoundTag, overworld), () -> new ShippingBinInventories(overworld), "shippingbin");
    }

    public boolean m_77764_() {
        return true;
    }

    public static ShippingBinInventories loadStatic(CompoundTag compoundTag, ServerLevel level) {
        ShippingBinInventories inventories = new ShippingBinInventories(level);
        inventories.load(compoundTag);
        return inventories;
    }
}

