/*
 * Decompiled with CFR 0.152.
 */
package tfar.shippingbin.datagen;

import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import tfar.shippingbin.datagen.ModLangProvider;
import tfar.shippingbin.datagen.data.ModBlockTagsProvider;
import tfar.shippingbin.datagen.data.ModLootTableProvider;
import tfar.shippingbin.datagen.data.ModRecipeProvider;
import tfar.shippingbin.datagen.data.TradeProvider;

public class ModDatagen {
    public static void gather(GatherDataEvent event) {
        boolean client = event.includeClient();
        DataGenerator dataGenerator = event.getGenerator();
        PackOutput packOutput = dataGenerator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        dataGenerator.addProvider(client, (DataProvider)new ModLangProvider(packOutput));
        dataGenerator.addProvider(true, (DataProvider)ModLootTableProvider.create(packOutput));
        dataGenerator.addProvider(true, (DataProvider)new ModBlockTagsProvider(packOutput, lookupProvider, existingFileHelper));
        dataGenerator.addProvider(true, (DataProvider)new ModRecipeProvider(packOutput));
        dataGenerator.addProvider(true, (DataProvider)new TradeProvider(packOutput));
    }

    public static Stream<Block> getKnownBlocks() {
        return ModDatagen.getKnown(BuiltInRegistries.f_256975_);
    }

    public static Stream<Item> getKnownItems() {
        return ModDatagen.getKnown(BuiltInRegistries.f_257033_);
    }

    public static <V> Stream<V> getKnown(Registry<V> registry) {
        return registry.m_123024_().filter(o -> registry.m_7981_(o).m_135827_().equals("shippingbin"));
    }
}

