/*
 * Decompiled with CFR 0.152.
 */
package net.untitledduckmod.common.item;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.untitledduckmod.common.entity.DuckEntity;
import net.untitledduckmod.common.helper.NbtUuidHelper;
import net.untitledduckmod.common.init.ModEntityTypes;
import net.untitledduckmod.common.init.ModItems;
import net.untitledduckmod.common.init.ModSoundEvents;

public class DuckSackItem
extends Item {
    public DuckSackItem(Item.Properties settings) {
        super(settings);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        if (!world.f_46443_) {
            BlockPos pos = context.m_8083_();
            BlockState blockState = world.m_8055_(pos);
            Player user = context.m_43723_();
            Direction blockSide = context.m_43719_();
            InteractionHand hand = context.m_43724_();
            ItemStack stack = context.m_43722_();
            if (user != null) {
                user.m_6674_(hand);
                BlockPos placePos = blockState.m_60812_((BlockGetter)world, pos).m_83281_() ? pos : pos.m_121945_(blockSide);
                if (this.placeCreature((ServerLevel)world, placePos, stack.m_41784_())) {
                    world.m_142346_((Entity)user, GameEvent.f_157810_, pos);
                    ItemStack emptySack = new ItemStack((ItemLike)ModItems.EMPTY_DUCK_SACK.get());
                    if (!user.m_150110_().f_35937_) {
                        stack.m_41774_(1);
                    }
                    if (stack.m_41619_()) {
                        user.m_21008_(hand, emptySack);
                    } else if (!user.m_36356_(emptySack)) {
                        user.m_36176_(emptySack, false);
                    }
                    world.m_5594_(user, pos, ModSoundEvents.DUCK_SACK_USE.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                    return InteractionResult.CONSUME;
                }
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack stack = user.m_21120_(hand);
        BlockHitResult blockHitResult = DuckSackItem.m_41435_((Level)world, (Player)user, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (blockHitResult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (!(world instanceof ServerLevel)) {
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        BlockPos pos = blockHitResult.m_82425_();
        if (!(world.m_8055_(pos).m_60734_() instanceof LiquidBlock)) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (world.m_7966_(user, pos) && user.m_36204_(pos, blockHitResult.m_82434_(), stack)) {
            if (this.placeCreature((ServerLevel)world, pos, stack.m_41784_())) {
                user.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                world.m_142346_((Entity)user, GameEvent.f_157810_, pos);
                ItemStack emptySack = new ItemStack((ItemLike)ModItems.EMPTY_DUCK_SACK.get());
                if (!user.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                if (stack.m_41619_()) {
                    user.m_21008_(hand, emptySack);
                } else if (!user.m_36356_(emptySack)) {
                    user.m_36176_(emptySack, false);
                }
                world.m_5594_(user, pos, ModSoundEvents.DUCK_SACK_USE.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                return InteractionResultHolder.m_19096_((Object)stack);
            }
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    private boolean placeCreature(ServerLevel world, BlockPos pos, CompoundTag itemData) {
        UUID uuid;
        CompoundTag entityData = itemData.m_128469_("EntityTag");
        if (NbtUuidHelper.containsUuid(entityData, "UUID") && world.m_8791_(uuid = NbtUuidHelper.getUuid(entityData, "UUID")) != null) {
            entityData.m_128473_("UUID");
        }
        String entityType = EntityType.m_20613_(ModEntityTypes.getDuck()).toString();
        if (!entityData.m_128441_("id")) {
            entityData.m_128359_("id", entityType);
        }
        return EntityType.m_20642_((CompoundTag)entityData, (Level)world).map(newDuck -> {
            if (newDuck instanceof DuckEntity) {
                DuckEntity duck = (DuckEntity)((Object)newDuck);
                duck.m_20258_(entityData);
                duck.setFromSack(true);
                duck.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.4, (double)pos.m_123343_() + 0.5, Mth.m_14177_((float)(world.f_46441_.m_188501_() * 360.0f)), 0.0f);
                world.m_7967_((Entity)duck);
            }
            return newDuck;
        }).isPresent();
    }

    public Component m_7626_(ItemStack stack) {
        CompoundTag itemData;
        if (stack.m_41782_() && (itemData = stack.m_41783_()) != null && itemData.m_128441_("EntityTag") && itemData.m_128469_("EntityTag").m_128441_("CustomName")) {
            MutableComponent duckName = Component.Serializer.m_130701_((String)itemData.m_128469_("EntityTag").m_128461_("CustomName"));
            return Component.m_237110_((String)"item.untitledduckmod.duck_sack.named", (Object[])new Object[]{duckName});
        }
        return super.m_7626_(stack);
    }
}

