/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.creeperhost.polylib.data.serializable.AbstractDataStore;
import net.creeperhost.polylib.network.PolyLibNetwork;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TileDataManager<BE extends BlockEntity> {
    protected static final Logger LOGGER = LogManager.getLogger();
    protected final BE tile;
    protected Map<String, AbstractDataStore<?>> dataStoreMap = new HashMap();
    protected Map<AbstractDataStore<?>, Integer> dataFlags = new HashMap();
    protected List<AbstractDataStore<?>> dataOrder = new ArrayList();

    public TileDataManager(BE tile) {
        this.tile = tile;
    }

    public <D extends AbstractDataStore<?>> D register(String name, D data, int ... flags) {
        assert (ResourceLocation.m_135830_((String)name));
        int combinedFlags = 0;
        for (int flag : flags) {
            combinedFlags |= flag;
        }
        this.dataStoreMap.put(name, data);
        this.dataFlags.put(data, combinedFlags);
        this.dataOrder.add(data);
        return data;
    }

    public void tick() {
        if (this.tile.m_58904_().m_5776_()) {
            return;
        }
        boolean changes = false;
        for (AbstractDataStore<?> data : this.dataOrder) {
            if (!data.isDirty(true)) continue;
            this.sendToClient(data);
            changes = true;
        }
        if (changes) {
            this.tile.m_6596_();
        }
    }

    public void load(CompoundTag tag) {
        this.dataStoreMap.forEach((name, data) -> {
            if ((this.dataFlags.get(data) & 8) > 0 && tag.m_128441_(name)) {
                data.fromTag(tag.m_128423_(name));
            }
        });
    }

    public void save(CompoundTag tag) {
        this.dataStoreMap.forEach((name, data) -> {
            if ((this.dataFlags.get(data) & 8) > 0) {
                tag.m_128365_(name, data.toTag());
            }
        });
    }

    public void loadFromItem(CompoundTag tag) {
        this.dataStoreMap.forEach((name, data) -> {
            if ((this.dataFlags.get(data) & 1) > 0 && tag.m_128441_(name)) {
                data.fromTag(tag.m_128423_(name));
            }
        });
    }

    public void saveToItem(CompoundTag tag) {
        this.dataStoreMap.forEach((name, data) -> {
            if ((this.dataFlags.get(data) & 1) > 0) {
                tag.m_128365_(name, data.toTag());
            }
        });
    }

    protected void sendToClient(AbstractDataStore<?> data) {
        if ((this.dataFlags.get(data) & 4) == 0) {
            return;
        }
        int index = this.dataOrder.indexOf(data);
        BlockPos pos = this.tile.m_58899_();
        PolyLibNetwork.sendTileDataValueToClients(this.tile.m_58904_(), pos, buf -> {
            buf.m_130064_(pos);
            buf.m_130130_(index);
            data.toBytes((FriendlyByteBuf)buf);
        });
    }

    public void handleSyncFromServer(Player player, FriendlyByteBuf packet) {
        int index = packet.m_130242_();
        this.dataOrder.get(index).fromBytes(packet);
    }

    public void handleSyncFromClient(ServerPlayer player, FriendlyByteBuf packet) {
        int index = packet.m_130242_();
        AbstractDataStore<?> data = this.dataOrder.get(index);
        if ((this.dataFlags.get(data) & 2) > 0) {
            data.fromBytes(packet);
            data.markDirty();
        }
    }
}

