/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.data;

import java.util.function.Consumer;
import net.creeperhost.polylib.PolyLibClient;
import net.creeperhost.polylib.data.TileDataManager;
import net.creeperhost.polylib.data.serializable.AbstractDataStore;
import net.creeperhost.polylib.network.PolyLibNetwork;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public interface DataManagerBlock {
    public static final int SAVE = 8;
    public static final int SYNC = 4;
    public static final int CLIENT_CONTROL = 2;
    public static final int SAVE_TO_ITEM = 1;
    public static final int SAVE_BOTH = 9;

    public TileDataManager<?> getDataManager();

    default public void sendPacketToServer(int id, Consumer<FriendlyByteBuf> packetWriter) {
        TileDataManager<?> manager = this.getDataManager();
        if (!manager.tile.m_58904_().m_5776_()) {
            return;
        }
        Player player = PolyLibClient.getClientPlayer();
        if (player == null) {
            return;
        }
        AbstractContainerMenu container = player.f_36096_;
        PolyLibNetwork.sendPacketToServerTile(buf -> {
            buf.m_130130_(container.f_38840_);
            buf.m_130130_(id);
            packetWriter.accept((FriendlyByteBuf)buf);
        });
    }

    default public <T> void sendDataValueToServer(AbstractDataStore<T> data, T value) {
        TileDataManager<?> manager = this.getDataManager();
        if (!manager.tile.m_58904_().m_5776_()) {
            return;
        }
        Player player = PolyLibClient.getClientPlayer();
        if (player == null) {
            return;
        }
        int index = manager.dataOrder.indexOf(data);
        PolyLibNetwork.sendDataValueToServerTile(buf -> {
            buf.m_130130_(player.f_36096_.f_38840_);
            Object prev = data.get();
            data.set(value);
            buf.m_130130_(index);
            data.toBytes((FriendlyByteBuf)buf);
            data.set(prev);
            data.isDirty(true);
        });
    }

    default public void handlePacketFromClient(ServerPlayer player, int id, FriendlyByteBuf buf) {
    }
}

