/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.modulargui.elements;

import java.util.function.Function;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.lib.Assembly;
import net.creeperhost.polylib.client.modulargui.lib.BackgroundRender;
import net.creeperhost.polylib.client.modulargui.lib.GuiRender;
import net.creeperhost.polylib.client.modulargui.lib.container.ContainerScreenAccess;
import net.creeperhost.polylib.client.modulargui.lib.container.SlotGroup;
import net.creeperhost.polylib.client.modulargui.lib.geometry.ConstrainedGeometry;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Constraint;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoParam;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GuiParent;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Position;
import net.creeperhost.polylib.client.modulargui.sprite.Material;
import net.creeperhost.polylib.client.modulargui.sprite.PolyTextures;
import net.creeperhost.polylib.containers.slots.PolySlot;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.NotNull;

public class GuiSlots
extends GuiElement<GuiSlots>
implements BackgroundRender {
    public static final Material[] ARMOR_SLOTS = new Material[]{Material.fromAtlas(InventoryMenu.f_39692_, "item/empty_armor_slot_helmet"), Material.fromAtlas(InventoryMenu.f_39692_, "item/empty_armor_slot_chestplate"), Material.fromAtlas(InventoryMenu.f_39692_, "item/empty_armor_slot_leggings"), Material.fromAtlas(InventoryMenu.f_39692_, "item/empty_armor_slot_boots")};
    public static final Material OFF_HAND_SLOT = Material.fromAtlas(InventoryMenu.f_39692_, "item/empty_armor_slot_shield");
    private final int firstSlot;
    private final int slotCount;
    private final int columns;
    private final SlotGroup slots;
    private final ContainerScreenAccess<?> screenAccess;
    private Function<Slot, Material> slotTexture = slot -> PolyTextures.getUncached("widgets/slot");
    private Function<Slot, Material> slotIcons = slot -> null;
    private Function<Slot, Integer> highlightColour = slot -> -2130706433;
    private TriConsumer<Slot, Position, GuiRender> slotOverlay = null;
    private int xSlotSpacing = 0;
    private int ySlotSpacing = 0;

    public GuiSlots(@NotNull GuiParent<?> parent, ContainerScreenAccess<?> screenAccess, SlotGroup slots, int gridColumns) {
        this(parent, screenAccess, slots, 0, slots.size(), gridColumns);
    }

    public GuiSlots(@NotNull GuiParent<?> parent, ContainerScreenAccess<?> screenAccess, SlotGroup slots, int firstSlot, int slotCount, int gridColumns) {
        super(parent);
        this.screenAccess = screenAccess;
        this.slots = slots;
        this.firstSlot = firstSlot;
        this.slotCount = slotCount;
        this.columns = gridColumns;
        if (firstSlot + slotCount > slots.size()) {
            throw new IllegalStateException("Specified slot range is out of bounds, Last slot in group is at index " + (slots.size() - 1) + " Specified range is from index " + firstSlot + " to " + (firstSlot + slotCount - 1));
        }
        int columns = Math.min(gridColumns, slotCount);
        this.constrain(GeoParam.WIDTH, Constraint.dynamic(() -> (double)(columns * 18) + (double)((columns - 1) * this.xSlotSpacing)));
        int rows = Math.max(1, slotCount / gridColumns);
        this.constrain(GeoParam.HEIGHT, Constraint.dynamic(() -> (double)(rows * 18) + (double)((rows - 1) * this.ySlotSpacing)));
        for (int index = 0; index < slotCount; ++index) {
            PolySlot slot2 = slots.getSlot(index + firstSlot);
            this.getModularGui().setSlotHandler(slot2, this);
        }
        this.updateSlots(parent.getModularGui().getRoot());
    }

    public GuiSlots setSlotTexture(Material slotTexture) {
        this.slotTexture = e -> slotTexture;
        return this;
    }

    public GuiSlots setSlotTextureS(Function<Slot, Material> slotTexture) {
        this.slotTexture = slotTexture;
        return this;
    }

    public GuiSlots setSlotTexture(Function<Integer, Material> slotTexture) {
        this.slotTexture = slot -> (Material)slotTexture.apply(this.slots.indexOf((Slot)slot) - this.firstSlot);
        return this;
    }

    public GuiSlots setHighlightColour(int highlightColour) {
        return this.setHighlightColourS(slot -> highlightColour);
    }

    public GuiSlots setHighlightColourS(Function<Slot, Integer> highlightColour) {
        this.highlightColour = highlightColour;
        return this;
    }

    public GuiSlots setHighlightColour(Function<Integer, Integer> highlightColour) {
        this.highlightColour = slot -> (Integer)highlightColour.apply(this.slots.indexOf((Slot)slot) - this.firstSlot);
        return this;
    }

    public GuiSlots setEmptyIcon(Material texture) {
        return this.setEmptyIconS(index -> texture);
    }

    public GuiSlots setEmptyIconS(Function<Slot, Material> slotIcons) {
        this.slotIcons = slotIcons;
        return this;
    }

    public GuiSlots setEmptyIcon(Function<Integer, Material> slotIcons) {
        this.slotIcons = slot -> (Material)slotIcons.apply(this.slots.indexOf((Slot)slot) - this.firstSlot);
        return this;
    }

    public GuiSlots setSlotOverlayS(TriConsumer<Slot, Position, GuiRender> slotOverlay) {
        this.slotOverlay = slotOverlay;
        return this;
    }

    public GuiSlots setSlotOverlay(TriConsumer<Integer, Position, GuiRender> slotOverlay) {
        this.slotOverlay = (slot, position, render) -> slotOverlay.accept((Object)(this.slots.indexOf((Slot)slot) - this.firstSlot), position, render);
        return this;
    }

    public GuiSlots setXSlotSpacing(int xSlotSpacing) {
        this.xSlotSpacing = xSlotSpacing;
        return this;
    }

    public GuiSlots setYSlotSpacing(int ySlotSpacing) {
        this.ySlotSpacing = ySlotSpacing;
        return this;
    }

    public GuiSlots setSlotSpacing(int xSlotSpacing, int ySlotSpacing) {
        this.xSlotSpacing = xSlotSpacing;
        this.ySlotSpacing = ySlotSpacing;
        return this;
    }

    @Override
    public double getBackgroundDepth() {
        return 33.0;
    }

    private void updateSlots(GuiElement<?> root) {
        int columns = Math.min(this.columns, this.slotCount);
        int rows = Math.max(1, this.slotCount / columns);
        double width = columns * 18 + (columns - 1) * this.xSlotSpacing;
        double height = rows * 18 + (rows - 1) * this.ySlotSpacing;
        int top = (int)(this.yCenter() - height / 2.0 - root.yMin());
        int left = (int)(this.xCenter() - width / 2.0 - root.xMin());
        for (int index = 0; index < this.slotCount; ++index) {
            PolySlot slot = this.slots.getSlot(index + this.firstSlot);
            int x = index % columns;
            int y = index / columns;
            slot.f_40220_ = left + x * 18 + 1 + x * this.xSlotSpacing;
            slot.f_40221_ = top + y * 18 + 1 + y * this.ySlotSpacing;
        }
    }

    @Override
    public void tick(double mouseX, double mouseY) {
        super.tick(mouseX, mouseY);
    }

    @Override
    public void renderBehind(GuiRender render, double mouseX, double mouseY, float partialTicks) {
        PolySlot slot;
        int index;
        GuiElement<?> root = this.getModularGui().getRoot();
        this.updateSlots(root);
        PolySlot highlightSlot = null;
        render.pose().m_85836_();
        for (index = 0; index < this.slotCount; ++index) {
            slot = this.slots.getSlot(index + this.firstSlot);
            Material tex = this.slotTexture.apply(slot);
            if (tex == null) continue;
            render.texRect(tex, (double)slot.f_40220_ + root.xMin() - 1.0, (double)slot.f_40221_ + root.yMin() - 1.0, 18.0, 18.0);
        }
        render.pose().m_85837_(0.0, 0.0, 0.4);
        for (index = 0; index < this.slotCount; ++index) {
            Material icon;
            slot = this.slots.getSlot(index + this.firstSlot);
            if (!slot.m_6659_()) continue;
            if (!slot.m_6657_() && (icon = this.slotIcons.apply(slot)) != null) {
                render.texRect(icon, (double)slot.f_40220_ + root.xMin(), (double)slot.f_40221_ + root.yMin(), 16.0, 16.0);
            }
            this.screenAccess.renderSlot(render, slot);
            if (!GuiRender.isInRect((double)slot.f_40220_ + root.xMin(), (double)slot.f_40221_ + root.yMin(), 16.0, 16.0, mouseX, mouseY) || !slot.m_280329_() || this.blockMouseOver(this, mouseX, mouseY) || !this.isMouseOver()) continue;
            highlightSlot = slot;
        }
        render.pose().m_85837_(0.0, 0.0, this.getBackgroundDepth() - 0.8);
        if (this.slotOverlay != null) {
            for (index = 0; index < this.slotCount; ++index) {
                slot = this.slots.getSlot(index + this.firstSlot);
                if (!slot.m_6659_()) continue;
                this.slotOverlay.accept((Object)slot, (Object)Position.create((double)slot.f_40220_ + root.xMin(), (double)slot.f_40221_ + root.yMin()), (Object)render);
            }
        }
        if (highlightSlot != null) {
            render.rect((double)highlightSlot.f_40220_ + root.xMin(), (double)highlightSlot.f_40221_ + root.yMin(), 16.0, 16.0, this.highlightColour.apply(highlightSlot));
        }
        render.pose().m_85849_();
    }

    public static GuiSlots singleSlot(@NotNull GuiParent<?> parent, ContainerScreenAccess<?> screenAccess, SlotGroup slots) {
        return GuiSlots.singleSlot(parent, screenAccess, slots, 0);
    }

    public static GuiSlots singleSlot(@NotNull GuiParent<?> parent, ContainerScreenAccess<?> screenAccess, SlotGroup slots, int index) {
        return new GuiSlots(parent, screenAccess, slots, index, 1, 1);
    }

    public static Assembly<? extends GuiElement<?>, GuiSlots> player(@NotNull GuiParent<?> parent, ContainerScreenAccess<?> screenAccess, SlotGroup mainSlots, SlotGroup hotBarSlots) {
        return GuiSlots.player(parent, screenAccess, mainSlots, hotBarSlots, 3);
    }

    public static Assembly<? extends GuiElement<?>, GuiSlots> player(@NotNull GuiParent<?> parent, ContainerScreenAccess<?> screenAccess, SlotGroup mainSlots, SlotGroup hotBarSlots, int hotBarSpacing) {
        int width = 162;
        int height = 72 + hotBarSpacing;
        GuiElement container = (GuiElement)((GuiElement)((ConstrainedGeometry)new GuiElement(parent).setZStacking(false)).constrain(GeoParam.WIDTH, Constraint.literal(width))).constrain(GeoParam.HEIGHT, Constraint.literal(height));
        GuiSlots main = (GuiSlots)((GuiSlots)new GuiSlots(container, screenAccess, mainSlots, 9).constrain(GeoParam.TOP, Constraint.midPoint(container.get(GeoParam.TOP), container.get(GeoParam.BOTTOM), (double)height / -2.0))).constrain(GeoParam.LEFT, Constraint.midPoint(container.get(GeoParam.LEFT), container.get(GeoParam.RIGHT), (double)width / -2.0));
        GuiSlots bar = (GuiSlots)((GuiSlots)new GuiSlots(container, screenAccess, hotBarSlots, 9).constrain(GeoParam.TOP, Constraint.relative(main.get(GeoParam.BOTTOM), hotBarSpacing))).constrain(GeoParam.LEFT, Constraint.match(main.get(GeoParam.LEFT)));
        return new Assembly<GuiElement, GuiSlots>(container, main).addParts(bar);
    }

    public static Assembly<? extends GuiElement<?>, GuiSlots> playerWithArmor(@NotNull GuiParent<?> parent, ContainerScreenAccess<?> screenAccess, SlotGroup mainSlots, SlotGroup hotBarSlots, SlotGroup armorSlots) {
        return GuiSlots.playerWithArmor(parent, screenAccess, mainSlots, hotBarSlots, armorSlots, 3, true);
    }

    public static Assembly<? extends GuiElement<?>, GuiSlots> playerWithArmor(@NotNull GuiParent<?> parent, ContainerScreenAccess<?> screenAccess, SlotGroup mainSlots, SlotGroup hotBarSlots, SlotGroup armorSlots, int groupSpacing, boolean slotIcons) {
        int width = 180 + groupSpacing;
        int height = 72 + groupSpacing;
        GuiElement container = (GuiElement)((GuiElement)((ConstrainedGeometry)new GuiElement(parent).setZStacking(false)).constrain(GeoParam.WIDTH, Constraint.literal(width))).constrain(GeoParam.HEIGHT, Constraint.literal(height));
        GuiSlots armor = (GuiSlots)((GuiSlots)new GuiSlots(container, screenAccess, armorSlots, 1).setYSlotSpacing(groupSpacing / 3).setEmptyIcon((Integer index) -> slotIcons ? ARMOR_SLOTS[index] : null).constrain(GeoParam.TOP, Constraint.midPoint(container.get(GeoParam.TOP), container.get(GeoParam.BOTTOM), (double)height / -2.0))).constrain(GeoParam.LEFT, Constraint.midPoint(container.get(GeoParam.LEFT), container.get(GeoParam.RIGHT), (double)width / -2.0));
        GuiSlots main = (GuiSlots)((GuiSlots)new GuiSlots(container, screenAccess, mainSlots, 9).constrain(GeoParam.TOP, Constraint.match(armor.get(GeoParam.TOP)))).constrain(GeoParam.LEFT, Constraint.relative(armor.get(GeoParam.RIGHT), groupSpacing));
        GuiSlots bar = (GuiSlots)((GuiSlots)new GuiSlots(container, screenAccess, hotBarSlots, 9).constrain(GeoParam.TOP, Constraint.relative(main.get(GeoParam.BOTTOM), groupSpacing))).constrain(GeoParam.LEFT, Constraint.match(main.get(GeoParam.LEFT)));
        return new Assembly<GuiElement, GuiSlots>(container, main).addParts(bar, armor);
    }

    public static Assembly<? extends GuiElement<?>, GuiSlots> playerAllSlots(@NotNull GuiParent<?> parent, ContainerScreenAccess<?> screenAccess, SlotGroup mainSlots, SlotGroup hotBarSlots, SlotGroup armorSlots, SlotGroup offhandSlots) {
        return GuiSlots.playerAllSlots(parent, screenAccess, mainSlots, hotBarSlots, armorSlots, offhandSlots, 3, true);
    }

    public static Assembly<? extends GuiElement<?>, GuiSlots> playerAllSlots(@NotNull GuiParent<?> parent, ContainerScreenAccess<?> screenAccess, SlotGroup mainSlots, SlotGroup hotBarSlots, SlotGroup armorSlots, SlotGroup offhandSlots, int groupSpacing, boolean slotIcons) {
        int width = 198 + groupSpacing * 2;
        int height = 72 + groupSpacing;
        GuiElement container = (GuiElement)((GuiElement)((ConstrainedGeometry)new GuiElement(parent).setZStacking(false)).constrain(GeoParam.WIDTH, Constraint.literal(width))).constrain(GeoParam.HEIGHT, Constraint.literal(height));
        GuiSlots armor = (GuiSlots)((GuiSlots)new GuiSlots(container, screenAccess, armorSlots, 1).setYSlotSpacing(groupSpacing / 3).setEmptyIcon((Integer index) -> slotIcons ? ARMOR_SLOTS[index] : null).constrain(GeoParam.TOP, Constraint.midPoint(container.get(GeoParam.TOP), container.get(GeoParam.BOTTOM), (double)height / -2.0))).constrain(GeoParam.LEFT, Constraint.midPoint(container.get(GeoParam.LEFT), container.get(GeoParam.RIGHT), (double)width / -2.0));
        GuiSlots main = (GuiSlots)((GuiSlots)new GuiSlots(container, screenAccess, mainSlots, 9).constrain(GeoParam.TOP, Constraint.match(armor.get(GeoParam.TOP)))).constrain(GeoParam.LEFT, Constraint.relative(armor.get(GeoParam.RIGHT), groupSpacing));
        GuiSlots bar = (GuiSlots)((GuiSlots)new GuiSlots(container, screenAccess, hotBarSlots, 9).constrain(GeoParam.TOP, Constraint.relative(main.get(GeoParam.BOTTOM), groupSpacing))).constrain(GeoParam.LEFT, Constraint.match(main.get(GeoParam.LEFT)));
        GuiSlots offHand = (GuiSlots)((GuiSlots)new GuiSlots(container, screenAccess, offhandSlots, 1).setEmptyIcon((Integer index) -> slotIcons ? OFF_HAND_SLOT : null).constrain(GeoParam.TOP, Constraint.match(bar.get(GeoParam.TOP)))).constrain(GeoParam.LEFT, Constraint.relative(bar.get(GeoParam.RIGHT), groupSpacing));
        return new Assembly<GuiElement, GuiSlots>(container, main).addParts(bar, armor, offHand);
    }
}

