/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui.image.impl;

import com.mojang.blaze3d.Blaze3D;
import com.mojang.blaze3d.platform.NativeImage;
import com.twelvemonkeys.imageio.plugins.webp.WebPImageReaderSpi;
import dev.isxander.yacl3.debug.DebugProperties;
import dev.isxander.yacl3.gui.image.ImageRendererFactory;
import dev.isxander.yacl3.gui.image.impl.DynamicTextureImage;
import dev.isxander.yacl3.gui.utils.GuiUtils;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.IntStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

public class AnimatedDynamicTextureImage
extends DynamicTextureImage {
    private int currentFrame;
    private double lastFrameTime;
    private final double[] frameDelays;
    private final int frameCount;
    private final int packCols;
    private final int packRows;
    private final int frameWidth;
    private final int frameHeight;

    public AnimatedDynamicTextureImage(NativeImage image, int frameWidth, int frameHeight, int frameCount, double[] frameDelayMS, int packCols, int packRows, ResourceLocation uniqueLocation) {
        super(image, uniqueLocation);
        this.frameWidth = frameWidth;
        this.frameHeight = frameHeight;
        this.frameCount = frameCount;
        this.frameDelays = frameDelayMS;
        this.packCols = packCols;
        this.packRows = packRows;
    }

    @Override
    public int render(GuiGraphics graphics, int x, int y, int renderWidth, float tickDelta) {
        if (this.image == null) {
            return 0;
        }
        float ratio = (float)renderWidth / (float)this.frameWidth;
        int targetHeight = (int)((float)this.frameHeight * ratio);
        int currentCol = this.currentFrame % this.packCols;
        int currentRow = (int)Math.floor((double)this.currentFrame / (double)this.packCols);
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)x, (float)y, 0.0f);
        graphics.m_280168_().m_85841_(ratio, ratio, 1.0f);
        GuiUtils.blitGuiTex(graphics, this.uniqueLocation, 0, 0, this.frameWidth * currentCol, this.frameHeight * currentRow, this.frameWidth, this.frameHeight, this.width, this.height, DebugProperties.IMAGE_FILTERING);
        graphics.m_280168_().m_85849_();
        if (this.frameCount > 1) {
            double timeMS = Blaze3D.m_83640_() * 1000.0;
            if (this.lastFrameTime == 0.0) {
                this.lastFrameTime = timeMS;
            }
            if (timeMS - this.lastFrameTime >= this.frameDelays[this.currentFrame]) {
                ++this.currentFrame;
                this.lastFrameTime = timeMS;
            }
            if (this.currentFrame >= this.frameCount - 1) {
                this.currentFrame = 0;
            }
        }
        return targetHeight;
    }

    public static ImageRendererFactory createGIFFromTexture(ResourceLocation textureLocation) {
        return () -> {
            ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
            Resource resource = (Resource)resourceManager.m_213713_(textureLocation).orElseThrow();
            return AnimatedDynamicTextureImage.createGIFSupplier(resource.m_215507_(), textureLocation);
        };
    }

    public static ImageRendererFactory createGIFFromPath(Path path, ResourceLocation uniqueLocation) {
        return () -> AnimatedDynamicTextureImage.createGIFSupplier(new FileInputStream(path.toFile()), uniqueLocation);
    }

    public static ImageRendererFactory createWEBPFromTexture(ResourceLocation textureLocation) {
        return () -> {
            ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
            Resource resource = (Resource)resourceManager.m_213713_(textureLocation).orElseThrow();
            return AnimatedDynamicTextureImage.createWEBPSupplier(resource.m_215507_(), textureLocation);
        };
    }

    public static ImageRendererFactory createWEBPFromPath(Path path, ResourceLocation uniqueLocation) {
        return () -> AnimatedDynamicTextureImage.createWEBPSupplier(new FileInputStream(path.toFile()), uniqueLocation);
    }

    private static ImageRendererFactory.ImageSupplier createGIFSupplier(InputStream is, ResourceLocation uniqueLocation) {
        ImageRendererFactory.ImageSupplier imageSupplier;
        block8: {
            InputStream inputStream = is;
            try {
                ImageReader reader = ImageIO.getImageReadersBySuffix("gif").next();
                reader.setInput(ImageIO.createImageInputStream(is));
                AnimFrameProvider animFrameFunction = i -> {
                    IIOMetadata metadata = reader.getImageMetadata(i);
                    String metaFormatName = metadata.getNativeMetadataFormatName();
                    IIOMetadataNode root = (IIOMetadataNode)metadata.getAsTree(metaFormatName);
                    IIOMetadataNode graphicsControlExtensionNode = (IIOMetadataNode)root.getElementsByTagName("GraphicControlExtension").item(0);
                    int delay = Integer.parseInt(graphicsControlExtensionNode.getAttribute("delayTime")) * 10;
                    return new AnimFrame(delay, 0, 0);
                };
                imageSupplier = AnimatedDynamicTextureImage.createFromImageReader(reader, animFrameFunction, uniqueLocation);
                if (inputStream == null) break block8;
            }
            catch (Throwable reader) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable animFrameFunction) {
                            reader.addSuppressed(animFrameFunction);
                        }
                    }
                    throw reader;
                }
                catch (Exception e) {
                    CrashReport crashReport = CrashReport.m_127521_((Throwable)e, (String)"Failed to load GIF image");
                    CrashReportCategory category = crashReport.m_127514_("YACL Gui");
                    category.m_128159_("Image identifier", (Object)uniqueLocation.toString());
                    throw new ReportedException(crashReport);
                }
            }
            inputStream.close();
        }
        return imageSupplier;
    }

    private static ImageRendererFactory.ImageSupplier createWEBPSupplier(InputStream is, ResourceLocation uniqueLocation) {
        ImageRendererFactory.ImageSupplier imageSupplier;
        block9: {
            InputStream inputStream = is;
            try {
                ImageReader reader = new WebPImageReaderSpi().createReaderInstance();
                reader.setInput(ImageIO.createImageInputStream(is));
                int numImages = reader.getNumImages(true);
                AnimFrameProvider animFrameFunction = i -> null;
                if (numImages > 1) {
                    Class<?> webpReaderClass = Class.forName("com.twelvemonkeys.imageio.plugins.webp.WebPImageReader");
                    Field framesField = webpReaderClass.getDeclaredField("frames");
                    framesField.setAccessible(true);
                    List frames = (List)framesField.get(reader);
                    Class<?> animationFrameClass = Class.forName("com.twelvemonkeys.imageio.plugins.webp.AnimationFrame");
                    Field durationField = animationFrameClass.getDeclaredField("duration");
                    durationField.setAccessible(true);
                    Field boundsField = animationFrameClass.getDeclaredField("bounds");
                    boundsField.setAccessible(true);
                    animFrameFunction = i -> {
                        Rectangle bounds = (Rectangle)boundsField.get(frames.get(i));
                        return new AnimFrame((Integer)durationField.get(frames.get(i)), bounds.x, bounds.y);
                    };
                }
                imageSupplier = AnimatedDynamicTextureImage.createFromImageReader(reader, animFrameFunction, uniqueLocation);
                if (inputStream == null) break block9;
            }
            catch (Throwable reader) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable numImages) {
                            reader.addSuppressed(numImages);
                        }
                    }
                    throw reader;
                }
                catch (Throwable e) {
                    CrashReport crashReport = CrashReport.m_127521_((Throwable)e, (String)"Failed to load WEBP image");
                    CrashReportCategory category = crashReport.m_127514_("YACL Gui");
                    category.m_128159_("Image identifier", (Object)uniqueLocation.toString());
                    throw new ReportedException(crashReport);
                }
            }
            inputStream.close();
        }
        return imageSupplier;
    }

    private static ImageRendererFactory.ImageSupplier createFromImageReader(ImageReader reader, AnimFrameProvider animationProvider, ResourceLocation uniqueLocation) throws Exception {
        if (reader.isSeekForwardOnly()) {
            throw new RuntimeException("Image reader is not seekable");
        }
        int frameCount = reader.getNumImages(true);
        int frameWidth = IntStream.range(0, frameCount).map(i -> {
            try {
                return reader.getWidth(i);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).max().orElseThrow();
        int frameHeight = IntStream.range(0, frameCount).map(i -> {
            try {
                return reader.getHeight(i);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).max().orElseThrow();
        double ratio = (double)frameWidth / (double)frameHeight;
        int cols = (int)Math.ceil(Math.sqrt(frameCount) / Math.sqrt(ratio));
        int rows = (int)Math.ceil((double)frameCount / (double)cols);
        NativeImage image = new NativeImage(NativeImage.Format.RGBA, frameWidth * cols, frameHeight * rows, false);
        BufferedImage bi = null;
        Graphics graphics = null;
        double[] frameDelays = new double[frameCount];
        for (int i2 = 0; i2 < frameCount; ++i2) {
            AnimFrame frame = animationProvider.get(i2);
            if (frameCount > 1) {
                frameDelays[i2] = frame.durationMS;
            }
            if (bi == null) {
                bi = reader.read(i2);
                graphics = bi.createGraphics();
            } else {
                BufferedImage deltaFrame = reader.read(i2);
                graphics.drawImage(deltaFrame, frame.xOffset, frame.yOffset, null);
            }
            int xOffset = (frameWidth - bi.getWidth()) / 2;
            int yOffset = (frameHeight - bi.getHeight()) / 2;
            for (int w = 0; w < bi.getWidth(); ++w) {
                for (int h = 0; h < bi.getHeight(); ++h) {
                    int argb = bi.getRGB(w, h);
                    int col = i2 % cols;
                    int row = (int)Math.floor((double)i2 / (double)cols);
                    GuiUtils.setPixelARGB(image, frameWidth * col + w + xOffset, frameHeight * row + h + yOffset, argb);
                }
            }
        }
        if (graphics != null) {
            graphics.dispose();
        }
        reader.dispose();
        return () -> new AnimatedDynamicTextureImage(image, frameWidth, frameHeight, frameCount, frameDelays, cols, rows, uniqueLocation);
    }

    @FunctionalInterface
    private static interface AnimFrameProvider {
        public AnimFrame get(int var1) throws Exception;
    }

    private record AnimFrame(int durationMS, int xOffset, int yOffset) {
    }
}

