/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.world.event;

import com.google.common.collect.Multimap;
import galena.oreganized.content.block.MoltenLeadCauldronBlock;
import galena.oreganized.content.item.ScribeItem;
import galena.oreganized.content.item.ThermometerItem;
import galena.oreganized.index.OAttributes;
import galena.oreganized.index.OBlocks;
import galena.oreganized.index.OItems;
import galena.oreganized.index.OTags;
import java.util.UUID;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="oreganized")
public class PlayerEvents {
    @SubscribeEvent
    public static void blockToolInteractions(BlockEvent.BlockToolModificationEvent event) {
        ToolAction action = event.getToolAction();
        BlockState state = event.getState();
        if (event.isSimulated()) {
            return;
        }
        if (action.equals(ToolActions.AXE_WAX_OFF)) {
            Block unWaxedBlock = (Block)OBlocks.WAXED_BLOCKS.get((Object)state.m_60734_());
            if (unWaxedBlock == null) {
                return;
            }
            event.setFinalState(unWaxedBlock.m_49966_());
        }
    }

    @SubscribeEvent
    public static void blockItemInteractions(PlayerInteractEvent.RightClickBlock event) {
        Level world = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = world.m_8055_(pos);
        ItemStack itemStack = event.getItemStack();
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        if (itemStack.m_150930_(Items.f_42784_) && OBlocks.WAXED_BLOCKS.inverse().get((Object)state.m_60734_()) != null) {
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10562_.m_285767_((ServerPlayer)player, pos, itemStack);
            }
            player.m_6674_(event.getHand());
            if (!player.m_7500_()) {
                event.getItemStack().m_41774_(1);
            }
            Block waxedBlock = (Block)OBlocks.WAXED_BLOCKS.inverse().get((Object)state.m_60734_());
            if (!world.m_5776_() && waxedBlock != null) {
                world.m_7731_(pos, waxedBlock.m_49966_(), 11);
            }
            world.m_5898_(player, 3003, pos, 0);
        }
        if (itemStack.m_150930_(Items.f_42710_) && state.m_60713_((Block)OBlocks.MOLTEN_LEAD_CAULDRON.get())) {
            if (!((Integer)state.m_61143_((Property)MoltenLeadCauldronBlock.AGE)).equals(3)) {
                return;
            }
            ItemStack newDisc = new ItemStack((ItemLike)OItems.MUSIC_DISC_STRUCTURE.get());
            player.m_6674_(hand);
            if (!player.m_7500_()) {
                itemStack.m_41774_(1);
            }
            world.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11914_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!world.m_5776_()) {
                player.m_36246_(Stats.f_12982_.m_12902_((Object)itemStack.m_41720_()));
            }
            if (itemStack.m_41619_()) {
                player.m_21008_(hand, newDisc);
                return;
            }
            if (!player.m_150109_().m_36054_(newDisc)) {
                player.m_36176_(newDisc, false);
            }
            world.m_46597_(pos, Blocks.f_50256_.m_49966_());
        }
    }

    @SubscribeEvent
    public static void tickPlayer(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        CompoundTag data = event.player.getPersistentData();
        if (data.m_128425_("oreganized:gargoyle_use_cooldown", 99)) {
            int cooldown = data.m_128451_("oreganized:gargoyle_use_cooldown");
            if (cooldown > 0) {
                data.m_128405_("oreganized:gargoyle_use_cooldown", cooldown - 1);
            } else {
                data.m_128473_("oreganized:gargoyle_use_cooldown");
            }
        }
        ItemStack stack = event.player.m_21120_(InteractionHand.MAIN_HAND);
        if (event.player.m_9236_().m_46467_() % 20L != 0L) {
            return;
        }
        if (stack.m_150930_((Item)OItems.THERMOMETER.get()) && !ThermometerItem.isLocked(stack)) {
            int heatLevel = ThermometerItem.ambientMeasurement(event.player);
            ThermometerItem.setHeatLevel(stack, event.player.m_9236_(), heatLevel);
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        ScribeItem scribe;
        ItemStack stack = event.getPlayer().m_21205_();
        Item item = stack.m_41720_();
        if (item instanceof ScribeItem && (scribe = (ScribeItem)item).dropsLikeSilktouch(stack, event.getState())) {
            event.setExpToDrop(0);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onItemAttributes(ItemAttributeModifierEvent event) {
        ItemStack stack = event.getItemStack();
        Multimap mods = event.getModifiers();
        if (event.getSlotType() != EquipmentSlot.MAINHAND) {
            return;
        }
        if (stack.m_204117_(OTags.Items.HAS_KINETIC_DAMAGE) && !mods.containsKey(OAttributes.KINETIC_DAMAGE.get())) {
            float f;
            Item item = stack.m_41720_();
            if (item instanceof DiggerItem) {
                DiggerItem item2 = (DiggerItem)item;
                f = item2.m_41008_();
            } else {
                item = stack.m_41720_();
                if (item instanceof SwordItem) {
                    SwordItem item3 = (SwordItem)item;
                    f = item3.m_43299_();
                } else {
                    f = 2.0f;
                }
            }
            float damage = f;
            event.addModifier((Attribute)OAttributes.KINETIC_DAMAGE.get(), new AttributeModifier(UUID.fromString("0191ff58-54d7-711d-8a94-692379277c23"), "Kinetic Damage", (double)(damage / 3.0f), AttributeModifier.Operation.ADDITION));
        }
    }
}

