/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.content.item;

import galena.oreganized.Oreganized;
import galena.oreganized.client.accessors.GuiAccessor;
import galena.oreganized.client.tooltips.ThermometerTooltip;
import galena.oreganized.content.block.IMeltableBlock;
import galena.oreganized.index.OCriteriaTriggers;
import galena.oreganized.index.OItems;
import galena.oreganized.index.OTags;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="oreganized")
public class ThermometerItem
extends Item {
    public static final ResourceLocation BREAK_LOOT_TABLE = Oreganized.modLoc("gameplay/thermometer_breaking");
    public static final ResourceLocation PROPERTY_KEY = new ResourceLocation("level");
    private static final int AMBIENT_RANGE = 5;
    public static final int HEAT_LEVELS = 9;

    public ThermometerItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        int heat = ThermometerItem.getHeatLevel(stack);
        return Optional.of(new ThermometerTooltip(heat));
    }

    private static int heatLevel(BlockState state, LevelAccessor level, BlockPos pos) {
        if (state.m_204336_(OTags.Blocks.LAVA_HEAT_LEVEL)) {
            return 8;
        }
        if (state.m_204336_(OTags.Blocks.FIRE_HEAT_LEVEL)) {
            return 7;
        }
        if (state.getLightEmission((BlockGetter)level, pos) > 2) {
            return 4;
        }
        Block block = state.m_60734_();
        if (block instanceof IMeltableBlock) {
            IMeltableBlock block2 = (IMeltableBlock)block;
            int goopyness = block2.getGoopyness(state);
            if (goopyness > 1) {
                return 7;
            }
            if (goopyness > 0) {
                return 5;
            }
        }
        return 2;
    }

    public static int ambientMeasurement(Player player) {
        Level level = player.m_9236_();
        BlockPos pos = player.m_20183_();
        if (player.m_146900_().m_204336_(OTags.Blocks.LAVA_HEAT_LEVEL)) {
            return 8;
        }
        if (player.m_146900_().m_204336_(OTags.Blocks.FIRE_HEAT_LEVEL)) {
            return 7;
        }
        if (player.m_6060_()) {
            return 5;
        }
        if (player.m_203117_()) {
            return 0;
        }
        Biome biome = (Biome)level.m_204166_(pos).m_203334_();
        float temperature = biome.m_47554_();
        int weather = level.m_46471_() ? 0 : 1;
        return (int)(Math.max(0.0f, Math.min(2.0f, temperature) / 2.0f) * 3.0f) + weather;
    }

    public static int activeMeasurement(Level level, BlockPos pos) {
        int lavaHeatLevel;
        AABB box = new AABB(pos).m_82400_(5.0);
        int lavaDistance = BlockPos.m_121921_((AABB)box).filter(it -> level.m_8055_(it).m_204336_(OTags.Blocks.LAVA_HEAT_LEVEL)).mapToInt(it -> it.m_123333_((Vec3i)pos)).min().orElse(Integer.MAX_VALUE);
        BlockState state = level.m_8055_(pos);
        int blockHeatLevel = ThermometerItem.heatLevel(state, (LevelAccessor)level, pos);
        if (lavaDistance < 9 && (lavaHeatLevel = 8 - lavaDistance) > blockHeatLevel) {
            return lavaHeatLevel;
        }
        return blockHeatLevel;
    }

    private static int heatLevel(LivingEntity entity) {
        if (entity.m_6095_() == EntityType.f_20468_) {
            return 8;
        }
        if (entity.m_6095_() == EntityType.f_20551_) {
            return 7;
        }
        if (entity.m_6060_()) {
            return 5;
        }
        if (entity.m_21222_()) {
            return 1;
        }
        if (entity.m_21220_().stream().anyMatch(it -> !it.m_19544_().m_19486_())) {
            return 3;
        }
        return 2;
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        ItemStack held = player.m_21120_(hand);
        int heatLevel = ThermometerItem.heatLevel(target);
        ThermometerItem.setHeatLevel(held, player.m_9236_(), heatLevel);
        player.m_36335_().m_41524_(held.m_41720_(), 60);
        ThermometerItem.setLocked((Entity)player, held, true);
        return InteractionResult.m_19078_((boolean)player.m_9236_().m_5776_());
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        InteractionResultHolder<ItemStack> result;
        BlockHitResult hit = ThermometerItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (hit.m_6662_() != HitResult.Type.BLOCK) {
            return super.m_7203_(level, player, hand);
        }
        BlockPos pos = hit.m_82425_();
        BlockState state = level.m_8055_(pos);
        ItemStack stack = player.m_21120_(hand);
        if (state.m_60819_().m_205070_(FluidTags.f_13131_) && (result = ThermometerItem.extinguish(player, stack, hit.m_82450_())).m_19089_() != InteractionResult.PASS) {
            return result;
        }
        int heatLevel = ThermometerItem.activeMeasurement(level, pos);
        ThermometerItem.setHeatLevel(stack, level, heatLevel);
        player.m_36335_().m_41524_(stack.m_41720_(), 60);
        ThermometerItem.setLocked((Entity)player, stack, true);
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
    }

    private static InteractionResultHolder<ItemStack> extinguish(Player player, ItemStack stack, Vec3 pos) {
        int heatLevel = ThermometerItem.getHeatLevel(stack);
        if (heatLevel < 4) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        player.m_5496_(SoundEvents.f_11937_, 1.0f, 0.9f);
        player.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123796_, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), 0.0, 0.05, 0.0);
        if (heatLevel > 6) {
            stack.m_41774_(1);
            Level level = player.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                LootTable lootTable = level2.m_7654_().m_278653_().m_278676_(BREAK_LOOT_TABLE);
                LootParams lootParams = new LootParams.Builder(level2).m_287286_(LootContextParams.f_81460_, (Object)pos).m_287286_(LootContextParams.f_81455_, (Object)player).m_287286_(LootContextParams.f_81463_, (Object)stack).m_287235_(LootContextParamSets.f_81416_);
                ObjectArrayList drops = lootTable.m_287195_(lootParams);
                drops.forEach(drop -> {
                    if (player.m_36356_(drop)) {
                        return;
                    }
                    Containers.m_18992_((Level)level2, (double)pos.m_7096_(), (double)pos.m_7098_(), (double)pos.m_7094_(), (ItemStack)drop);
                });
                OCriteriaTriggers.BROKEN_THERMOMETER.trigger((ServerPlayer)player);
            }
        } else {
            ThermometerItem.setLocked((Entity)player, stack, false);
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)player.m_9236_().m_5776_());
    }

    public InteractionResult m_6225_(UseOnContext context) {
        return InteractionResult.PASS;
    }

    public static int getHeatLevel(ItemStack stack) {
        if (!stack.m_41782_()) {
            return 0;
        }
        return stack.m_41784_().m_128451_("OreganizedHeat");
    }

    public static void setHeatLevel(ItemStack stack, @Nullable Level level, int heatLevel) {
        Gui gui;
        if (ThermometerItem.getHeatLevel(stack) == heatLevel) {
            return;
        }
        CompoundTag nbt = stack.m_41784_();
        nbt.m_128405_("OreganizedHeat", heatLevel);
        if (level != null && level.m_5776_() && (gui = Minecraft.m_91087_().f_91065_) instanceof GuiAccessor) {
            GuiAccessor accessor = (GuiAccessor)gui;
            accessor.oreganized$setToolHighlightTimer(60);
        }
    }

    public static boolean isLocked(ItemStack stack) {
        return Optional.ofNullable(stack.m_41783_()).filter(it -> it.m_128471_("Locked")).isPresent();
    }

    private static void setLocked(@Nullable Entity user, ItemStack stack, boolean locked) {
        SoundEvent sound;
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128471_("Locked") == locked) {
            return;
        }
        tag.m_128379_("Locked", locked);
        SoundEvent soundEvent = sound = locked ? SoundEvents.f_12107_ : SoundEvents.f_276532_;
        if (user != null) {
            user.m_9236_().m_245803_(user, user.m_20183_(), sound, SoundSource.PLAYERS, 1.0f, 1.2f);
        }
    }

    @SubscribeEvent
    public static void onHitAir(PlayerInteractEvent.LeftClickEmpty event) {
        ItemStack stack = event.getItemStack();
        if (!stack.m_150930_((Item)OItems.THERMOMETER.get())) {
            return;
        }
        ThermometerItem.setLocked((Entity)event.getEntity(), stack, false);
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            OCriteriaTriggers.SHAKEN_THERMOMETER.trigger(player2);
        }
    }
}

