/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.content.entity;

import galena.oreganized.index.OCriteriaTriggers;
import galena.oreganized.index.OItems;
import galena.oreganized.index.OSoundEvents;
import galena.oreganized.index.OTags;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class LeadBoltEntity
extends AbstractArrow {
    private static boolean canShootOff(ItemStack stack, LivingEntity entity) {
        if (entity.m_6095_().m_204039_(OTags.Entities.BOLT_RESISTANT)) {
            return false;
        }
        if (stack.m_41619_()) {
            return false;
        }
        return stack.getEnchantmentLevel(Enchantments.f_44975_) <= 0;
    }

    @Nullable
    private static EquipmentSlot randomSlot(LivingEntity entity) {
        List<EquipmentSlot> slots;
        if (entity.m_6117_()) {
            InteractionHand hand = entity.m_7655_();
            ItemStack using = entity.m_21120_(hand);
            if (!LeadBoltEntity.canShootOff(using, entity)) {
                return null;
            }
            if (using.m_41720_() instanceof ShieldItem) {
                return switch (hand) {
                    default -> throw new IncompatibleClassChangeError();
                    case InteractionHand.OFF_HAND -> EquipmentSlot.OFFHAND;
                    case InteractionHand.MAIN_HAND -> EquipmentSlot.MAINHAND;
                };
            }
        }
        if ((slots = Stream.of(EquipmentSlot.CHEST, EquipmentSlot.FEET, EquipmentSlot.HEAD, EquipmentSlot.LEGS).filter(it -> LeadBoltEntity.canShootOff(entity.m_6844_(it), entity)).toList()).isEmpty()) {
            return null;
        }
        return slots.get(entity.m_217043_().m_216339_(0, slots.size()));
    }

    public LeadBoltEntity(EntityType<? extends LeadBoltEntity> type, Level level) {
        super(type, level);
    }

    public LeadBoltEntity(EntityType<? extends LeadBoltEntity> type, Level level, Position pos) {
        super(type, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), level);
    }

    public LeadBoltEntity(EntityType<? extends LeadBoltEntity> type, Level level, LivingEntity user) {
        super(type, user, level);
    }

    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)OItems.LEAD_BOLT.get());
    }

    private void damageEntity(EntityHitResult result) {
        ItemStack knockedOff;
        LivingEntity living;
        Entity entity = result.m_82443_();
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).m_217043_().m_188500_() < 0.1 && (knockedOff = this.knockOff(living)) != null) {
            Vec3 vec = result.m_82450_();
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123759_, vec.f_82479_, vec.f_82480_ + 2.0, vec.f_82481_, 4, 0.1, 0.1, 0.1, 0.0);
            }
            this.m_5496_((SoundEvent)OSoundEvents.BOLT_HIT_ARMOR.get(), 1.5f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
            level = knockedOff.m_41720_();
            if (level instanceof Equipable) {
                Equipable item = (Equipable)level;
                this.m_216990_(item.m_150681_());
            }
            if (result.m_82443_() instanceof Pillager && knockedOff.m_204117_(ItemTags.f_13191_) && (level = this.m_19749_()) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)level;
                OCriteriaTriggers.KNOCKED_BANNER_OFF.trigger(player);
            }
            this.m_146870_();
            return;
        }
        super.m_5790_(result);
    }

    protected void m_5790_(EntityHitResult result) {
        int n;
        this.m_36740_((SoundEvent)OSoundEvents.BOLT_HIT.get());
        Entity entity = result.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            n = living.m_21234_();
        } else {
            n = 0;
        }
        int arrowCount = n;
        double baseDamage = 3.0;
        this.m_36781_(baseDamage);
        if (result.m_82443_().m_6095_() == EntityType.f_20460_) {
            this.m_36781_(baseDamage * 3.0);
        }
        this.damageEntity(result);
        this.m_36781_(baseDamage);
        Entity entity2 = result.m_82443_();
        if (entity2 instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity2;
            living.m_21317_(arrowCount);
        }
    }

    protected void m_8060_(BlockHitResult result) {
        this.m_36740_((SoundEvent)OSoundEvents.BOLT_HIT.get());
        super.m_8060_(result);
    }

    private ItemStack knockOff(LivingEntity entity) {
        if (!entity.m_6125_()) {
            return null;
        }
        EquipmentSlot slot = LeadBoltEntity.randomSlot(entity);
        if (slot == null) {
            return null;
        }
        ItemStack stack = entity.m_6844_(slot);
        if (!EnchantmentHelper.m_44924_((ItemStack)stack)) {
            if (entity instanceof Mob && stack.m_41763_()) {
                stack.m_41721_(stack.m_41776_() - this.f_19796_.m_188503_(1 + this.f_19796_.m_188503_(Math.max(stack.m_41776_() - 3, 1))));
            }
            ItemEntity item = new ItemEntity(entity.m_9236_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), stack);
            item.m_32010_(40);
            this.m_9236_().m_7967_((Entity)item);
        }
        entity.m_8061_(slot, ItemStack.f_41583_);
        return stack;
    }

    public void m_37251_(Entity user, float p_37253_, float p_37254_, float p_37255_, float p_37256_, float p_37257_) {
        super.m_37251_(user, p_37253_, p_37254_, p_37255_, p_37256_ * 0.5f, p_37257_);
    }
}

