/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.content.block;

import galena.oreganized.OreganizedConfig;
import galena.oreganized.index.OBlocks;
import galena.oreganized.index.OItems;
import galena.oreganized.index.OTags;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class MoltenLeadCauldronBlock
extends AbstractCauldronBlock
implements CauldronInteraction {
    public static final Map<Item, CauldronInteraction> INTERACTION_MAP = CauldronInteraction.m_175617_();
    public static final IntegerProperty AGE = BlockStateProperties.f_61407_;
    public static final CauldronInteraction FILL_MOLTEN_LEAD = (state, world, pos, player, hand, stack) -> CauldronInteraction.m_175618_((Level)world, (BlockPos)pos, (Player)player, (InteractionHand)hand, (ItemStack)stack, (BlockState)((BlockState)((Block)OBlocks.MOLTEN_LEAD_CAULDRON.get()).m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(3))), (SoundEvent)SoundEvents.f_11780_);
    public static final CauldronInteraction EMPTY_MOLTEN_LEAD = (state, world, pos, player, hand, stack) -> CauldronInteraction.m_175635_((BlockState)state, (Level)world, (BlockPos)pos, (Player)player, (InteractionHand)hand, (ItemStack)stack, (ItemStack)new ItemStack((ItemLike)OItems.MOLTEN_LEAD_BUCKET.get()), blockState -> ((Integer)state.m_61143_((Property)AGE)).equals(3), (SoundEvent)SoundEvents.f_11783_);
    public static final CauldronInteraction FILL_LEAD_BLOCK = (state, world, pos, player, hand, stack) -> MoltenLeadCauldronBlock.placeBlock(world, pos, player, hand, stack, (BlockState)((Block)OBlocks.MOLTEN_LEAD_CAULDRON.get()).m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)), SoundEvents.f_12065_);
    public static final CauldronInteraction EMPTY_LEAD_BLOCK = (state, world, pos, player, hand, stack) -> MoltenLeadCauldronBlock.dropResource(state, world, pos, player, hand, stack, new ItemStack((ItemLike)OBlocks.LEAD_BLOCK.get()), blockState -> ((Integer)state.m_61143_((Property)AGE)).equals(0), SoundEvents.f_12016_);

    public MoltenLeadCauldronBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60953_(MoltenLeadCauldronBlock.moltenStageEmission()), INTERACTION_MAP);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)Items.f_42544_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE});
    }

    protected double m_142446_(BlockState state) {
        return 0.9375;
    }

    public static ToIntFunction<BlockState> moltenStageEmission() {
        return state -> (Integer)state.m_61143_((Property)AGE) * 2;
    }

    public boolean m_142596_(BlockState state) {
        return true;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        if (!((Integer)state.m_61143_((Property)AGE)).equals(3)) {
            return Shapes.m_83144_();
        }
        return super.m_5940_(state, world, pos, ctx);
    }

    public void m_7892_(BlockState state, Level level, BlockPos blockPos, Entity entity) {
        if (this.m_151979_(state, blockPos, entity)) {
            entity.m_20254_(10);
        }
    }

    public int m_6782_(BlockState state, Level level, BlockPos blockPos) {
        return (Integer)state.m_61143_((Property)AGE) + 1;
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        this.m_213897_(state, world, pos, random);
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!world.isAreaLoaded(pos, 1)) {
            return;
        }
        int max_age = AGE.m_6908_().size() - 1;
        int age = (Integer)state.m_61143_((Property)AGE);
        if (age < max_age && random.m_188503_(1) == 0) {
            BlockState below = world.m_8055_(pos.m_7495_());
            if ((below.m_204336_(OTags.Blocks.FIRE_SOURCE) || below.m_60819_().m_205070_(FluidTags.f_13132_)) && ((Boolean)OreganizedConfig.COMMON.cauldronLeadMelting.get()).booleanValue()) {
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age + 1)));
                return;
            }
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(Mth.m_14045_((int)(age - 1), (int)0, (int)max_age))));
        }
    }

    @NotNull
    public InteractionResult m_175710_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, ItemStack stack) {
        ItemStack itemstack = player.m_21120_(hand);
        CauldronInteraction cauldroninteraction = INTERACTION_MAP.get(itemstack.m_41720_());
        return cauldroninteraction.m_175710_(state, world, pos, player, hand, itemstack);
    }

    static InteractionResult placeBlock(Level world, BlockPos pos, Player player, InteractionHand hand, ItemStack stack, BlockState state, SoundEvent sound) {
        if (!world.f_46443_) {
            Item item = stack.m_41720_();
            player.m_36220_(Stats.f_12943_);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            world.m_46597_(pos, state);
            world.m_5594_(null, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.m_142346_(null, GameEvent.f_157797_, pos);
        }
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    }

    static InteractionResult dropResource(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, ItemStack usedStack, ItemStack droppedStack, Predicate<BlockState> stateCondition, SoundEvent sound) {
        if (!stateCondition.test(state)) {
            return InteractionResult.PASS;
        }
        if (!world.f_46443_) {
            Item item = usedStack.m_41720_();
            player.m_36220_(Stats.f_12944_);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            MoltenLeadCauldronBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)droppedStack);
            world.m_46597_(pos, Blocks.f_50256_.m_49966_());
            world.m_5594_(null, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    }
}

