/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import galena.oreganized.client.DevicePropertyFunction;
import galena.oreganized.client.render.entity.LeadBoltRender;
import galena.oreganized.client.render.entity.ShrapnelBombMinecartRender;
import galena.oreganized.client.render.entity.ShrapnelBombRender;
import galena.oreganized.client.render.gui.StunningOverlay;
import galena.oreganized.client.tooltips.ClientDeviceTooltip;
import galena.oreganized.client.tooltips.ClientThermometerTooltip;
import galena.oreganized.client.tooltips.DeviceTooltip;
import galena.oreganized.client.tooltips.ThermometerTooltip;
import galena.oreganized.content.item.DeviceItem;
import galena.oreganized.content.item.SpeedometerItem;
import galena.oreganized.content.item.ThermometerItem;
import galena.oreganized.index.OBlocks;
import galena.oreganized.index.OEntityTypes;
import galena.oreganized.index.OItems;
import galena.oreganized.world.IDoorProgressHolder;
import galena.oreganized.world.IMotionHolder;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="oreganized", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class OreganizedClient {
    private static void render(Supplier<? extends Block> block, RenderType render) {
        ItemBlockRenderTypes.setRenderLayer((Block)block.get(), (RenderType)render);
    }

    @SubscribeEvent
    public static void setup(FMLClientSetupEvent event) {
        OreganizedClient.registerBlockRenderers();
        OreganizedClient.registerItemProperties();
    }

    private static void registerItemProperties() {
        ItemProperties.register((Item)((Item)OItems.SILVER_MIRROR.get()), (ResourceLocation)new ResourceLocation("level"), (stack, world, entity, seed) -> {
            if (entity == null) {
                return 8.0f;
            }
            return stack.m_41784_().m_128451_("Level");
        });
        ItemProperties.register((Item)((Item)OItems.SPEEDOMETER.get()), (ResourceLocation)SpeedometerItem.PROPERTY_KEY, (stack, world, entity, seed) -> {
            if (entity == null) {
                return 0.0f;
            }
            Entity vehicle = entity.m_20201_();
            if (!(vehicle instanceof IMotionHolder)) {
                return 0.0f;
            }
            IMotionHolder motionHolder = (IMotionHolder)vehicle;
            return Mth.m_14036_((float)Math.round(motionHolder.oreganised$getMotion() * 100.0), (float)0.0f, (float)16.0f);
        });
        ItemProperties.register((Item)((Item)OItems.THERMOMETER.get()), (ResourceLocation)ThermometerItem.PROPERTY_KEY, (stack, world, entity, seed) -> ThermometerItem.getHeatLevel(stack));
        ItemProperties.register((Item)Items.f_42717_, (ResourceLocation)new ResourceLocation("oreganized", "lead_bolt"), (stack, level, user, i) -> CrossbowItem.m_40932_((ItemStack)stack) && CrossbowItem.m_40871_((ItemStack)stack, (Item)((Item)OItems.LEAD_BOLT.get())) ? 1.0f : 0.0f);
        ItemProperties.register((Item)((Item)OItems.ELECTRUM_SHIELD.get()), (ResourceLocation)new ResourceLocation("blocking"), (stack, level, user, i) -> user != null && user.m_6117_() && user.m_21211_() == stack ? 1.0f : 0.0f);
        ItemProperties.register((Item)((Item)OItems.UNKNOWN_DEVICE.get()), (ResourceLocation)DeviceItem.PROPERTY_KEY, (ItemPropertyFunction)new DevicePropertyFunction());
    }

    private static void registerBlockRenderers() {
        RenderType cutout = RenderType.m_110463_();
        RenderType translucent = RenderType.m_110466_();
        OreganizedClient.render(OBlocks.LEAD_DOOR, cutout);
        OreganizedClient.render(OBlocks.LEAD_TRAPDOOR, cutout);
        OreganizedClient.render(OBlocks.LEAD_BARS, cutout);
        OreganizedClient.render(OBlocks.GARGOYLE, cutout);
        OreganizedClient.render(OBlocks.WHITE_DATURA, cutout);
        OreganizedClient.render(OBlocks.PURPLE_DATURA, cutout);
        OreganizedClient.render(OBlocks.POTTED_WHITE_DATURA, cutout);
        OreganizedClient.render(OBlocks.POTTED_PURPLE_DATURA, cutout);
        OBlocks.CRYSTAL_GLASS.forEach((c, b) -> OreganizedClient.render((Supplier<? extends Block>)b, translucent));
        OBlocks.CRYSTAL_GLASS_PANES.forEach((c, b) -> OreganizedClient.render((Supplier<? extends Block>)b, translucent));
        OreganizedClient.render(OBlocks.GROOVED_ICE, translucent);
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)OEntityTypes.SHRAPNEL_BOMB.get(), ShrapnelBombRender::new);
        event.registerEntityRenderer((EntityType)OEntityTypes.SHRAPNEL_BOMB_MINECART.get(), ShrapnelBombMinecartRender::new);
        event.registerEntityRenderer((EntityType)OEntityTypes.LEAD_BOLT.get(), LeadBoltRender::new);
    }

    @SubscribeEvent
    public static void registerGuiOverlays(RegisterGuiOverlaysEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new StunningOverlay());
        event.registerAbove(VanillaGuiOverlay.FROSTBITE.id(), "stunning", (IGuiOverlay)new StunningOverlay());
    }

    public static void renderThirdPersonArm(ModelPart arm, boolean rightArm) {
        arm.f_104203_ = -1.7f;
        arm.f_104204_ = rightArm ? -0.1f : 0.2f;
    }

    @SubscribeEvent
    public static void registerClientTooltips(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(ThermometerTooltip.class, ClientThermometerTooltip::new);
        event.register(DeviceTooltip.class, ClientDeviceTooltip::new);
    }

    @Mod.EventBusSubscriber(modid="oreganized", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ForgeBusEvents {
        @SubscribeEvent
        public static void addTooltips(ItemTooltipEvent event) {
            if (event.getItemStack().m_150930_((Item)OItems.BUSH_HAMMER.get())) {
                List tooltip = event.getToolTip();
                MutableComponent wipTitle = Component.m_237115_((String)"tooltip.oreganized.wip.title");
                MutableComponent wipDesc = Component.m_237115_((String)"tooltip.oreganized.wip.description");
                tooltip.add(wipTitle.m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.BOLD));
                tooltip.add(wipDesc.m_130940_(ChatFormatting.DARK_PURPLE).m_130940_(ChatFormatting.ITALIC));
            }
        }

        @SubscribeEvent
        public static void renderHand(RenderHandEvent event) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (!(player instanceof IDoorProgressHolder)) {
                return;
            }
            IDoorProgressHolder progressHolder = (IDoorProgressHolder)player;
            int progress = progressHolder.oreganised$getOpeningProgress();
            if (progress == 0) {
                return;
            }
            if (event.getHand() == InteractionHand.OFF_HAND) {
                return;
            }
            PoseStack poseStack = event.getPoseStack();
            poseStack.m_85836_();
            boolean rightArm = player.m_5737_() == HumanoidArm.RIGHT;
            float factor = rightArm ? 1.0f : -1.0f;
            poseStack.m_252880_(factor * 0.84000003f, -0.4f, -0.4f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(factor * -20.0f - event.getSwingProgress()));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(factor * 45.0f));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-45.0f));
            PlayerRenderer renderer = (PlayerRenderer)Minecraft.m_91087_().m_91290_().m_114382_((Entity)player);
            if (rightArm) {
                renderer.m_117770_(poseStack, event.getMultiBufferSource(), event.getPackedLight(), (AbstractClientPlayer)player);
            } else {
                renderer.m_117813_(poseStack, event.getMultiBufferSource(), event.getPackedLight(), (AbstractClientPlayer)player);
            }
            poseStack.m_85849_();
            event.setCanceled(true);
        }
    }
}

