/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.common.config;

import java.util.function.Predicate;

public enum EntryType {
    BYTE(type -> type == Byte.TYPE),
    SHORT(type -> type == Short.TYPE),
    INTEGER(type -> type == Integer.TYPE),
    LONG(type -> type == Long.TYPE),
    FLOAT(type -> type == Float.TYPE),
    DOUBLE(type -> type == Double.TYPE),
    BOOLEAN(type -> type == Boolean.TYPE),
    STRING(type -> type == String.class),
    ENUM(false, Class::isEnum);

    private final boolean arrayed;
    private final Predicate<Class<?>> predicate;

    private EntryType(boolean arrayed, Predicate<Class<?>> predicate) {
        this.arrayed = arrayed;
        this.predicate = predicate;
    }

    private EntryType(Predicate<Class<?>> predicate) {
        this(true, predicate);
    }

    public boolean isAllowedInArrays() {
        return this.arrayed;
    }

    public boolean test(Class<?> type) {
        return this.predicate.test(type);
    }
}

