/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.fastsuite;

import dev.shadowsoffire.fastsuite.CachedRecipeList;
import dev.shadowsoffire.fastsuite.FastSuite;
import dev.shadowsoffire.fastsuite.ILockableItemStack;
import dev.shadowsoffire.fastsuite.StreamUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.conditions.ICondition;
import org.jetbrains.annotations.VisibleForTesting;

public class AuxRecipeManager
extends RecipeManager {
    private final Map<RecipeType<?>, CachedRecipeList<?, ?>> cachedRecipeListMap = new HashMap();

    @Deprecated
    public AuxRecipeManager() {
    }

    public AuxRecipeManager(ICondition.IContext context) {
        super(context);
    }

    @VisibleForTesting
    public <C extends Container, T extends Recipe<C>> Optional<T> super_getRecipeFor(RecipeType<T> type, C inv, Level level) {
        return super.m_44015_(type, inv, level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <C extends Container, T extends Recipe<C>> CachedRecipeList<C, T> getCachedRecipeList(RecipeType<T> type) {
        Map<RecipeType<?>, CachedRecipeList<?, ?>> map = this.cachedRecipeListMap;
        synchronized (map) {
            CachedRecipeList<Object, Object> list = this.cachedRecipeListMap.get(type);
            if (list == null) {
                list = new CachedRecipeList(type, this.m_44054_(type));
                this.cachedRecipeListMap.put(type, list);
            }
            return list;
        }
    }

    public <C extends Container, T extends Recipe<C>> Optional<T> m_44015_(RecipeType<T> type, C inv, Level level) {
        if (this.numRecipesOf(type) < 100 || FastSuite.singleThreadedLookups.contains(type)) {
            return super.m_44015_(type, inv, level);
        }
        this.lockAllStacks(inv, true);
        try {
            if (FastSuite.unsafeMode) {
                Optional optional = StreamUtils.executeUntil(() -> this.m_44054_(type).values().parallelStream().filter(recipe -> recipe.m_5818_(inv, level)).findFirst(), FastSuite.maxRecipeLookupTime, TimeUnit.SECONDS, Optional.empty(), () -> CachedRecipeList.timeoutMsg(type));
                return optional;
            }
            CachedRecipeList<C, T> cachedRecipeList = this.getCachedRecipeList(type);
            Optional<T> optional = cachedRecipeList.getRecipeFor(inv, level);
            return optional;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.lockAllStacks(inv, false);
        }
    }

    public <C extends Container, T extends Recipe<C>> List<T> m_44056_(RecipeType<T> type, C inv, Level level) {
        if (this.numRecipesOf(type) < 100 || FastSuite.singleThreadedLookups.contains(type)) {
            return super.m_44056_(type, inv, level);
        }
        this.lockAllStacks(inv, true);
        try {
            if (FastSuite.unsafeMode) {
                List list = StreamUtils.executeUntil(() -> this.m_44054_(type).values().parallelStream().filter(recipe -> recipe.m_5818_(inv, level)).sorted(Comparator.comparing(recipe -> recipe.m_8043_(level.m_9598_()).m_41778_())).collect(Collectors.toList()), FastSuite.maxRecipeLookupTime, TimeUnit.SECONDS, Collections.emptyList(), () -> CachedRecipeList.timeoutMsg(type));
                return list;
            }
            CachedRecipeList<C, T> cachedRecipeList = this.getCachedRecipeList(type);
            List<T> list = cachedRecipeList.getRecipesFor(inv, level);
            return list;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.lockAllStacks(inv, false);
        }
    }

    private <C extends Container> void lockAllStacks(C inv, boolean locked) {
        if (!FastSuite.lockInputStacks) {
            return;
        }
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack s = inv.m_8020_(i);
            if (s.m_41619_()) continue;
            ((ILockableItemStack)s).setLocked(locked);
        }
    }

    private int numRecipesOf(RecipeType type) {
        return this.m_44054_(type).size();
    }

    private <C extends Container, T extends Recipe<C>> Map<ResourceLocation, T> m_44054_(RecipeType<T> pRecipeType) {
        return this.f_44007_.getOrDefault(pRecipeType, Collections.emptyMap());
    }
}

