/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.tools.rules;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import mcjty.incontrol.ErrorHandler;
import mcjty.incontrol.InControl;
import mcjty.incontrol.data.DataStorage;
import mcjty.incontrol.events.EventsSystem;
import mcjty.incontrol.events.NumberAction;
import mcjty.incontrol.rules.support.RuleKeys;
import mcjty.incontrol.setup.Config;
import mcjty.incontrol.tools.rules.IModRuleCompatibilityLayer;
import mcjty.incontrol.tools.rules.TestingTools;
import mcjty.incontrol.tools.typed.AttributeMap;
import mcjty.incontrol.tools.varia.LookAtTools;
import mcjty.incontrol.tools.varia.Tools;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class RuleBase<T extends EventGetter> {
    protected final List<Consumer<T>> actions = new ArrayList<Consumer<T>>();
    private final Set<String> phases;
    private final int index;
    private static final Random rnd = new Random();
    public static final Component DEFAULT_NAME = Component.m_237113_((String)"@");
    public static final CommandSource EMPTY = new CommandSource(){

        public void m_213846_(Component component) {
        }

        public boolean m_6999_() {
            return false;
        }

        public boolean m_7028_() {
            return false;
        }

        public boolean m_6102_() {
            return false;
        }
    };

    public RuleBase(Set<String> phases, int index) {
        this.phases = phases;
        this.index = index;
    }

    public Set<String> getPhases() {
        return this.phases;
    }

    public int getIndex() {
        return this.index;
    }

    protected List<Pair<Float, ItemStack>> getItemsWeighted(List<String> itemNames) {
        ArrayList<Pair<Float, ItemStack>> items = new ArrayList<Pair<Float, ItemStack>>();
        Iterator<String> iterator = itemNames.iterator();
        while (iterator.hasNext()) {
            Pair<Float, ItemStack> pair;
            JsonParser parser = new JsonParser();
            String json = iterator.next();
            JsonElement element = parser.parse(json);
            if (element.isJsonPrimitive()) {
                String name = element.getAsString();
                pair = Tools.parseStackWithFactor(name);
                if (((ItemStack)pair.getValue()).m_41619_()) {
                    ErrorHandler.error("Unknown item '" + name + "'!");
                    continue;
                }
                items.add(pair);
                continue;
            }
            if (element.isJsonObject()) {
                JsonObject obj = element.getAsJsonObject();
                pair = Tools.parseStackWithFactor(obj);
                if (pair == null) continue;
                items.add(pair);
                continue;
            }
            ErrorHandler.error("Item description '" + json + "' is not valid!");
        }
        return items;
    }

    protected ItemStack getRandomItem(List<Pair<Float, ItemStack>> items, float total) {
        float r = rnd.nextFloat() * total;
        for (Pair<Float, ItemStack> pair : items) {
            if (r <= ((Float)pair.getLeft()).floatValue()) {
                return ((ItemStack)pair.getRight()).m_41777_();
            }
            r -= ((Float)pair.getLeft()).floatValue();
        }
        return ItemStack.f_41583_;
    }

    protected float getTotal(List<Pair<Float, ItemStack>> items) {
        float total = 0.0f;
        for (Pair<Float, ItemStack> pair : items) {
            total += ((Float)pair.getLeft()).floatValue();
        }
        return total;
    }

    protected void addActions(AttributeMap map, IModRuleCompatibilityLayer layer) {
        map.consume(RuleKeys.ACTION_CUSTOMEVENT, this::addCustomEventAction);
        map.consumeAsList(RuleKeys.ACTION_COMMAND, this::addCommandAction);
        map.consume(RuleKeys.ACTION_ADDSTAGE, stage -> this.addAddStage((String)stage, layer));
        map.consume(RuleKeys.ACTION_REMOVESTAGE, stage -> this.addRemoveStage((String)stage, layer));
        map.consume(RuleKeys.ACTION_HEALTHSET, v -> this.addAttributeAction("ctrlHealthS" + this.index, Attributes.f_22276_, (m, a) -> {
            a.m_22100_((double)v.floatValue());
            m.m_21153_(v.floatValue());
        }));
        map.consume(RuleKeys.ACTION_HEALTHMULTIPLY, v -> this.addAttributeAction("ctrlHealthM" + this.index, Attributes.f_22276_, (m, a) -> {
            double newMax = a.m_22115_() * (double)v.floatValue();
            a.m_22100_(newMax);
            m.m_21153_((float)newMax);
        }));
        map.consume(RuleKeys.ACTION_HEALTHADD, v -> this.addAttributeAction("ctrlHealthA" + this.index, Attributes.f_22276_, (m, a) -> {
            double newMax = a.m_22115_() + (double)v.floatValue();
            a.m_22100_(newMax);
            m.m_21153_((float)newMax);
        }));
        map.consume(RuleKeys.ACTION_SPEEDSET, v -> this.addAttributeAction("ctrlSpeedS" + this.index, Attributes.f_22279_, (m, a) -> a.m_22100_((double)v.floatValue())));
        map.consume(RuleKeys.ACTION_SPEEDMULTIPLY, v -> this.addAttributeAction("ctrlSpeedM" + this.index, Attributes.f_22279_, (m, a) -> a.m_22100_(a.m_22115_() * (double)v.floatValue())));
        map.consume(RuleKeys.ACTION_SPEEDADD, v -> this.addAttributeAction("ctrlSpeedA" + this.index, Attributes.f_22279_, (m, a) -> a.m_22100_(a.m_22115_() + (double)v.floatValue())));
        map.consume(RuleKeys.ACTION_DAMAGESET, v -> this.addAttributeAction("ctrlDamageS" + this.index, Attributes.f_22281_, (m, a) -> a.m_22100_((double)v.floatValue())));
        map.consume(RuleKeys.ACTION_DAMAGEMULTIPLY, v -> this.addAttributeAction("ctrlDamageM" + this.index, Attributes.f_22281_, (m, a) -> a.m_22100_(a.m_22115_() * (double)v.floatValue())));
        map.consume(RuleKeys.ACTION_DAMAGEADD, v -> this.addAttributeAction("ctrlDamageA" + this.index, Attributes.f_22281_, (m, a) -> a.m_22100_(a.m_22115_() + (double)v.floatValue())));
        map.consume(RuleKeys.ACTION_ARMORSET, v -> this.addAttributeAction("ctrlArmorS" + this.index, Attributes.f_22284_, (m, a) -> a.m_22100_((double)v.floatValue())));
        map.consume(RuleKeys.ACTION_ARMORMULTIPLY, v -> this.addAttributeAction("ctrlArmorM" + this.index, Attributes.f_22284_, (m, a) -> a.m_22100_(a.m_22115_() * (double)v.floatValue())));
        map.consume(RuleKeys.ACTION_ARMORADD, v -> this.addAttributeAction("ctrlArmorA" + this.index, Attributes.f_22284_, (m, a) -> a.m_22100_(a.m_22115_() + (double)v.floatValue())));
        map.consume(RuleKeys.ACTION_ARMORTOUGHNESSSET, v -> this.addAttributeAction("ctrlArmorToS" + this.index, Attributes.f_22285_, (m, a) -> a.m_22100_((double)v.floatValue())));
        map.consume(RuleKeys.ACTION_ARMORTOUGHNESSMULTIPLY, v -> this.addAttributeAction("ctrlArmorToM" + this.index, Attributes.f_22285_, (m, a) -> a.m_22100_(a.m_22115_() * (double)v.floatValue())));
        map.consume(RuleKeys.ACTION_ARMORTOUGHNESSADD, v -> this.addAttributeAction("ctrlArmorToA" + this.index, Attributes.f_22285_, (m, a) -> a.m_22100_(a.m_22115_() + (double)v.floatValue())));
        map.consume(RuleKeys.ACTION_ATTACKSPEEDSET, v -> this.addAttributeAction("ctrlAttackSpS" + this.index, Attributes.f_22283_, (m, a) -> a.m_22100_((double)v.floatValue())));
        map.consume(RuleKeys.ACTION_ATTACKSPEEDMULTIPLY, v -> this.addAttributeAction("ctrlAttackSpM" + this.index, Attributes.f_22283_, (m, a) -> a.m_22100_(a.m_22115_() * (double)v.floatValue())));
        map.consume(RuleKeys.ACTION_ATTACKSPEEDADD, v -> this.addAttributeAction("ctrlAttackSpA" + this.index, Attributes.f_22283_, (m, a) -> a.m_22100_(a.m_22115_() + (double)v.floatValue())));
        map.consume(RuleKeys.ACTION_FOLLOWRANGESET, v -> this.addAttributeAction("ctrlFollowS" + this.index, Attributes.f_22277_, (m, a) -> a.m_22100_((double)v.floatValue())));
        map.consume(RuleKeys.ACTION_FOLLOWRANGEMULTIPLY, v -> this.addAttributeAction("ctrlFollowM" + this.index, Attributes.f_22277_, (m, a) -> a.m_22100_(a.m_22115_() * (double)v.floatValue())));
        map.consume(RuleKeys.ACTION_FOLLOWRANGEADD, v -> this.addAttributeAction("ctrlFollowA" + this.index, Attributes.f_22277_, (m, a) -> a.m_22100_(a.m_22115_() + (double)v.floatValue())));
        map.consume(RuleKeys.ACTION_KNOCKBACKSET, v -> this.addAttributeAction("ctrlKnockbackS" + this.index, Attributes.f_22282_, (m, a) -> a.m_22100_((double)v.floatValue())));
        map.consume(RuleKeys.ACTION_KNOCKBACKMULTIPLY, v -> this.addAttributeAction("ctrlKnockbackM" + this.index, Attributes.f_22282_, (m, a) -> a.m_22100_(a.m_22115_() * (double)v.floatValue())));
        map.consume(RuleKeys.ACTION_KNOCKBACKADD, v -> this.addAttributeAction("ctrlKnockbackA" + this.index, Attributes.f_22282_, (m, a) -> a.m_22100_(a.m_22115_() + (double)v.floatValue())));
        map.consume(RuleKeys.ACTION_KNOCKBACKRESISTANCESET, v -> this.addAttributeAction("ctrlKnockbackResS" + this.index, Attributes.f_22278_, (m, a) -> a.m_22100_((double)v.floatValue())));
        map.consume(RuleKeys.ACTION_KNOCKBACKRESISTANCEMULTIPLY, v -> this.addAttributeAction("ctrlKnockbackResM" + this.index, Attributes.f_22278_, (m, a) -> a.m_22100_(a.m_22115_() * (double)v.floatValue())));
        map.consume(RuleKeys.ACTION_KNOCKBACKRESISTANCEADD, v -> this.addAttributeAction("ctrlKnockbackResA" + this.index, Attributes.f_22278_, (m, a) -> a.m_22100_(a.m_22115_() + (double)v.floatValue())));
        map.consume2(RuleKeys.ACTION_SIZEMULTIPLY, RuleKeys.ACTION_SIZEADD, this::addSizeActions);
        map.consumeAsList(RuleKeys.ACTION_POTION, this::addPotionsAction);
        map.consumeAsList(RuleKeys.ACTION_POTION_NOPARTICLES, this::addPotionsNoParticlesAction);
        map.consume(RuleKeys.ACTION_NODESPAWN, this::addNoDespawnAction);
        map.consume(RuleKeys.ACTION_ANGRY, this::addAngryAction);
        map.consume(RuleKeys.ACTION_CUSTOMNAME, this::addCustomName);
        map.consume(RuleKeys.ACTION_MOBNBT, this::addMobNBT);
        map.consumeAsList(RuleKeys.ACTION_HELDITEM, this::addHeldItem);
        map.consumeAsList(RuleKeys.ACTION_ARMORBOOTS, items -> this.addArmorItem((List<String>)items, EquipmentSlot.FEET));
        map.consumeAsList(RuleKeys.ACTION_ARMORLEGS, items -> this.addArmorItem((List<String>)items, EquipmentSlot.LEGS));
        map.consumeAsList(RuleKeys.ACTION_ARMORHELMET, items -> this.addArmorItem((List<String>)items, EquipmentSlot.HEAD));
        map.consumeAsList(RuleKeys.ACTION_ARMORCHEST, items -> this.addArmorItem((List<String>)items, EquipmentSlot.CHEST));
        map.consume(RuleKeys.ACTION_FIRE, this::addFireAction);
        map.consume(RuleKeys.ACTION_EXPLOSION, this::addExplosionAction);
        map.consume(RuleKeys.ACTION_CLEAR, this::addClearAction);
        map.consume(RuleKeys.ACTION_DAMAGE, this::addDoDamageAction);
        map.consume(RuleKeys.ACTION_MESSAGE, this::addDoMessageAction);
        map.consumeAsList(RuleKeys.ACTION_ADDSCOREBOARDTAGS, this::addAddScoreboardTagsAction);
        map.consumeAsList(RuleKeys.ACTION_GIVE, this::addGiveAction);
        map.consumeAsList(RuleKeys.ACTION_DROP, this::addDropAction);
        map.consume2(RuleKeys.ACTION_SETBLOCK, RuleKeys.BLOCKOFFSET, this::addSetBlockAction);
        map.consume(RuleKeys.ACTION_SETHELDITEM, this::addSetHeldItemAction);
        map.consume(RuleKeys.ACTION_SETHELDAMOUNT, this::addSetHeldAmountAction);
        map.consume(RuleKeys.ACTION_SETPHASE, this::addSetPhaseAction);
        map.consume(RuleKeys.ACTION_CLEARPHASE, this::addClearPhaseAction);
        map.consume(RuleKeys.ACTION_TOGGLEPHASE, this::addTogglePhaseAction);
        map.consume(RuleKeys.ACTION_CHANGENUMBER, this::addChangeNumberAction);
        map.consume(RuleKeys.ACTION_SETSTATE, state -> {
            if (layer.hasEnigmaScript()) {
                this.addStateAction((String)state, layer);
            } else {
                InControl.setup.getLogger().warn("EnigmaScript is missing: this action cannot work!");
            }
        });
        map.consume(RuleKeys.ACTION_SETPSTATE, state -> {
            if (layer.hasEnigmaScript()) {
                this.addPStateAction((String)state, layer);
            } else {
                InControl.setup.getLogger().warn("EnigmaScript is missing: this action cannot work!");
            }
        });
    }

    private void addTogglePhaseAction(String phase) {
        this.actions.add(event -> {
            DataStorage data = DataStorage.getData((LevelAccessor)Tools.getServerWorld(event.getWorld()));
            data.togglePhase(phase);
        });
    }

    private void addClearPhaseAction(String phase) {
        this.actions.add(event -> {
            DataStorage data = DataStorage.getData((LevelAccessor)Tools.getServerWorld(event.getWorld()));
            data.setPhase(phase, false);
        });
    }

    private void addChangeNumberAction(String s) {
        try {
            String[] split = StringUtils.split((String)s, (char)'=');
            String number = split[0];
            String value = split[1];
            NumberAction action = NumberAction.createUnnamed(value);
            if (action == null) {
                return;
            }
            this.actions.add(event -> {
                DataStorage data = DataStorage.getData((LevelAccessor)Tools.getServerWorld(event.getWorld()));
                int n = data.getNumber(number);
                n = action.perform(n);
                data.setNumber(number, n);
            });
        }
        catch (Exception e) {
            ErrorHandler.error("Bad number=expression specifier '" + s + "'!");
        }
    }

    private void addAddNumberAction(String s) {
        try {
            String[] split = StringUtils.split((String)s, (char)'=');
            String number = split[0];
            String value = split[1];
            int finalValue = Integer.parseInt(value);
            this.actions.add(event -> {
                DataStorage data = DataStorage.getData((LevelAccessor)Tools.getServerWorld(event.getWorld()));
                int n = data.getNumber(number);
                data.setNumber(number, n + finalValue);
            });
        }
        catch (Exception e) {
            ErrorHandler.error("Bad number=value specifier '" + s + "'!");
        }
    }

    private void addSetPhaseAction(String phase) {
        this.actions.add(event -> {
            DataStorage data = DataStorage.getData((LevelAccessor)Tools.getServerWorld(event.getWorld()));
            data.setPhase(phase, true);
        });
    }

    private void addCustomEventAction(String eventname) {
        this.actions.add(event -> {
            ServerLevel level = Tools.getServerWorld(event.getWorld());
            EventsSystem.onCustomEvent((Level)level, event.getPosition(), eventname);
        });
    }

    private void addCommandAction(List<String> commands) {
        this.actions.add(event -> {
            MinecraftServer server = event.getWorld().m_7654_();
            Player player = event.getPlayer();
            CommandSourceStack stack = new CommandSourceStack(EMPTY, Vec3.m_82512_((Vec3i)event.getPosition()), Vec2.f_82462_, (ServerLevel)event.getWorld(), 2, DEFAULT_NAME.getString(), DEFAULT_NAME, server, (Entity)player);
            for (String command : commands) {
                server.m_129892_().m_230957_(stack, command);
            }
        });
    }

    private void addAddStage(String stage, IModRuleCompatibilityLayer layer) {
        this.actions.add(event -> {
            Player player = event.getPlayer();
            if (player != null) {
                layer.addGameStage(player, stage);
            }
        });
    }

    private void addRemoveStage(String stage, IModRuleCompatibilityLayer layer) {
        this.actions.add(event -> {
            Player player = event.getPlayer();
            if (player != null) {
                layer.removeGameStage(player, stage);
            }
        });
    }

    private void addNoDespawnAction(boolean a) {
        this.actions.add(event -> {
            LivingEntity living = event.getEntityLiving();
            if (living instanceof Mob) {
                Mob mob = (Mob)living;
                mob.m_21530_();
            }
        });
    }

    private void addDoDamageAction(String damage) {
        String[] split = StringUtils.split((String)damage, (String)"=");
        Registry damageTypes = ServerLifecycleHooks.getCurrentServer().m_206579_().m_175515_(Registries.f_268580_);
        Optional type = damageTypes.m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation(split[0])));
        if (!type.isPresent()) {
            ErrorHandler.error("Can't find damage source '" + split[0] + "'!");
            return;
        }
        DamageSource source = new DamageSource((Holder)type.get());
        float amount = 1.0f;
        if (split.length > 1) {
            amount = Float.parseFloat(split[1]);
        }
        float finalAmount = amount;
        this.actions.add(event -> {
            LivingEntity living = event.getEntityLiving();
            if (living != null) {
                living.m_6469_(source, finalAmount);
            }
        });
    }

    private void addDoMessageAction(String message) {
        this.actions.add(event -> {
            Player player = event.getPlayer();
            if (player == null) {
                player = event.getWorld().m_45930_((Entity)event.getEntityLiving(), (double)((Integer)Config.PERPLAYER_RADIUS.get()).intValue());
            }
            if (player != null) {
                player.m_5661_((Component)Component.m_237113_((String)message), false);
            }
        });
    }

    private void addGiveAction(List<String> itemList) {
        List<Pair<Float, ItemStack>> items = this.getItemsWeighted(itemList);
        if (items.isEmpty()) {
            return;
        }
        if (items.size() == 1) {
            ItemStack item = (ItemStack)items.get(0).getRight();
            this.actions.add(event -> {
                Player player = event.getPlayer();
                if (player != null && !player.m_150109_().m_36054_(item.m_41777_())) {
                    player.m_5552_(item.m_41777_(), 1.05f);
                }
            });
        } else {
            float total = this.getTotal(items);
            this.actions.add(event -> {
                Player player = event.getPlayer();
                if (player != null) {
                    ItemStack item = this.getRandomItem(items, total);
                    if (!player.m_150109_().m_36054_(item.m_41777_())) {
                        player.m_5552_(item.m_41777_(), 1.05f);
                    }
                }
            });
        }
    }

    private void addStateAction(String s, IModRuleCompatibilityLayer layer) {
        String value;
        String state;
        String[] split = StringUtils.split((String)s, (char)'=');
        try {
            state = split[0];
            value = split[1];
        }
        catch (Exception e) {
            ErrorHandler.error("Bad state=value specifier '" + s + "'!");
            return;
        }
        String finalState = state;
        String finalValue = value;
        this.actions.add(event -> layer.setState(event.getWorld(), finalState, finalValue));
    }

    private void addPStateAction(String s, IModRuleCompatibilityLayer layer) {
        String value;
        String state;
        String[] split = StringUtils.split((String)s, (char)'=');
        try {
            state = split[0];
            value = split[1];
        }
        catch (Exception e) {
            ErrorHandler.error("Bad state=value specifier '" + s + "'!");
            return;
        }
        String finalState = state;
        String finalValue = value;
        this.actions.add(event -> layer.setPlayerState(event.getPlayer(), finalState, finalValue));
    }

    @Nonnull
    private Function<EventGetter, BlockPos> parseOffset(String json) {
        int offsetZ;
        int offsetY;
        int offsetX;
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse(json);
        JsonObject obj = element.getAsJsonObject();
        if (obj.has("offset")) {
            JsonObject offset = obj.getAsJsonObject("offset");
            offsetX = offset.has("x") ? offset.get("x").getAsInt() : 0;
            offsetY = offset.has("y") ? offset.get("y").getAsInt() : 0;
            offsetZ = offset.has("z") ? offset.get("z").getAsInt() : 0;
        } else {
            offsetX = 0;
            offsetY = 0;
            offsetZ = 0;
        }
        if (obj.has("look")) {
            return event -> {
                HitResult result = LookAtTools.getMovingObjectPositionFromPlayer(event.getWorld(), event.getPlayer(), false);
                if (result instanceof BlockHitResult) {
                    return ((BlockHitResult)result).m_82425_().m_7918_(offsetX, offsetY, offsetZ);
                }
                return event.getPosition().m_7918_(offsetX, offsetY, offsetZ);
            };
        }
        return event -> event.getPosition().m_7918_(offsetX, offsetY, offsetZ);
    }

    private void addSetHeldItemAction(String json) {
        ItemStack stack;
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse(json);
        if (element.isJsonPrimitive()) {
            String name = element.getAsString();
            stack = Tools.parseStack(name);
        } else if (element.isJsonObject()) {
            JsonObject obj = element.getAsJsonObject();
            stack = Tools.parseStack(obj);
            if (stack == null) {
                return;
            }
        } else {
            ErrorHandler.error("Item description '" + json + "' is not valid!");
            return;
        }
        this.actions.add(event -> event.getPlayer().m_21008_(InteractionHand.MAIN_HAND, stack.m_41777_()));
    }

    private void addSetHeldAmountAction(String amount) {
        int add = 0;
        int set = -1;
        if (amount.startsWith("+")) {
            add = Integer.parseInt(amount.substring(1));
        } else if (amount.startsWith("-")) {
            add = -Integer.parseInt(amount.substring(1));
        } else {
            set = amount.startsWith("=") ? Integer.parseInt(amount.substring(1)) : Integer.parseInt(amount);
        }
        int finalSet = set;
        if (finalSet >= 0) {
            this.actions.add(event -> {
                ItemStack item = event.getPlayer().m_21205_();
                item.m_41764_(finalSet);
                event.getPlayer().m_21008_(InteractionHand.MAIN_HAND, item.m_41777_());
            });
        } else {
            int finalAdd = add;
            this.actions.add(event -> {
                ItemStack item = event.getPlayer().m_21205_();
                int newCount = item.m_41613_() + finalAdd;
                if (newCount < 0) {
                    newCount = 0;
                } else if (newCount >= item.m_41741_()) {
                    newCount = item.m_41741_() - 1;
                }
                item.m_41764_(newCount);
                event.getPlayer().m_21008_(InteractionHand.MAIN_HAND, item.m_41777_());
            });
        }
    }

    private void addSetBlockAction(String json, String bo) {
        Function<EventGetter, BlockPos> posFunction = bo != null ? this.parseOffset(bo) : EventGetter::getPosition;
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse(json);
        if (element.isJsonPrimitive()) {
            String blockname = element.getAsString();
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockname));
            if (block == null) {
                ErrorHandler.error("Block '" + blockname + "' is not valid!");
                return;
            }
            BlockState state = block.m_49966_();
            this.actions.add(event -> {
                BlockPos pos = (BlockPos)posFunction.apply((EventGetter)event);
                if (pos != null) {
                    event.getWorld().m_7731_(pos, state, 3);
                }
            });
        } else {
            JsonObject obj = element.getAsJsonObject();
            if (!obj.has("block")) {
                ErrorHandler.error("Block is not valid!");
                return;
            }
            String blockname = obj.get("block").getAsString();
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockname));
            if (block == null) {
                ErrorHandler.error("Block '" + blockname + "' is not valid!");
                return;
            }
            BlockState state = block.m_49966_();
            if (obj.has("properties")) {
                JsonArray propArray = obj.get("properties").getAsJsonArray();
                for (JsonElement el : propArray) {
                    JsonObject propObj = el.getAsJsonObject();
                    String name = propObj.get("name").getAsString();
                    String value = propObj.get("value").getAsString();
                    for (Property key : state.m_61147_()) {
                        if (!name.equals(key.m_61708_())) continue;
                        state = TestingTools.set(state, key, value);
                    }
                }
            }
            BlockState finalState = state;
            this.actions.add(event -> {
                BlockPos pos = (BlockPos)posFunction.apply((EventGetter)event);
                if (pos != null) {
                    event.getWorld().m_7731_(pos, finalState, 3);
                }
            });
        }
    }

    private void addDropAction(List<String> itemList) {
        List<Pair<Float, ItemStack>> items = this.getItemsWeighted(itemList);
        if (items.isEmpty()) {
            return;
        }
        if (items.size() == 1) {
            ItemStack item = (ItemStack)items.get(0).getRight();
            this.actions.add(event -> {
                if (event.getWorld() instanceof Level) {
                    BlockPos pos = event.getPosition();
                    ItemEntity entityItem = new ItemEntity((Level)event.getWorld(), (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), item.m_41777_());
                    event.getWorld().m_7967_((Entity)entityItem);
                }
            });
        } else {
            float total = this.getTotal(items);
            this.actions.add(event -> {
                if (event.getWorld() instanceof Level) {
                    BlockPos pos = event.getPosition();
                    ItemStack item = this.getRandomItem(items, total);
                    ItemEntity entityItem = new ItemEntity((Level)event.getWorld(), (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), item.m_41777_());
                    event.getWorld().m_7967_((Entity)entityItem);
                }
            });
        }
    }

    private void addClearAction(boolean clear) {
        if (clear) {
            this.actions.add(event -> {
                LivingEntity living = event.getEntityLiving();
                if (living != null) {
                    living.m_21219_();
                }
            });
        }
    }

    private void addFireAction(int fireAction) {
        this.actions.add(event -> {
            LivingEntity living = event.getEntityLiving();
            if (living != null) {
                living.m_6469_(living.m_269291_().m_269549_(), 0.1f);
                living.m_20254_(fireAction);
            }
        });
    }

    private void addExplosionAction(String fireAction) {
        String[] split = StringUtils.split((String)fireAction, (String)",");
        float strength = 1.0f;
        boolean flaming = false;
        boolean smoking = false;
        try {
            strength = Float.parseFloat(split[0]);
            flaming = "1".equalsIgnoreCase(split[1]) || "true".equals(split[1].toLowerCase()) || "yes".equals(split[1].toLowerCase());
            smoking = "1".equalsIgnoreCase(split[2]) || "true".equals(split[2].toLowerCase()) || "yes".equals(split[2].toLowerCase());
        }
        catch (Exception exception) {
            // empty catch block
        }
        float finalStrength = strength;
        boolean finalFlaming = flaming;
        boolean finalSmoking = smoking;
        this.actions.add(event -> {
            BlockPos pos = event.getPosition();
            if (pos != null && event.getWorld() instanceof Level) {
                ((Level)event.getWorld()).m_255391_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, finalStrength, finalFlaming, Level.ExplosionInteraction.TNT);
            }
        });
    }

    private void addPotionsAction(List<String> potions) {
        this.addPotionsAction(potions, true);
    }

    private void addPotionsNoParticlesAction(List<String> potions) {
        this.addPotionsAction(potions, false);
    }

    protected void addPotionsAction(List<String> potions, boolean showParticles) {
        ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
        for (String p : potions) {
            String[] splitted = StringUtils.split((String)p, (char)',');
            if (splitted == null || splitted.length != 3) {
                ErrorHandler.error("Bad potion specifier '" + p + "'! Use <potion>,<duration>,<amplifier>");
                continue;
            }
            MobEffect potion = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(splitted[0]));
            if (potion == null) {
                ErrorHandler.error("Can't find potion '" + p + "'!");
                continue;
            }
            int duration = 0;
            int amplifier = 0;
            try {
                duration = Integer.parseInt(splitted[1]);
                amplifier = Integer.parseInt(splitted[2]);
            }
            catch (NumberFormatException e) {
                ErrorHandler.error("Bad duration or amplifier integer for '" + p + "'!");
                continue;
            }
            effects.add(new MobEffectInstance(potion, duration, amplifier));
        }
        if (!effects.isEmpty()) {
            this.actions.add(event -> {
                LivingEntity living = event.getEntityLiving();
                if (living != null) {
                    for (MobEffectInstance effect : effects) {
                        MobEffectInstance neweffect = new MobEffectInstance(effect.m_19544_(), effect.m_19557_(), effect.m_19564_(), false, showParticles);
                        living.m_7292_(neweffect);
                    }
                }
            });
        }
    }

    private void addAddScoreboardTagsAction(List<String> tags) {
        this.actions.add(event -> {
            LivingEntity entityLiving = event.getEntityLiving();
            if (entityLiving != null) {
                for (String tag : tags) {
                    entityLiving.m_20049_(tag);
                }
            }
        });
    }

    private void addAttributeAction(String key, Attribute attribute, BiConsumer<LivingEntity, AttributeInstance> action) {
        this.actions.add(event -> {
            AttributeInstance attr;
            LivingEntity entityLiving = event.getEntityLiving();
            if (entityLiving != null && !entityLiving.m_19880_().contains(key) && (attr = entityLiving.m_21051_(attribute)) != null) {
                action.accept(entityLiving, attr);
                entityLiving.m_20049_(key);
            }
        });
    }

    private void addSizeActions(Float m, Float a) {
        m = Float.valueOf(m == null ? 1.0f : m.floatValue());
        a = Float.valueOf(a == null ? 0.0f : a.floatValue());
        ErrorHandler.error("Mob resizing not implemented yet!");
        this.actions.add(event -> {
            LivingEntity entityLiving = event.getEntityLiving();
            if (entityLiving != null) {
                // empty if block
            }
        });
    }

    private void addDamageSetAction(float s, int index) {
        this.actions.add(event -> {
            AttributeInstance entityAttribute;
            LivingEntity entityLiving = event.getEntityLiving();
            if (entityLiving != null && !entityLiving.m_19880_().contains("ctrlDamageSet" + index) && (entityAttribute = entityLiving.m_21051_(Attributes.f_22281_)) != null) {
                entityAttribute.m_22100_((double)s);
                entityLiving.m_20049_("ctrlDamageSet" + index);
            }
        });
    }

    private void addDamageAction(Float m, Float a, int index) {
        float finalM = m == null ? 1.0f : m.floatValue();
        float finalA = a == null ? 0.0f : a.floatValue();
        this.actions.add(event -> {
            AttributeInstance entityAttribute;
            LivingEntity entityLiving = event.getEntityLiving();
            if (entityLiving != null && !entityLiving.m_19880_().contains("ctrlDamage" + index) && (entityAttribute = entityLiving.m_21051_(Attributes.f_22281_)) != null) {
                double newMax = entityAttribute.m_22115_() * (double)finalM + (double)finalA;
                entityAttribute.m_22100_(newMax);
                entityLiving.m_20049_("ctrlDamage" + index);
            }
        });
    }

    protected void addArmorItem(List<String> itemList, EquipmentSlot slot) {
        List<Pair<Float, ItemStack>> items = this.getItemsWeighted(itemList);
        if (items.isEmpty()) {
            return;
        }
        if (items.size() == 1) {
            ItemStack item = (ItemStack)items.get(0).getRight();
            this.actions.add(event -> {
                LivingEntity entityLiving = event.getEntityLiving();
                if (entityLiving != null) {
                    entityLiving.m_8061_(slot, item.m_41777_());
                }
            });
        } else {
            float total = this.getTotal(items);
            this.actions.add(event -> {
                LivingEntity entityLiving = event.getEntityLiving();
                if (entityLiving != null) {
                    entityLiving.m_8061_(slot, this.getRandomItem(items, total));
                }
            });
        }
    }

    protected void addHeldItem(List<String> heldItems) {
        List<Pair<Float, ItemStack>> items = this.getItemsWeighted(heldItems);
        if (items.isEmpty()) {
            return;
        }
        if (items.size() == 1) {
            ItemStack item = (ItemStack)items.get(0).getRight();
            this.actions.add(event -> {
                LivingEntity entityLiving = event.getEntityLiving();
                if (entityLiving != null) {
                    if (entityLiving instanceof EnderMan) {
                        if (item.m_41720_() instanceof BlockItem) {
                            BlockItem b = (BlockItem)item.m_41720_();
                            ((EnderMan)entityLiving).m_32521_(b.m_40614_().m_49966_());
                        }
                    } else {
                        entityLiving.m_21008_(InteractionHand.MAIN_HAND, item.m_41777_());
                    }
                }
            });
        } else {
            float total = this.getTotal(items);
            this.actions.add(event -> {
                LivingEntity entityLiving = event.getEntityLiving();
                if (entityLiving != null) {
                    ItemStack item = this.getRandomItem(items, total);
                    if (entityLiving instanceof EnderMan) {
                        if (item.m_41720_() instanceof BlockItem) {
                            BlockItem b = (BlockItem)item.m_41720_();
                            ((EnderMan)entityLiving).m_32521_(b.m_40614_().m_49966_());
                        }
                    } else {
                        entityLiving.m_21008_(InteractionHand.MAIN_HAND, item.m_41777_());
                    }
                }
            });
        }
    }

    private void addMobNBT(String mobnbt) {
        if (mobnbt != null) {
            CompoundTag tagCompound;
            try {
                tagCompound = TagParser.m_129359_((String)mobnbt);
            }
            catch (CommandSyntaxException e) {
                ErrorHandler.error("Bad NBT for mob!");
                return;
            }
            this.actions.add(event -> {
                LivingEntity entityLiving = event.getEntityLiving();
                entityLiving.m_7378_(tagCompound);
            });
        }
    }

    private void addCustomName(String customName) {
        if (customName != null) {
            this.actions.add(event -> {
                LivingEntity entityLiving = event.getEntityLiving();
                entityLiving.m_6593_((Component)Component.m_237113_((String)customName));
            });
        }
    }

    protected void addAngryAction(boolean angry) {
        if (angry) {
            this.actions.add(event -> {
                Player player;
                LivingEntity entityLiving = event.getEntityLiving();
                if (entityLiving != null && (player = event.getWorld().m_45930_((Entity)entityLiving, 50.0)) != null) {
                    entityLiving.m_6703_((LivingEntity)player);
                    entityLiving.m_21335_((Entity)player);
                    if (entityLiving instanceof NeutralMob) {
                        ((NeutralMob)entityLiving).m_6710_((LivingEntity)player);
                    }
                }
            });
        }
    }

    public static interface EventGetter {
        public LivingEntity getEntityLiving();

        public Player getPlayer();

        public LevelAccessor getWorld();

        public BlockPos getPosition();
    }
}

