/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.clayworks.core.api;

import com.mojang.datafixers.util.Either;
import com.teamabnormals.blueprint.client.renderer.texture.atlas.BlueprintPalettedPermutations;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.renderer.texture.atlas.sources.DirectoryLister;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.armortrim.TrimMaterial;

public class ClayworksTrims {
    public static final ResourceLocation DECORATED_POT_ATLAS = new ResourceLocation("decorated_pot");
    public static final ResourceLocation COLOR_PALETTE_KEY = new ResourceLocation("clayworks", "entity/decorated_pot_color_palettes/decorated_pot_palette");
    public static final ResourceLocation TRIM_PALETTE_KEY = new ResourceLocation("clayworks", "entity/decorated_pot_trim_palettes/trim_palette");

    public static BlueprintPalettedPermutations colorPermutations() {
        return new BlueprintPalettedPermutations(Either.left(List.of(new DirectoryLister("entity/decorated_pot", "entity/decorated_pot/"))), COLOR_PALETTE_KEY, ClayworksTrims.getColorPermutations());
    }

    private static HashMap<String, ResourceLocation> getColorPermutations() {
        HashMap<String, ResourceLocation> permutations = new HashMap<String, ResourceLocation>();
        for (DyeColor key : DyeColor.values()) {
            String name = key.m_41065_();
            permutations.put(name, new ResourceLocation("clayworks", "entity/decorated_pot_color_palettes/" + name));
        }
        return permutations;
    }

    @SafeVarargs
    public static BlueprintPalettedPermutations materialPatternPermutations(ResourceKey<TrimMaterial> ... keys) {
        return new BlueprintPalettedPermutations(Either.left(List.of(new DirectoryLister("entity/decorated_pot_trim_patterns", "entity/decorated_pot_trim_patterns/"))), TRIM_PALETTE_KEY, ClayworksTrims.getPermutations(keys));
    }

    @SafeVarargs
    private static HashMap<String, ResourceLocation> getPermutations(ResourceKey<TrimMaterial> ... keys) {
        HashMap<String, ResourceLocation> permutations = new HashMap<String, ResourceLocation>();
        for (ResourceKey<TrimMaterial> key : keys) {
            ResourceLocation location = key.m_135782_();
            Object name = location.m_135827_() + "_" + location.m_135815_();
            if (location.m_135827_().equals("minecraft")) {
                name = location.m_135815_();
                location = new ResourceLocation("clayworks", (String)name);
            }
            permutations.put((String)name, location.m_247266_(string -> "entity/decorated_pot_trim_palettes/" + string));
        }
        return permutations;
    }
}

