/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.octolib.modules.particles.trail;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.hurts.octostudios.octolib.modules.particles.OctoRenderManager;
import it.hurts.octostudios.octolib.modules.particles.RenderProvider;
import it.hurts.octostudios.octolib.modules.particles.trail.DefaultTrailBuffer;
import it.hurts.octostudios.octolib.modules.particles.trail.TrailBuffer;
import it.hurts.octostudios.octolib.util.ColorUtils;
import it.hurts.octostudios.octolib.util.TesselatorUtils;
import it.hurts.octostudios.octolib.util.VectorUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public interface TrailProvider
extends RenderProvider<TrailProvider, TrailBuffer> {
    @Override
    default public TrailBuffer createBuffer() {
        return new DefaultTrailBuffer(this.getTrailMaxLength());
    }

    @Override
    default public boolean shouldRender(TrailBuffer buffer) {
        return this.isTrailAlive() || !this.disappearAfterDeath() && buffer.size() != 0;
    }

    @Override
    default public Vec3 getRenderPosition(float partialTick) {
        return this.getTrailPosition(partialTick);
    }

    public Vec3 getTrailPosition(float var1);

    @Override
    @Deprecated
    default public double getRenderDistance() {
        return this.getTrailRenderDistance();
    }

    default public double getTrailRenderDistance() {
        return 64.0;
    }

    @Override
    @Deprecated
    default public int getUpdateFrequency() {
        return this.getTrailUpdateFrequency();
    }

    public int getTrailUpdateFrequency();

    public boolean isTrailAlive();

    default public boolean isTrailGrowing() {
        return true;
    }

    default public boolean disappearAfterDeath() {
        return false;
    }

    public int getTrailMaxLength();

    public int getTrailFadeInColor();

    public int getTrailFadeOutColor();

    public double getTrailScale();

    default public int getTrailInterpolationPoints() {
        return 1;
    }

    default public List<Vec3> getTrailRenderPositions(List<Vec3> points, float pTicks) {
        if (points.size() < 3) {
            return points;
        }
        ArrayList<Vec3> interpolated = new ArrayList<Vec3>(List.of(points.get(0)));
        for (int i = 1; i < points.size() - 2; ++i) {
            interpolated.add(points.get(i + 1).m_165921_(points.get(i), (double)pTicks));
        }
        return interpolated;
    }

    @Override
    @Deprecated
    default public void render(float pTicks, PoseStack poseStack, MultiBufferSource bufferSourceList) {
        this.renderTrail(pTicks, poseStack, bufferSourceList);
    }

    default public void renderTrail(float pTicks, PoseStack poseStack, MultiBufferSource bufferSourceList) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        Vec3 matrixTranslation = this.getRenderPosition(pTicks);
        if (world == null) {
            return;
        }
        long time = world.m_46467_();
        int segments = this.getTrailMaxLength();
        if (segments <= 0 || this.getTrailUpdateFrequency() <= 0) {
            return;
        }
        ArrayList<Vec3> partialPoses = new ArrayList<Vec3>();
        float partial = (float)((int)(time % (long)this.getTrailUpdateFrequency())) + pTicks;
        TrailBuffer buffer = (TrailBuffer)OctoRenderManager.getOrCreateBuffer(this);
        List<Vec3> points = new ArrayList<Vec3>();
        if (this.isTrailAlive()) {
            points.add(new Vec3(0.0, 0.0, 0.0));
        }
        for (Vec3 vec3 : buffer) {
            points.add(vec3.m_82546_(matrixTranslation));
        }
        if ((points = this.getTrailRenderPositions(points, pTicks)).size() > 2) {
            for (int i = 0; i < points.size() - 1; ++i) {
                float p;
                Vec3 p0 = i == 0 ? points.get(0) : points.get(i - 1);
                Vec3 p1 = points.get(i);
                Vec3 p2 = points.get(i + 1);
                Vec3 p3 = i == points.size() - 2 ? points.get(points.size() - 1) : points.get(i + 2);
                partialPoses.add(p1);
                for (float f = p = (float)(this.getTrailInterpolationPoints() + 1); f < 1.0f; f += 1.0f / p) {
                    partialPoses.add(VectorUtils.catmullromVec(f, p0, p1, p2, p3));
                }
            }
            partialPoses.add(points.get(points.size() - 1));
        } else {
            partialPoses.addAll(points);
        }
        if (points.size() > 1 && this.getTrailMaxLength() + 1 == points.size()) {
            int i = partialPoses.size() - 1;
            partialPoses.set(i, ((Vec3)partialPoses.get(i)).m_82549_(((Vec3)partialPoses.get(i - 1)).m_82546_((Vec3)partialPoses.get(i)).m_82490_((double)partial / (double)this.getTrailUpdateFrequency() * (double)this.getTrailInterpolationPoints())));
        }
        this.draw3dTrail(partialPoses, poseStack, bufferSourceList);
    }

    default public void draw3dTrail(List<Vec3> partialPoses, PoseStack poseStack, MultiBufferSource bufferSourceList) {
        Vec3[][] crossVecs = new Vec3[partialPoses.size()][3];
        for (int i = 1; i < partialPoses.size(); ++i) {
            Vec3 pos1 = partialPoses.get(i - 1);
            Vec3 pos2 = partialPoses.get(i);
            Vec3 vec1 = pos2.m_82546_(pos1);
            Vec3 vec1n = vec1.m_82541_();
            Vec3 notScaled = Math.abs(vec1n.f_82479_) + Math.abs(vec1n.f_82481_) < 0.05 ? vec1.m_82520_(0.05, 0.0, 0.0).m_82537_(VectorUtils.Y_VEC) : vec1.m_82537_(VectorUtils.Y_VEC);
            double len = 1.0f - (float)(i - 1) / (float)partialPoses.size();
            crossVecs[i - 1][0] = notScaled.m_82541_().m_82490_(this.getTrailScale() * len);
            Vec3 axis = partialPoses.get(i - 1).m_82546_(partialPoses.get(i));
            crossVecs[i - 1][1] = VectorUtils.rotate(crossVecs[i - 1][0], axis, 100.0).m_82541_().m_82490_(crossVecs[i - 1][0].m_82553_());
            crossVecs[i - 1][2] = VectorUtils.rotate(crossVecs[i - 1][0], axis, -100.0).m_82541_().m_82490_(crossVecs[i - 1][0].m_82553_());
        }
        Color color1 = new Color(this.getTrailFadeInColor(), true);
        Color color2 = new Color(this.getTrailFadeOutColor(), true);
        poseStack.m_85836_();
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        for (int i = 0; i < partialPoses.size() && crossVecs[i][0] != null; ++i) {
            Vec3 pos2;
            Color c1 = ColorUtils.blend(color1, color2, (float)i / (float)(partialPoses.size() - 1));
            Color c2 = ColorUtils.blend(color1, color2, ((float)i + 1.0f) / (float)(partialPoses.size() - 1));
            Vec3 pos_i = partialPoses.get(i);
            Vec3 pos11 = pos_i.m_82549_(crossVecs[i][0]);
            Vec3 pos12 = pos_i.m_82549_(crossVecs[i][1]);
            Vec3 pos13 = pos_i.m_82549_(crossVecs[i][2]);
            VertexConsumer tes = bufferSourceList.m_6299_(TesselatorUtils.TRAIL_RENDER_TYPE);
            if (i == 0 && partialPoses.size() > 1) {
                pos2 = pos_i.m_82549_(pos_i.m_82546_(partialPoses.get(1)).m_82541_().m_82490_(crossVecs[i][0].m_82553_()));
                TesselatorUtils.drawQuadGradient(tes, matrix4f, (float)pos12.f_82479_, (float)pos12.f_82480_, (float)pos12.f_82481_, (float)pos2.f_82479_, (float)pos2.f_82480_, (float)pos2.f_82481_, (float)pos2.f_82479_, (float)pos2.f_82480_, (float)pos2.f_82481_, (float)pos11.f_82479_, (float)pos11.f_82480_, (float)pos11.f_82481_, c1, c2);
                TesselatorUtils.drawQuadGradient(tes, matrix4f, (float)pos13.f_82479_, (float)pos13.f_82480_, (float)pos13.f_82481_, (float)pos2.f_82479_, (float)pos2.f_82480_, (float)pos2.f_82481_, (float)pos2.f_82479_, (float)pos2.f_82480_, (float)pos2.f_82481_, (float)pos12.f_82479_, (float)pos12.f_82480_, (float)pos12.f_82481_, c1, c2);
                TesselatorUtils.drawQuadGradient(tes, matrix4f, (float)pos11.f_82479_, (float)pos11.f_82480_, (float)pos11.f_82481_, (float)pos2.f_82479_, (float)pos2.f_82480_, (float)pos2.f_82481_, (float)pos2.f_82479_, (float)pos2.f_82480_, (float)pos2.f_82481_, (float)pos13.f_82479_, (float)pos13.f_82480_, (float)pos13.f_82481_, c1, c2);
            }
            if (i == crossVecs.length - 1 || crossVecs[i + 1][0] == null) {
                pos2 = partialPoses.get(i + 1);
                TesselatorUtils.drawQuadGradient(tes, matrix4f, (float)pos11.f_82479_, (float)pos11.f_82480_, (float)pos11.f_82481_, (float)pos2.f_82479_, (float)pos2.f_82480_, (float)pos2.f_82481_, (float)pos2.f_82479_, (float)pos2.f_82480_, (float)pos2.f_82481_, (float)pos12.f_82479_, (float)pos12.f_82480_, (float)pos12.f_82481_, c1, c2);
                TesselatorUtils.drawQuadGradient(tes, matrix4f, (float)pos12.f_82479_, (float)pos12.f_82480_, (float)pos12.f_82481_, (float)pos2.f_82479_, (float)pos2.f_82480_, (float)pos2.f_82481_, (float)pos2.f_82479_, (float)pos2.f_82480_, (float)pos2.f_82481_, (float)pos13.f_82479_, (float)pos13.f_82480_, (float)pos13.f_82481_, c1, c2);
                TesselatorUtils.drawQuadGradient(tes, matrix4f, (float)pos13.f_82479_, (float)pos13.f_82480_, (float)pos13.f_82481_, (float)pos2.f_82479_, (float)pos2.f_82480_, (float)pos2.f_82481_, (float)pos2.f_82479_, (float)pos2.f_82480_, (float)pos2.f_82481_, (float)pos11.f_82479_, (float)pos11.f_82480_, (float)pos11.f_82481_, c1, c2);
                continue;
            }
            Vec3 pos21 = partialPoses.get(i + 1).m_82549_(crossVecs[i + 1][0]);
            Vec3 pos22 = partialPoses.get(i + 1).m_82549_(crossVecs[i + 1][1]);
            Vec3 pos23 = partialPoses.get(i + 1).m_82549_(crossVecs[i + 1][2]);
            TesselatorUtils.drawQuadGradient(tes, matrix4f, (float)pos11.f_82479_, (float)pos11.f_82480_, (float)pos11.f_82481_, (float)pos21.f_82479_, (float)pos21.f_82480_, (float)pos21.f_82481_, (float)pos22.f_82479_, (float)pos22.f_82480_, (float)pos22.f_82481_, (float)pos12.f_82479_, (float)pos12.f_82480_, (float)pos12.f_82481_, c1, c2);
            TesselatorUtils.drawQuadGradient(tes, matrix4f, (float)pos12.f_82479_, (float)pos12.f_82480_, (float)pos12.f_82481_, (float)pos22.f_82479_, (float)pos22.f_82480_, (float)pos22.f_82481_, (float)pos23.f_82479_, (float)pos23.f_82480_, (float)pos23.f_82481_, (float)pos13.f_82479_, (float)pos13.f_82480_, (float)pos13.f_82481_, c1, c2);
            TesselatorUtils.drawQuadGradient(tes, matrix4f, (float)pos13.f_82479_, (float)pos13.f_82480_, (float)pos13.f_82481_, (float)pos23.f_82479_, (float)pos23.f_82480_, (float)pos23.f_82481_, (float)pos21.f_82479_, (float)pos21.f_82480_, (float)pos21.f_82481_, (float)pos11.f_82479_, (float)pos11.f_82480_, (float)pos11.f_82481_, c1, c2);
        }
        poseStack.m_85849_();
    }
}

