/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.model;

import codechicken.lib.render.CCModel;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.uv.UV;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OBJWriter {
    public static void exportObj(Map<String, CCModel> models, PrintWriter p) {
        ArrayList verts = new ArrayList();
        ArrayList uvs = new ArrayList();
        ArrayList normals = new ArrayList();
        ArrayList<int[]> polys = new ArrayList<int[]>();
        for (Map.Entry<String, CCModel> e : models.entrySet()) {
            int[] ia;
            int i;
            p.println("g " + e.getKey());
            CCModel m = e.getValue();
            int vStart = verts.size();
            int uStart = uvs.size();
            int nStart = normals.size();
            boolean hasNormals = m.normals() != null;
            polys.clear();
            for (i = 0; i < m.verts.length; ++i) {
                ia = new int[hasNormals ? 3 : 2];
                ia[0] = OBJWriter.addIndex(verts, m.verts[i].vec);
                ia[1] = OBJWriter.addIndex(uvs, m.verts[i].uv);
                if (hasNormals) {
                    ia[2] = OBJWriter.addIndex(normals, m.normals()[i]);
                }
                polys.add(ia);
            }
            if (vStart < verts.size()) {
                p.println();
                for (i = vStart; i < verts.size(); ++i) {
                    Vector3 v = (Vector3)verts.get(i);
                    p.format("v %s %s %s\n", OBJWriter.clean(v.x), OBJWriter.clean(v.y), OBJWriter.clean(v.z));
                }
            }
            if (uStart < uvs.size()) {
                p.println();
                for (i = uStart; i < uvs.size(); ++i) {
                    UV uv = (UV)uvs.get(i);
                    p.format("vt %s %s\n", OBJWriter.clean(uv.u), OBJWriter.clean(uv.v));
                }
            }
            if (nStart < normals.size()) {
                p.println();
                for (i = nStart; i < normals.size(); ++i) {
                    Vector3 n = (Vector3)normals.get(i);
                    p.format("vn %s %s %s\n", OBJWriter.clean(n.x), OBJWriter.clean(n.y), OBJWriter.clean(n.z));
                }
            }
            p.println();
            for (i = 0; i < polys.size(); ++i) {
                if (i % m.vp == 0) {
                    p.format("f", new Object[0]);
                }
                ia = (int[])polys.get(i);
                if (hasNormals) {
                    p.format(" %d/%d/%d", ia[0], ia[1], ia[2]);
                } else {
                    p.format(" %d/%d", ia[0], ia[1]);
                }
                if (i % m.vp != m.vp - 1) continue;
                p.println();
            }
        }
    }

    private static <T> int addIndex(List<T> list, T elem) {
        int i = list.indexOf(elem) + 1;
        if (i == 0) {
            list.add(elem);
            i = list.size();
        }
        return i;
    }

    private static String clean(double d) {
        return d == (double)((int)d) ? Integer.toString((int)d) : Double.toString(d);
    }
}

