/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.model.pipeline.transformers;

import codechicken.lib.model.IVertexConsumer;
import codechicken.lib.model.Quad;
import codechicken.lib.model.pipeline.IPipelineElementFactory;
import codechicken.lib.model.pipeline.QuadTransformer;
import codechicken.lib.vec.Cuboid6;
import net.minecraft.world.phys.AABB;

public class QuadClamper
extends QuadTransformer {
    public static IPipelineElementFactory<QuadClamper> FACTORY = QuadClamper::new;
    private final Cuboid6 clampBounds = new Cuboid6();

    QuadClamper() {
    }

    public QuadClamper(IVertexConsumer parent, AABB bounds) {
        super(parent);
        this.clampBounds.set(bounds);
    }

    public QuadClamper(IVertexConsumer parent, Cuboid6 bounds) {
        super(parent);
        this.clampBounds.set(bounds);
    }

    public void setClampBounds(AABB bounds) {
        this.clampBounds.set(bounds);
    }

    public void setClampBounds(Cuboid6 bounds) {
        this.clampBounds.set(bounds);
    }

    @Override
    public boolean transform() {
        int s = this.quad.orientation.ordinal() >> 1;
        this.quad.clamp(this.clampBounds);
        Quad.Vertex[] vertices = this.quad.vertices;
        float x1 = vertices[0].dx(s);
        float x2 = vertices[1].dx(s);
        float x3 = vertices[2].dx(s);
        float x4 = vertices[3].dx(s);
        float y1 = vertices[0].dy(s);
        float y2 = vertices[1].dy(s);
        float y3 = vertices[2].dy(s);
        float y4 = vertices[3].dy(s);
        boolean flag1 = x1 == x2 && x2 == x3 && x3 == x4;
        boolean flag2 = y1 == y2 && y2 == y3 && y3 == y4;
        return !flag1 && !flag2;
    }
}

