/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.block;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import snownee.kiwi.util.NotNullByDefault;
import snownee.snow.SnowCommonConfig;
import snownee.snow.block.WaterLoggableSnowVariant;
import snownee.snow.block.entity.SnowCoveredBlockEntity;
import snownee.snow.util.CommonProxy;

@NotNullByDefault
public class SnowSlabBlock
extends Block
implements WaterLoggableSnowVariant {
    protected static final VoxelShape BOTTOM_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape BOTTOM_RENDER_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);

    public SnowSlabBlock(BlockBehaviour.Properties builder) {
        super(builder);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        Block block;
        BlockEntity tile = worldIn.m_7702_(pos);
        if (!(tile instanceof SnowCoveredBlockEntity)) {
            return InteractionResult.PASS;
        }
        SnowCoveredBlockEntity snowTile = (SnowCoveredBlockEntity)tile;
        ItemStack stack = player.m_21120_(handIn);
        if (stack.m_41619_() && player.m_21206_().m_41619_()) {
            snowTile.options.renderOverlay = !snowTile.options.renderOverlay;
            snowTile.refresh();
            return InteractionResult.SUCCESS;
        }
        if (hit.m_82434_() == Direction.UP && snowTile.getContainedState().m_60734_().m_5456_() == stack.m_41720_() && stack.m_41720_() instanceof BlockItem && stack.m_204117_(ItemTags.f_13139_) && (block = ((BlockItem)stack.m_41720_()).m_40614_()) instanceof SlabBlock) {
            BlockState state2 = (BlockState)block.m_49966_().m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE);
            if (!worldIn.f_46443_) {
                worldIn.m_46597_(pos, state2);
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.f_10591_.m_285767_((ServerPlayer)player, pos, stack);
                }
            }
            SoundType soundtype = state2.getSoundType((LevelReader)worldIn, pos, (Entity)player);
            worldIn.m_5594_(player, pos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return BOTTOM_RENDER_SHAPE;
    }

    public VoxelShape m_5939_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return BOTTOM_SHAPE;
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    public void m_213898_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        if (SnowCommonConfig.retainOriginalBlocks || CommonProxy.shouldMelt((Level)worldIn, pos)) {
            worldIn.m_46597_(pos, this.getRaw(state, (BlockGetter)worldIn, pos));
        }
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    @Override
    public BlockState getSnowState(BlockState state, BlockGetter level, BlockPos pos) {
        return Blocks.f_50125_.m_49966_();
    }
}

