/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.plonk.common.packet;

import com.breakinblocks.plonk.common.packet.PacketBase;
import com.breakinblocks.plonk.common.registry.RegistryItems;
import com.breakinblocks.plonk.common.util.EntityUtils;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class PacketPlaceItem
extends PacketBase {
    private BlockHitResult hit;
    private int renderType;

    public PacketPlaceItem() {
    }

    public PacketPlaceItem(BlockHitResult hit, int renderType) {
        this.hit = hit;
        this.renderType = renderType;
    }

    @Override
    public PacketBase read(FriendlyByteBuf buf) {
        this.hit = buf.m_130283_();
        this.renderType = buf.readInt();
        return new PacketPlaceItem(this.hit, this.renderType);
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130062_(this.hit);
        buf.writeInt(this.renderType);
    }

    @Override
    public Optional<NetworkDirection> getNetworkDirection() {
        return Optional.of(NetworkDirection.PLAY_TO_SERVER);
    }

    @Override
    protected void handle(Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer player = Objects.requireNonNull(ctx.get().getSender());
        ItemStack toPlace = new ItemStack((ItemLike)RegistryItems.placed_items, 1);
        ItemStack held = player.m_21205_();
        RegistryItems.placed_items.setHeldStack(toPlace, held, this.renderType);
        EntityUtils.setHeldItemSilent((Player)player, InteractionHand.MAIN_HAND, toPlace);
        if (toPlace.m_41661_(new UseOnContext((Player)player, InteractionHand.MAIN_HAND, this.hit)).m_19077_()) {
            ItemStack newHeld = RegistryItems.placed_items.getHeldStack(toPlace);
            EntityUtils.setHeldItemSilent((Player)player, InteractionHand.MAIN_HAND, newHeld);
        } else {
            EntityUtils.setHeldItemSilent((Player)player, InteractionHand.MAIN_HAND, held);
        }
    }
}

