/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.sensor.custom;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.PredicateSensor;
import net.tslat.smartbrainlib.object.SquareRadius;
import net.tslat.smartbrainlib.registry.SBLMemoryTypes;
import net.tslat.smartbrainlib.registry.SBLSensors;
import net.tslat.smartbrainlib.util.BrainUtils;

public class NearbyBlocksSensor<E extends LivingEntity>
extends PredicateSensor<BlockState, E> {
    private static final List<MemoryModuleType<?>> MEMORIES = ObjectArrayList.of((Object[])new MemoryModuleType[]{SBLMemoryTypes.NEARBY_BLOCKS.get()});
    protected SquareRadius radius = new SquareRadius(1.0, 1.0);

    public NearbyBlocksSensor() {
        this.setPredicate((state, entity) -> !state.m_60795_());
    }

    @Override
    public List<MemoryModuleType<?>> memoriesUsed() {
        return MEMORIES;
    }

    @Override
    public SensorType<? extends ExtendedSensor<?>> type() {
        return SBLSensors.NEARBY_BLOCKS.get();
    }

    public NearbyBlocksSensor<E> setRadius(double radius) {
        return this.setRadius(radius, radius);
    }

    public NearbyBlocksSensor<E> setRadius(double xz, double y) {
        this.radius = new SquareRadius(xz, y);
        return this;
    }

    @Override
    protected void m_5578_(ServerLevel level, E entity) {
        ObjectArrayList blocks = new ObjectArrayList();
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)entity.m_20183_().m_121996_(this.radius.toVec3i()), (BlockPos)entity.m_20183_().m_121955_(this.radius.toVec3i()))) {
            BlockState state = level.m_8055_(pos);
            if (!this.predicate().test(state, entity)) continue;
            blocks.add(Pair.of((Object)pos.m_7949_(), (Object)state));
        }
        if (blocks.isEmpty()) {
            BrainUtils.clearMemory(entity, SBLMemoryTypes.NEARBY_BLOCKS.get());
        } else {
            BrainUtils.setMemory(entity, SBLMemoryTypes.NEARBY_BLOCKS.get(), blocks);
        }
    }
}

