/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import net.minecraft.commands.CommandFunction;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.block_entity.SpecialFlowerBlockEntity;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.crafting.StateIngredientHelper;

public class PureDaisyRecipe
implements vazkii.botania.api.recipe.PureDaisyRecipe {
    public static final int DEFAULT_TIME = 150;
    private final ResourceLocation id;
    protected final StateIngredient input;
    protected final BlockState outputState;
    private final int time;
    private final CommandFunction.CacheableFunction function;

    public PureDaisyRecipe(ResourceLocation id, StateIngredient input, BlockState state, int time, CommandFunction.CacheableFunction function) {
        Preconditions.checkArgument((time >= 0 ? 1 : 0) != 0, (Object)"Time must be nonnegative");
        this.id = id;
        this.input = input;
        this.outputState = state;
        this.time = time;
        this.function = function;
    }

    @Override
    public boolean matches(Level world, BlockPos pos, SpecialFlowerBlockEntity pureDaisy, BlockState state) {
        return this.input.test(state) && this.outputState != state;
    }

    @Override
    public boolean set(Level world, BlockPos pos, SpecialFlowerBlockEntity pureDaisy) {
        if (!world.f_46443_) {
            boolean success = world.m_46597_(pos, this.outputState);
            if (success) {
                ServerLevel serverLevel = (ServerLevel)world;
                MinecraftServer server = serverLevel.m_7654_();
                this.function.m_78002_(server.m_129890_()).ifPresent(command -> {
                    CommandSourceStack context = server.m_129890_().m_136129_().m_81327_((ServerLevel)world).m_81348_(Vec3.m_82539_((Vec3i)pos));
                    server.m_129890_().m_136112_(command, context);
                });
            }
            return success;
        }
        return true;
    }

    @Override
    public StateIngredient getInput() {
        return this.input;
    }

    @Override
    public BlockState getOutputState() {
        return this.outputState;
    }

    @Override
    public CommandFunction.CacheableFunction getSuccessFunction() {
        return this.function;
    }

    @Override
    public int getTime() {
        return this.time;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return BotaniaRecipeTypes.PURE_DAISY_SERIALIZER;
    }

    public static class Serializer
    implements RecipeSerializer<PureDaisyRecipe> {
        @NotNull
        public PureDaisyRecipe fromJson(@NotNull ResourceLocation id, JsonObject object) {
            StateIngredient input = StateIngredientHelper.deserialize(GsonHelper.m_13930_((JsonObject)object, (String)"input"));
            BlockState output = StateIngredientHelper.readBlockState(GsonHelper.m_13930_((JsonObject)object, (String)"output"));
            int time = GsonHelper.m_13824_((JsonObject)object, (String)"time", (int)150);
            String functionIdString = GsonHelper.m_13851_((JsonObject)object, (String)"success_function", null);
            ResourceLocation functionId = functionIdString == null ? null : new ResourceLocation(functionIdString);
            CommandFunction.CacheableFunction function = functionId == null ? CommandFunction.CacheableFunction.f_77990_ : new CommandFunction.CacheableFunction(functionId);
            return new PureDaisyRecipe(id, input, output, time, function);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buf, PureDaisyRecipe recipe) {
            recipe.input.write(buf);
            buf.m_130130_(Block.m_49956_((BlockState)recipe.outputState));
            buf.m_130130_(recipe.time);
        }

        @NotNull
        public PureDaisyRecipe fromNetwork(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buf) {
            StateIngredient input = StateIngredientHelper.read(buf);
            BlockState output = Block.m_49803_((int)buf.m_130242_());
            int time = buf.m_130242_();
            return new PureDaisyRecipe(id, input, output, time, CommandFunction.CacheableFunction.f_77990_);
        }
    }
}

