/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.decor;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.block.BotaniaWaterloggedBlock;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.SimpleInventoryBlockEntity;
import vazkii.botania.common.block.block_entity.TinyPotatoBlockEntity;

public class TinyPotatoBlock
extends BotaniaWaterloggedBlock
implements EntityBlock {
    private static final VoxelShape SHAPE = TinyPotatoBlock.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0);

    public TinyPotatoBlock(BlockBehaviour.Properties builder) {
        super(builder);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.SOUTH));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61374_});
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TinyPotatoBlockEntity) {
            TinyPotatoBlockEntity tater = (TinyPotatoBlockEntity)blockEntity;
            return AbstractContainerMenu.m_38938_((Container)tater);
        }
        return 0;
    }

    public void m_6810_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity be = world.m_7702_(pos);
            if (be instanceof SimpleInventoryBlockEntity) {
                SimpleInventoryBlockEntity inventory = (SimpleInventoryBlockEntity)be;
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)inventory.getItemHandler());
                world.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof TinyPotatoBlockEntity) {
            TinyPotatoBlockEntity tater = (TinyPotatoBlockEntity)tile;
            tater.interact(player, hand, player.m_21120_(hand), hit.m_82434_());
            if (!world.f_46443_) {
                TinyPotatoBlock.spawnHearts((ServerLevel)world, pos);
            }
        }
        return InteractionResult.m_19078_((boolean)world.m_5776_());
    }

    public static void spawnHearts(ServerLevel level, BlockPos pos) {
        AABB box = SHAPE.m_83215_();
        level.m_8767_((ParticleOptions)ParticleTypes.f_123750_, (double)pos.m_123341_() + box.f_82288_ + Math.random() * (box.f_82291_ - box.f_82288_), (double)pos.m_123342_() + box.f_82292_, (double)pos.m_123343_() + box.f_82290_ + Math.random() * (box.f_82293_ - box.f_82290_), 1, 0.0, 0.0, 0.0, 0.0);
    }

    @Override
    @NotNull
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)super.m_5573_(ctx).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)ctx.m_8125_().m_122424_());
    }

    @NotNull
    public BlockState m_6943_(@NotNull BlockState state, Mirror mirror) {
        return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)mirror.m_54848_((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)));
    }

    @NotNull
    public BlockState m_6843_(@NotNull BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)));
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity living, ItemStack stack) {
        BlockEntity blockEntity;
        if (stack.m_41788_() && (blockEntity = world.m_7702_(pos)) instanceof TinyPotatoBlockEntity) {
            TinyPotatoBlockEntity tater = (TinyPotatoBlockEntity)blockEntity;
            tater.name = stack.m_41786_();
        }
    }

    @NotNull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @NotNull
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new TinyPotatoBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return TinyPotatoBlock.createTickerHelper(type, BotaniaBlockEntities.TINY_POTATO, TinyPotatoBlockEntity::commonTick);
    }
}

