/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.integration.jei;

import de.maxhenkel.pipez.Filter;
import de.maxhenkel.pipez.FluidFilter;
import de.maxhenkel.pipez.GasFilter;
import de.maxhenkel.pipez.gui.FilterContainer;
import de.maxhenkel.pipez.gui.FilterScreen;
import de.maxhenkel.pipez.utils.GasUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import mekanism.api.chemical.ChemicalStack;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.ITypedIngredient;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class FilterScreenGhostIngredientHandler
implements IGhostIngredientHandler<FilterScreen> {
    public <I> List<IGhostIngredientHandler.Target<I>> getTargetsTyped(FilterScreen gui, ITypedIngredient<I> ingredient, boolean doStart) {
        Filter<?> filter = ((FilterContainer)gui.m_6262_()).getFilter();
        ArrayList<IGhostIngredientHandler.Target<I>> list = new ArrayList<IGhostIngredientHandler.Target<I>>();
        Object object = ingredient.getIngredient();
        if (object instanceof ItemStack) {
            ItemStack stack = (ItemStack)object;
            if (this.testItemStack(filter, stack)) {
                list.add(this.getItemHoverAreaTarget(gui, i -> gui.onInsertStack(stack)));
            }
        } else if (filter instanceof FluidFilter && (object = ingredient.getIngredient()) instanceof FluidStack) {
            FluidStack stack = (FluidStack)object;
            list.add(this.getItemHoverAreaTarget(gui, i -> gui.onInsertStack(stack)));
        } else if (filter instanceof GasFilter && (object = ingredient.getIngredient()) instanceof ChemicalStack) {
            ChemicalStack stack = (ChemicalStack)object;
            list.add(this.getItemHoverAreaTarget(gui, i -> gui.onInsertStack(stack)));
        }
        return list;
    }

    private boolean testItemStack(Filter<?> filter, ItemStack stack) {
        if (filter instanceof FluidFilter) {
            return FluidUtil.getFluidContained((ItemStack)stack).isPresent();
        }
        if (filter instanceof GasFilter) {
            return GasUtils.getGasContained(stack) != null;
        }
        return true;
    }

    private <I> IGhostIngredientHandler.Target<I> getItemHoverAreaTarget(final FilterScreen gui, final Consumer<I> consumer) {
        return new IGhostIngredientHandler.Target<I>(){

            public Rect2i getArea() {
                return new Rect2i(gui.getGuiLeft() + 8, gui.getGuiTop() + 18, 16, 16);
            }

            public void accept(I ingredient) {
                consumer.accept(ingredient);
            }
        };
    }

    public void onComplete() {
    }
}

