/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez;

import de.maxhenkel.pipez.corelib.CachedValue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.ModelEvent;

public class ModelRegistry {
    public static void onModelRegister(ModelEvent.RegisterAdditional event) {
        for (Model model : Model.values()) {
            event.register(model.getResourceLocation());
        }
    }

    public static void onModelBake(ModelEvent.BakingCompleted event) {
        for (Model model : Model.values()) {
            model.getCachedModel().invalidate();
        }
    }

    public static enum Model {
        ENERGY_PIPE_EXTRACT("block/energy_pipe_extract"),
        FLUID_PIPE_EXTRACT("block/fluid_pipe_extract"),
        GAS_PIPE_EXTRACT("block/gas_pipe_extract"),
        ITEM_PIPE_EXTRACT("block/item_pipe_extract"),
        UNIVERSAL_PIPE_EXTRACT("block/universal_pipe_extract");

        private final ResourceLocation resource;
        private final CachedValue<BakedModel> cachedModel;

        private Model(String name) {
            this.resource = new ResourceLocation("pipez", name);
            this.cachedModel = new CachedValue<BakedModel>(() -> Minecraft.m_91087_().m_91304_().getModel(this.resource));
        }

        public ResourceLocation getResourceLocation() {
            return this.resource;
        }

        public CachedValue<BakedModel> getCachedModel() {
            return this.cachedModel;
        }
    }
}

