/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.additional_attributes.registry;

import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class AAttributes {
    public static final int MAX = 1024;
    public static final DeferredRegister<Attribute> ATTRIBUTES = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.ATTRIBUTES, (String)"additional_attributes");
    public static final RegistryObject<Attribute> FISHING_LURE = AAttributes.createAttribute("fishing_lure");
    public static final RegistryObject<Attribute> FISHING_LUCK = AAttributes.createAttribute("fishing_luck");
    public static final RegistryObject<Attribute> LOOTING = AAttributes.createAttribute("looting");
    public static final RegistryObject<Attribute> RESPIRATION = AAttributes.createAttribute("respiration");
    public static final RegistryObject<Attribute> HARVEST_BONUS = AAttributes.createAttribute("harvest");

    public static RegistryObject<Attribute> createAttribute(String id) {
        return ATTRIBUTES.register(id, () -> new RangedAttribute("attribute.additional_attributes." + id, 0.0, 0.0, 1024.0).m_22084_(true));
    }

    @SubscribeEvent
    public static void setAttributes(EntityAttributeModificationEvent event) {
        ATTRIBUTES.getEntries().forEach(attribute -> event.add(EntityType.f_20532_, (Attribute)attribute.get()));
    }

    public static int getIntValue(LivingEntity entity, Attribute attribute, double base) {
        if (entity.m_21204_() == null || !entity.m_21204_().m_22171_(attribute)) {
            return (int)base;
        }
        double value = AAttributes.getAttributeValue(entity, attribute, base);
        int clippedValue = (int)value;
        if ((double)entity.m_217043_().m_188501_() < value - (double)clippedValue) {
            value += 1.0;
        }
        return (int)value;
    }

    public static double getAttributeValue(LivingEntity entity, Attribute attribute, double base) {
        if (attribute == null) {
            return 0.0;
        }
        AttributeInstance instance = entity.m_21051_(attribute);
        if (instance == null) {
            return 0.0;
        }
        if (instance.m_22115_() != base) {
            instance.m_22100_(base);
        }
        return instance.m_22135_();
    }
}

