/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.littlejoys.recipe;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import net.blay09.mods.littlejoys.api.EventCondition;
import net.blay09.mods.littlejoys.recipe.ModRecipeTypes;
import net.blay09.mods.littlejoys.recipe.condition.EventConditionRegistry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record DropRushRecipe(ResourceLocation identifier, EventCondition eventCondition, float chanceMultiplier, ResourceLocation lootTable, int rolls, float seconds, int range, Weight weight) implements Recipe<Container>,
WeightedEntry
{
    private static final Logger LOGGER = LoggerFactory.getLogger(DropRushRecipe.class);

    public RecipeType<DropRushRecipe> m_6671_() {
        return ModRecipeTypes.dropRushRecipeType;
    }

    public boolean m_5818_(Container container, Level level) {
        return false;
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.identifier;
    }

    public RecipeSerializer<DropRushRecipe> m_7707_() {
        return ModRecipeTypes.dropRushRecipeSerializer;
    }

    public Weight m_142631_() {
        return this.weight;
    }

    public static class Serializer
    implements RecipeSerializer<DropRushRecipe> {
        public DropRushRecipe fromJson(ResourceLocation identifier, JsonObject jsonObject) {
            EventCondition eventCondition = (EventCondition)((Pair)EventConditionRegistry.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)GsonHelper.m_289747_((JsonObject)jsonObject, (String)"eventCondition")).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0))).getFirst();
            ResourceLocation lootTable = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"lootTable"));
            float chanceMultiplier = GsonHelper.m_13820_((JsonObject)jsonObject, (String)"chanceMultiplier", (float)1.0f);
            int rolls = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"rolls", (int)8);
            float seconds = GsonHelper.m_13820_((JsonObject)jsonObject, (String)"seconds", (float)12.5f);
            int range = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"range", (int)8);
            Weight weight = Weight.m_146282_((int)GsonHelper.m_13824_((JsonObject)jsonObject, (String)"weight", (int)1));
            return new DropRushRecipe(identifier, eventCondition, chanceMultiplier, lootTable, rolls, seconds, range, weight);
        }

        public DropRushRecipe fromNetwork(ResourceLocation identifier, FriendlyByteBuf buf) {
            EventCondition eventCondition = EventConditionRegistry.conditionFromNetwork(buf);
            float chance = buf.readFloat();
            ResourceLocation lootTable = buf.m_130281_();
            int rolls = buf.m_130242_();
            float seconds = buf.readFloat();
            int range = buf.m_130242_();
            Weight weight = Weight.m_146282_((int)buf.m_130242_());
            return new DropRushRecipe(identifier, eventCondition, chance, lootTable, rolls, seconds, range, weight);
        }

        public void toNetwork(FriendlyByteBuf buf, DropRushRecipe recipe) {
            EventConditionRegistry.conditionToNetwork(buf, recipe.eventCondition);
            buf.writeFloat(recipe.chanceMultiplier);
            buf.m_130085_(recipe.lootTable);
            buf.m_130130_(recipe.rolls);
            buf.writeFloat(recipe.seconds);
            buf.m_130130_(recipe.range);
            buf.m_130130_(recipe.weight.m_146281_());
        }
    }
}

