/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.littlejoys.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.TickPhase;
import net.blay09.mods.balm.api.event.TickType;
import net.blay09.mods.littlejoys.LittleJoysConfig;
import net.blay09.mods.littlejoys.block.ModBlocks;
import net.blay09.mods.littlejoys.block.entity.FishingSpotBlockEntity;
import net.blay09.mods.littlejoys.handler.ChunkLimitManager;
import net.blay09.mods.littlejoys.particle.ModParticles;
import net.blay09.mods.littlejoys.recipe.FishingSpotRecipe;
import net.blay09.mods.littlejoys.recipe.ModRecipeTypes;
import net.blay09.mods.littlejoys.recipe.condition.EventContextImpl;
import net.blay09.mods.littlejoys.stats.ModStats;
import net.blay09.mods.littlejoys.tag.ModPoiTypeTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.Nullable;

public class FishingSpotHandler {
    private static final RandomSource random = RandomSource.m_216327_();
    private static final String FISHING_SPOT_COOLDOWN = "fishingSpotCooldown";

    public static void initialize() {
        Balm.getEvents().onTickEvent(TickType.ServerPlayer, TickPhase.End, player -> {
            CompoundTag playerData = Balm.getHooks().getPersistentData((Player)player);
            CompoundTag littleJoysData = playerData.m_128469_("littlejoys");
            playerData.m_128365_("littlejoys", (Tag)littleJoysData);
            int cooldown = littleJoysData.m_128451_(FISHING_SPOT_COOLDOWN);
            if (cooldown > 0) {
                littleJoysData.m_128405_(FISHING_SPOT_COOLDOWN, cooldown - 1);
            } else {
                ServerLevel level = (ServerLevel)player.m_9236_();
                PoiManager poiManager = level.m_8904_();
                BlockPos centerPos = FishingSpotHandler.getOriginForNextSpawn((Player)player);
                int checkRange = LittleJoysConfig.getActive().fishingSpots.minimumDistanceBetween;
                int spawnRange = LittleJoysConfig.getActive().fishingSpots.spawnDistance;
                Optional fishingSpotInRange = poiManager.m_27181_(it -> it.m_203656_(ModPoiTypeTags.FISHING_SPOTS), centerPos, checkRange, PoiManager.Occupancy.ANY).findAny();
                if (fishingSpotInRange.isEmpty()) {
                    int offsetX = random.m_188503_(spawnRange + spawnRange) - spawnRange;
                    int offsetZ = random.m_188503_(spawnRange + spawnRange) - spawnRange;
                    BlockPos randomOffsetPos = new BlockPos(centerPos.m_123341_() + offsetX, centerPos.m_123341_(), centerPos.m_123343_() + offsetZ);
                    BlockPos surfacePos = level.m_5452_(Heightmap.Types.WORLD_SURFACE, randomOffsetPos).m_7495_();
                    BlockPos aboveSurfacePos = surfacePos.m_7494_();
                    int totalSpots = ChunkLimitManager.get(level).getTotalFishingSpotsInChunk(aboveSurfacePos);
                    int maxSpots = LittleJoysConfig.getActive().fishingSpots.totalLimitPerChunk;
                    if (maxSpots > 0 && totalSpots >= maxSpots) {
                        littleJoysData.m_128405_(FISHING_SPOT_COOLDOWN, 200);
                        return;
                    }
                    if (!level.m_8055_(aboveSurfacePos).m_247087_()) {
                        littleJoysData.m_128405_(FISHING_SPOT_COOLDOWN, 20);
                        return;
                    }
                    if (FishingSpotHandler.createFishingSpot(level, aboveSurfacePos, player)) {
                        littleJoysData.m_128405_(FISHING_SPOT_COOLDOWN, Math.round(LittleJoysConfig.getActive().fishingSpots.spawnIntervalSeconds * 20.0f));
                    } else {
                        littleJoysData.m_128405_(FISHING_SPOT_COOLDOWN, 20);
                    }
                } else {
                    littleJoysData.m_128405_(FISHING_SPOT_COOLDOWN, 200);
                }
            }
        });
    }

    public static boolean createFishingSpot(ServerLevel level, BlockPos pos, ServerPlayer player) {
        return FishingSpotHandler.findRecipe(level, pos, player).map(recipe -> {
            FishingSpotHandler.createFishingSpot(level, pos, recipe);
            return true;
        }).orElse(false);
    }

    public static void createFishingSpot(ServerLevel level, BlockPos pos, FishingSpotRecipe recipe) {
        level.m_7731_(pos, ModBlocks.fishingSpot.m_49966_(), 3);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FishingSpotBlockEntity) {
            FishingSpotBlockEntity fishingSpot = (FishingSpotBlockEntity)blockEntity;
            fishingSpot.setRecipeId(recipe.identifier());
        }
        ChunkLimitManager.get(level).trackFishingSpot(pos);
    }

    private static BlockPos getOriginForNextSpawn(Player player) {
        int projectForwardDistance = LittleJoysConfig.getActive().fishingSpots.projectForwardDistance;
        Direction forwardDirection = player.m_6350_();
        return player.m_20183_().m_5484_(forwardDirection, projectForwardDistance);
    }

    private static Optional<FishingSpotRecipe> findRecipe(ServerLevel level, BlockPos pos, ServerPlayer player) {
        RecipeManager recipeManager = level.m_7465_();
        List recipes = recipeManager.m_44013_(ModRecipeTypes.fishingSpotRecipeType);
        ArrayList<FishingSpotRecipe> candidates = new ArrayList<FishingSpotRecipe>();
        for (FishingSpotRecipe recipe : recipes) {
            if (!FishingSpotHandler.isValidRecipeFor(recipe, level, pos, player)) continue;
            candidates.add(recipe);
        }
        return WeightedRandom.m_216822_((RandomSource)random, candidates);
    }

    private static boolean isValidRecipeFor(FishingSpotRecipe recipe, ServerLevel level, BlockPos pos, ServerPlayer player) {
        EventContextImpl context = new EventContextImpl((Level)level, pos, level.m_8055_(pos), (Player)player);
        return recipe.eventCondition().test(context);
    }

    private static Optional<FishingSpotRecipe> recipeById(ServerLevel level, @Nullable ResourceLocation recipeId) {
        RecipeManager recipeManager = level.m_7465_();
        if (recipeId == null) {
            return Optional.empty();
        }
        Recipe recipe = recipeManager.m_44043_(recipeId).orElse(null);
        if (recipe instanceof FishingSpotRecipe) {
            FishingSpotRecipe fishingSpotRecipe = (FishingSpotRecipe)recipe;
            return Optional.of(fishingSpotRecipe);
        }
        return Optional.empty();
    }

    public static Optional<FishingSpotRecipe> resolveRecipe(ServerLevel level, BlockPos pos, @Nullable ResourceLocation recipeId, ServerPlayer player) {
        Optional<FishingSpotRecipe> optRecipe = FishingSpotHandler.recipeById(level, recipeId);
        if (optRecipe.isPresent() && FishingSpotHandler.isValidRecipeFor(optRecipe.get(), level, pos, player)) {
            return optRecipe;
        }
        return FishingSpotHandler.findRecipe(level, pos, player);
    }

    public static Optional<BlockPos> findFishingSpot(ServerLevel serverLevel, BlockPos pos) {
        PoiManager poiManager = serverLevel.m_8904_();
        int range = LittleJoysConfig.getActive().fishingSpots.fishingRangeTolerance;
        return poiManager.m_27192_(it -> it.m_203656_(ModPoiTypeTags.FISHING_SPOTS), pos, range, PoiManager.Occupancy.ANY);
    }

    public static int claimFishingSpot(ServerLevel level, BlockPos pos) {
        level.m_8767_((ParticleOptions)ModParticles.goldRush, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), 2, 0.25, 0.25, 0.25, 0.0);
        if (LittleJoysConfig.getActive().fishingSpots.secondsUntilLured < 0.0f) {
            return -1;
        }
        return Math.round(LittleJoysConfig.getActive().fishingSpots.secondsUntilLured * 20.0f);
    }

    public static void consumeFishingSpot(@Nullable Player player, ServerLevel level, BlockPos pos) {
        float x = (float)pos.m_123341_() + 0.5f;
        float y = (float)pos.m_123342_() + 0.5f;
        float z = (float)pos.m_123343_() + 0.5f;
        level.m_8767_((ParticleOptions)ParticleTypes.f_123796_, (double)x, (double)y, (double)z, 8, 0.25, 0.25, 0.25, 0.0);
        level.m_46961_(pos, false);
        if (player != null) {
            player.m_36220_(ModStats.fishingSpotsFished);
            CompoundTag playerData = Balm.getHooks().getPersistentData(player);
            CompoundTag littleJoysData = playerData.m_128469_("littlejoys");
            playerData.m_128365_("littlejoys", (Tag)littleJoysData);
            littleJoysData.m_128405_(FISHING_SPOT_COOLDOWN, Math.round(LittleJoysConfig.getActive().fishingSpots.afterFishingCooldownSeconds * 20.0f));
        }
    }
}

