/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.littlejoys.handler;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.BreakBlockEvent;
import net.blay09.mods.balm.api.event.TickPhase;
import net.blay09.mods.balm.api.event.TickType;
import net.blay09.mods.littlejoys.LittleJoysConfig;
import net.blay09.mods.littlejoys.entity.DropRushItemEntity;
import net.blay09.mods.littlejoys.handler.DropRushInstance;
import net.blay09.mods.littlejoys.network.protocol.ClientboundStartDropRushPacket;
import net.blay09.mods.littlejoys.network.protocol.ClientboundStopDropRushPacket;
import net.blay09.mods.littlejoys.recipe.DropRushRecipe;
import net.blay09.mods.littlejoys.recipe.ModRecipeTypes;
import net.blay09.mods.littlejoys.recipe.condition.EventContextImpl;
import net.blay09.mods.littlejoys.stats.ModStats;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class DropRushHandler {
    private static final RandomSource random = RandomSource.m_216327_();
    private static final int DROP_TICKS = 50;
    private static final Table<ResourceKey<Level>, BlockPos, DropRushInstance> activeDropRushes = HashBasedTable.create();

    public static void initialize() {
        Balm.getEvents().onEvent(BreakBlockEvent.class, event -> {
            ServerLevel serverLevel;
            Player player;
            block7: {
                block6: {
                    if (event.getPlayer().m_150110_().f_35937_) {
                        return;
                    }
                    if (Balm.getHooks().isFakePlayer(event.getPlayer())) {
                        return;
                    }
                    if (EnchantmentHelper.m_272262_((ItemStack)event.getPlayer().m_21205_())) {
                        return;
                    }
                    Level level = event.getLevel();
                    player = event.getPlayer();
                    if (!(level instanceof ServerLevel)) break block6;
                    serverLevel = (ServerLevel)level;
                    if (player instanceof ServerPlayer) break block7;
                }
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)player;
            DropRushHandler.rollForDropRush(serverLevel, event.getPos(), event.getState(), serverPlayer);
        });
        Balm.getEvents().onTickEvent(TickType.ServerLevel, TickPhase.Start, level -> {
            for (DropRushInstance dropRush : activeDropRushes.row((Object)level.m_46472_()).values()) {
                Player player;
                dropRush.setTicksPassed(dropRush.getTicksPassed() + 1);
                dropRush.setDropCooldownTicks(dropRush.getDropCooldownTicks() - 1);
                List<ItemStack> dropsLeft = dropRush.getDrops();
                if (dropRush.getDropCooldownTicks() <= 0 && !dropsLeft.isEmpty()) {
                    ItemStack nextDropItemStack = dropsLeft.remove(dropsLeft.size() - 1);
                    DropRushHandler.spawnDropRushItem(level, dropRush, nextDropItemStack);
                    dropRush.setDropCooldownTicks(dropRush.getTicksPerDrop());
                } else if (dropRush.getTicksPassed() >= 50) {
                    for (ItemStack itemStack : dropsLeft) {
                        DropRushHandler.spawnDropRushItem(level, dropRush, itemStack);
                    }
                }
                dropRush.getEntities().removeIf(DropRushItemEntity::isPickedUp);
                if (dropRush.getEntities().isEmpty()) {
                    player = level.m_46003_(dropRush.getPlayerId());
                    if (player == null) continue;
                    Balm.getNetworking().sendTo(player, (Object)new ClientboundStopDropRushPacket(ClientboundStopDropRushPacket.Reason.FULL_CLEAR));
                    continue;
                }
                if (dropRush.getTicksPassed() < dropRush.getMaxTicks() || (player = level.m_46003_(dropRush.getPlayerId())) == null) continue;
                Balm.getNetworking().sendTo(player, (Object)new ClientboundStopDropRushPacket(ClientboundStopDropRushPacket.Reason.TIME_UP));
            }
            activeDropRushes.values().removeIf(it -> it.getTicksPassed() >= it.getMaxTicks() || it.getEntities().isEmpty());
        });
    }

    public static boolean rollForDropRush(ServerLevel level, BlockPos pos, BlockState state, ServerPlayer player) {
        return DropRushHandler.rollRecipe(level, pos, state, player, false).map(recipe -> {
            DropRushHandler.startDropRush(level, pos, player, recipe);
            return true;
        }).orElse(false);
    }

    public static boolean startDropRush(ServerLevel level, BlockPos pos, BlockState state, ServerPlayer player) {
        return DropRushHandler.rollRecipe(level, pos, state, player, true).map(recipe -> {
            DropRushHandler.startDropRush(level, pos, player, recipe);
            return true;
        }).orElse(false);
    }

    public static void startDropRush(ServerLevel level, BlockPos pos, ServerPlayer player, DropRushRecipe recipe) {
        DropRushInstance dropRushInstance = new DropRushInstance(player.m_20148_(), pos, recipe.lootTable(), (int)Math.floor(20.0f * recipe.seconds()));
        LootParams.Builder lootParamsBuilder = new LootParams.Builder(level).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_287289_(LootContextParams.f_81462_, (Object)level.m_7702_(pos));
        ResourceLocation lootTableId = recipe.lootTable();
        if (lootTableId != BuiltInLootTables.f_78712_) {
            LootParams lootParams = lootParamsBuilder.m_287286_(LootContextParams.f_81461_, (Object)level.m_8055_(pos)).m_287235_(LootContextParamSets.f_81421_);
            LootTable lootTable = level.m_7654_().m_278653_().m_278676_(lootTableId);
            for (int i = 0; i < recipe.rolls(); ++i) {
                lootTable.m_287195_(lootParams).forEach(dropRushInstance::addDrop);
            }
        }
        dropRushInstance.setTicksPerDrop(Math.max(50 / Math.max(1, dropRushInstance.getDrops().size()), 1));
        Balm.getNetworking().sendTo((Player)player, (Object)new ClientboundStartDropRushPacket(dropRushInstance.getMaxTicks()));
        player.m_36220_(ModStats.dropRushesTriggered);
        activeDropRushes.put((Object)level.m_46472_(), (Object)pos, (Object)dropRushInstance);
    }

    private static void spawnDropRushItem(Level level, DropRushInstance dropRush, ItemStack itemStack) {
        float deltaX = (random.m_188501_() - 0.5f) * 0.7f;
        float deltaY = random.m_188501_() * 0.5f + 0.2f;
        float deltaZ = (random.m_188501_() - 0.5f) * 0.7f;
        float x = (float)dropRush.getPos().m_123341_() + 0.5f;
        float y = (float)dropRush.getPos().m_123342_() + 0.25f;
        float z = (float)dropRush.getPos().m_123343_() + 0.5f;
        DropRushItemEntity itemEntity = new DropRushItemEntity(level, x, y, z, itemStack, deltaX, deltaY, deltaZ);
        itemEntity.m_32010_(20);
        itemEntity.m_149678_();
        itemEntity.setActualLifetime(dropRush.getMaxTicks() - dropRush.getTicksPassed());
        itemEntity.m_266426_(dropRush.getPlayerId());
        level.m_7967_((Entity)itemEntity);
        dropRush.addEntity(itemEntity);
    }

    private static Optional<DropRushRecipe> rollRecipe(ServerLevel level, BlockPos pos, BlockState state, ServerPlayer player, boolean force) {
        RecipeManager recipeManager = level.m_7465_();
        List recipes = recipeManager.m_44013_(ModRecipeTypes.dropRushRecipeType);
        ArrayList<DropRushRecipe> candidates = new ArrayList<DropRushRecipe>();
        float baseChance = LittleJoysConfig.getActive().dropRush.baseChance;
        float roll = random.m_188501_();
        for (DropRushRecipe recipe : recipes) {
            if (!DropRushHandler.isValidRecipeFor(recipe, level, pos, state, player) || !force && !(roll <= baseChance * recipe.chanceMultiplier())) continue;
            candidates.add(recipe);
        }
        return WeightedRandom.m_216822_((RandomSource)random, candidates);
    }

    private static boolean isValidRecipeFor(DropRushRecipe recipe, ServerLevel level, BlockPos pos, BlockState state, ServerPlayer player) {
        EventContextImpl context = new EventContextImpl((Level)level, pos, state, (Player)player);
        return recipe.eventCondition().test(context);
    }
}

