/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.littlejoys.handler;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.saveddata.SavedData;

public class ChunkLimitManager
extends SavedData {
    private static final String DATA_NAME = "littlejoys";
    private static final String FISHING_SPOT_CHUNKS = "FishingSpotChunks";
    private static final String DIG_SPOT_CHUNKS = "DigSpotChunks";
    private final Map<Long, Integer> fishingSpotCounts = new HashMap<Long, Integer>();
    private final Map<Long, Integer> digSpotCounts = new HashMap<Long, Integer>();

    public int getTotalFishingSpotsInChunk(BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        long chunkKey = chunkPos.m_45588_();
        return this.fishingSpotCounts.getOrDefault(chunkKey, 0);
    }

    public int getTotalDigSpotsInChunk(BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        long chunkKey = chunkPos.m_45588_();
        return this.digSpotCounts.getOrDefault(chunkKey, 0);
    }

    public void trackFishingSpot(BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        long chunkKey = chunkPos.m_45588_();
        Integer currentCount = this.fishingSpotCounts.getOrDefault(chunkKey, 0);
        this.fishingSpotCounts.put(chunkKey, currentCount + 1);
        this.m_77762_();
    }

    public void trackDigSpot(BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        long chunkKey = chunkPos.m_45588_();
        Integer currentCount = this.digSpotCounts.getOrDefault(chunkKey, 0);
        this.digSpotCounts.put(chunkKey, currentCount + 1);
        this.m_77762_();
    }

    public static ChunkLimitManager read(CompoundTag tag) {
        int count;
        long chunkKey;
        ChunkLimitManager manager = new ChunkLimitManager();
        if (tag.m_128425_(FISHING_SPOT_CHUNKS, 10)) {
            CompoundTag fishingSpotsTag = tag.m_128469_(FISHING_SPOT_CHUNKS);
            for (String key : fishingSpotsTag.m_128431_()) {
                chunkKey = Long.parseLong(key);
                count = fishingSpotsTag.m_128451_(key);
                manager.fishingSpotCounts.put(chunkKey, count);
            }
        }
        if (tag.m_128425_(DIG_SPOT_CHUNKS, 10)) {
            CompoundTag digSpotsTag = tag.m_128469_(DIG_SPOT_CHUNKS);
            for (String key : digSpotsTag.m_128431_()) {
                chunkKey = Long.parseLong(key);
                count = digSpotsTag.m_128451_(key);
                manager.digSpotCounts.put(chunkKey, count);
            }
        }
        return manager;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        CompoundTag fishingSpotsTag = new CompoundTag();
        for (Map.Entry<Long, Integer> entry : this.fishingSpotCounts.entrySet()) {
            fishingSpotsTag.m_128405_(String.valueOf(entry.getKey()), entry.getValue().intValue());
        }
        tag.m_128365_(FISHING_SPOT_CHUNKS, (Tag)fishingSpotsTag);
        CompoundTag digSpotsTag = new CompoundTag();
        for (Map.Entry<Long, Integer> entry : this.digSpotCounts.entrySet()) {
            digSpotsTag.m_128405_(String.valueOf(entry.getKey()), entry.getValue().intValue());
        }
        tag.m_128365_(DIG_SPOT_CHUNKS, (Tag)digSpotsTag);
        return tag;
    }

    public static ChunkLimitManager get(ServerLevel level) {
        return (ChunkLimitManager)level.m_8895_().m_164861_(ChunkLimitManager::read, ChunkLimitManager::new, DATA_NAME);
    }
}

