/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.littlejoys.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import net.blay09.mods.balm.api.command.BalmCommands;
import net.blay09.mods.littlejoys.handler.DigSpotHandler;
import net.blay09.mods.littlejoys.handler.DropRushHandler;
import net.blay09.mods.littlejoys.handler.FishingSpotHandler;
import net.blay09.mods.littlejoys.handler.GoldRushHandler;
import net.blay09.mods.littlejoys.recipe.DigSpotRecipe;
import net.blay09.mods.littlejoys.recipe.DropRushRecipe;
import net.blay09.mods.littlejoys.recipe.FishingSpotRecipe;
import net.blay09.mods.littlejoys.recipe.GoldRushRecipe;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.crafting.Recipe;

public class LittleJoysCommand {
    private static final ResourceLocation PERMISSION_LITTLEJOYS_DIGSPOT = new ResourceLocation("littlejoys", "command.littlejoys.digspot");
    private static final ResourceLocation PERMISSION_LITTLEJOYS_FISHINGSPOT = new ResourceLocation("littlejoys", "command.littlejoys.fishingspot");
    private static final ResourceLocation PERMISSION_LITTLEJOYS_GOLDRUSH = new ResourceLocation("littlejoys", "command.littlejoys.goldrush");
    private static final ResourceLocation PERMISSION_LITTLEJOYS_DROPRUSH = new ResourceLocation("littlejoys", "command.littlejoys.droprush");
    private static final DynamicCommandExceptionType ERROR_UNKNOWN_RECIPE = new DynamicCommandExceptionType(arg -> Component.m_237110_((String)"recipe.notFound", (Object[])new Object[]{arg}));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        BalmCommands.registerPermission((ResourceLocation)PERMISSION_LITTLEJOYS_DIGSPOT, (int)2);
        BalmCommands.registerPermission((ResourceLocation)PERMISSION_LITTLEJOYS_FISHINGSPOT, (int)2);
        BalmCommands.registerPermission((ResourceLocation)PERMISSION_LITTLEJOYS_GOLDRUSH, (int)2);
        BalmCommands.registerPermission((ResourceLocation)PERMISSION_LITTLEJOYS_DROPRUSH, (int)2);
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"littlejoys").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"digspot").requires(BalmCommands.requirePermission((ResourceLocation)PERMISSION_LITTLEJOYS_DIGSPOT))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"position", (ArgumentType)BlockPosArgument.m_118239_()).executes(context -> {
            ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            BlockPos pos = BlockPosArgument.m_264582_((CommandContext)context, (String)"position");
            return DigSpotHandler.createDigSpot(level, pos, player) ? 1 : 0;
        })).then(Commands.m_82129_((String)"recipe", (ArgumentType)ResourceLocationArgument.m_106984_()).executes(context -> {
            ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
            BlockPos pos = BlockPosArgument.m_264582_((CommandContext)context, (String)"position");
            Recipe recipe = ResourceLocationArgument.m_106994_((CommandContext)context, (String)"recipe");
            if (recipe instanceof DigSpotRecipe) {
                DigSpotRecipe digSpotRecipe = (DigSpotRecipe)recipe;
                DigSpotHandler.createDigSpot(level, pos, digSpotRecipe);
                return 1;
            }
            throw ERROR_UNKNOWN_RECIPE.create((Object)ResourceLocationArgument.m_107011_((CommandContext)context, (String)"recipe"));
        }))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"fishingspot").requires(BalmCommands.requirePermission((ResourceLocation)PERMISSION_LITTLEJOYS_FISHINGSPOT))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"position", (ArgumentType)BlockPosArgument.m_118239_()).executes(context -> {
            ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            BlockPos pos = BlockPosArgument.m_264582_((CommandContext)context, (String)"position");
            return FishingSpotHandler.createFishingSpot(level, pos, player) ? 1 : 0;
        })).then(Commands.m_82129_((String)"recipe", (ArgumentType)ResourceLocationArgument.m_106984_()).executes(context -> {
            ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
            BlockPos pos = BlockPosArgument.m_264582_((CommandContext)context, (String)"position");
            Recipe recipe = ResourceLocationArgument.m_106994_((CommandContext)context, (String)"recipe");
            if (recipe instanceof FishingSpotRecipe) {
                FishingSpotRecipe fishingSpotRecipe = (FishingSpotRecipe)recipe;
                FishingSpotHandler.createFishingSpot(level, pos, fishingSpotRecipe);
                return 1;
            }
            throw ERROR_UNKNOWN_RECIPE.create((Object)ResourceLocationArgument.m_107011_((CommandContext)context, (String)"recipe"));
        }))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"goldrush").requires(BalmCommands.requirePermission((ResourceLocation)PERMISSION_LITTLEJOYS_GOLDRUSH))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"position", (ArgumentType)BlockPosArgument.m_118239_()).executes(context -> {
            ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            BlockPos pos = BlockPosArgument.m_264582_((CommandContext)context, (String)"position");
            GoldRushHandler.startGoldRush(level, pos, level.m_8055_(pos), player);
            return 1;
        })).then(Commands.m_82129_((String)"recipe", (ArgumentType)ResourceLocationArgument.m_106984_()).executes(context -> {
            ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            BlockPos pos = BlockPosArgument.m_264582_((CommandContext)context, (String)"position");
            Recipe recipe = ResourceLocationArgument.m_106994_((CommandContext)context, (String)"recipe");
            if (recipe instanceof GoldRushRecipe) {
                GoldRushRecipe goldRushRecipe = (GoldRushRecipe)recipe;
                GoldRushHandler.startGoldRush(level, pos, level.m_8055_(pos), player, goldRushRecipe);
                return 1;
            }
            throw ERROR_UNKNOWN_RECIPE.create((Object)ResourceLocationArgument.m_107011_((CommandContext)context, (String)"recipe"));
        }))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"droprush").requires(BalmCommands.requirePermission((ResourceLocation)PERMISSION_LITTLEJOYS_DROPRUSH))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"position", (ArgumentType)BlockPosArgument.m_118239_()).executes(context -> {
            ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            BlockPos pos = BlockPosArgument.m_264582_((CommandContext)context, (String)"position");
            DropRushHandler.startDropRush(level, pos, level.m_8055_(pos), player);
            return 0;
        })).then(Commands.m_82129_((String)"recipe", (ArgumentType)ResourceLocationArgument.m_106984_()).executes(context -> {
            ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            BlockPos pos = BlockPosArgument.m_264582_((CommandContext)context, (String)"position");
            Recipe recipe = ResourceLocationArgument.m_106994_((CommandContext)context, (String)"recipe");
            if (recipe instanceof DropRushRecipe) {
                DropRushRecipe dropRushRecipe = (DropRushRecipe)recipe;
                DropRushHandler.startDropRush(level, pos, player, dropRushRecipe);
                return 1;
            }
            throw ERROR_UNKNOWN_RECIPE.create((Object)ResourceLocationArgument.m_107011_((CommandContext)context, (String)"recipe"));
        })))));
    }
}

