/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.littlejoys.client.handler;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.TickPhase;
import net.blay09.mods.balm.api.event.TickType;
import net.blay09.mods.balm.api.event.client.DisconnectedFromServerEvent;
import net.blay09.mods.littlejoys.handler.GoldRushInstance;
import net.blay09.mods.littlejoys.particle.ModParticles;
import net.blay09.mods.littlejoys.sound.ModSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;

public class GoldRushClientHandler {
    private static final RandomSource random = RandomSource.m_216327_();
    private static final Table<ResourceKey<Level>, BlockPos, GoldRushInstance> activeGoldRushes = HashBasedTable.create();

    public static void initialize() {
        Balm.getEvents().onTickEvent(TickType.ClientLevel, TickPhase.Start, level -> {
            if (level == null) {
                return;
            }
            for (GoldRushInstance goldRush : activeGoldRushes.row((Object)level.m_46472_()).values()) {
                BlockPos pos = goldRush.getPos();
                int x = pos.m_123341_();
                int y = pos.m_123342_();
                int z = pos.m_123343_();
                float randomOffsetX = random.m_188501_();
                float randomOffsetY = random.m_188501_();
                float randomOffsetZ = random.m_188501_();
                BlockState state = level.m_8055_(pos);
                if (state.m_60831_((BlockGetter)level, pos)) {
                    for (Direction direction : Direction.values()) {
                        float offsetX = direction.m_122434_() == Direction.Axis.X ? 0.5f + 0.6f * (float)direction.m_122421_().m_122540_() : randomOffsetX;
                        float offsetY = direction.m_122434_() == Direction.Axis.Y ? 0.5f + 0.6f * (float)direction.m_122421_().m_122540_() : randomOffsetY;
                        float offsetZ = direction.m_122434_() == Direction.Axis.Z ? 0.5f + 0.6f * (float)direction.m_122421_().m_122540_() : randomOffsetZ;
                        BlockPos offsetPos = pos.m_121945_(direction);
                        if (level.m_8055_(offsetPos).m_60831_((BlockGetter)level, offsetPos)) continue;
                        level.m_7106_((ParticleOptions)ModParticles.goldRush, (double)((float)x + offsetX), (double)((float)y + offsetY), (double)((float)z + offsetZ), 0.0, 0.0, 0.0);
                    }
                } else {
                    level.m_7106_((ParticleOptions)ModParticles.goldRush, (double)((float)x + randomOffsetX), (double)((float)y + randomOffsetY), (double)((float)z + randomOffsetZ), 0.0, 0.0, 0.0);
                }
                if (goldRush.getTicksPassed() % 160 == 0) {
                    level.m_245747_(pos, (SoundEvent)ModSounds.goldRush.get(), SoundSource.BLOCKS, 0.5f, 1.0f, false);
                }
                goldRush.setTicksPassed(goldRush.getTicksPassed() + 1);
            }
        });
        Balm.getEvents().onEvent(DisconnectedFromServerEvent.class, event -> {
            activeGoldRushes.clear();
            Minecraft.m_91087_().m_91106_().m_120386_(new ResourceLocation("littlejoys", "gold_rush"), SoundSource.BLOCKS);
        });
    }

    public static void addActiveGoldRush(BlockPos pos) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            activeGoldRushes.put((Object)level.m_46472_(), (Object)pos, (Object)new GoldRushInstance(pos, level.m_8055_(pos), BuiltInLootTables.f_78712_, -1, -1, null));
        }
    }

    public static void removeActiveGoldRush(BlockPos pos) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        if (level != null) {
            activeGoldRushes.remove((Object)level.m_46472_(), (Object)pos);
            if (activeGoldRushes.isEmpty()) {
                minecraft.m_91106_().m_120386_(new ResourceLocation("littlejoys", "gold_rush"), SoundSource.BLOCKS);
            }
        }
    }
}

