/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.packets;

import journeymap.client.JourneymapClient;
import journeymap.common.Journeymap;
import journeymap.common.network.data.PacketContext;
import journeymap.common.network.data.Side;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class WorldIdPacket {
    public static final ResourceLocation CHANNEL = new ResourceLocation("worldinfo", "world_id");
    private String worldId;

    public WorldIdPacket() {
        this.worldId = "";
    }

    public WorldIdPacket(String worldId) {
        this.worldId = worldId;
    }

    public String getWorldId() {
        return this.worldId;
    }

    public static WorldIdPacket decode(FriendlyByteBuf buf) {
        WorldIdPacket packet = new WorldIdPacket();
        try {
            if (buf.readableBytes() > 1) {
                buf.readByte();
                packet.worldId = buf.m_130136_(Short.MAX_VALUE);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(String.format("Failed to read message for worldId: %s", t));
        }
        return packet;
    }

    public void encode(FriendlyByteBuf buf) {
        try {
            if (this.worldId != null) {
                buf.writeByte(42);
                buf.m_130070_(this.worldId);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("[toBytes]Failed to write message for worldId:" + t);
        }
    }

    public static void handle(PacketContext<WorldIdPacket> ctx) {
        if (Side.CLIENT.equals((Object)ctx.side())) {
            JourneymapClient.getInstance().getPacketHandler().onWorldIdReceived(ctx.message().getWorldId());
        } else {
            Journeymap.getInstance().getPacketHandler().onWorldIdRequest(ctx.sender());
        }
    }
}

