/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.ingame;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import journeymap.client.render.draw.MatrixDrawUtil;
import journeymap.client.render.ingame.WaypointRenderTypes;
import journeymap.client.render.ingame.WaypointRenderer;
import journeymap.client.waypoint.Waypoint;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class WaypointBeaconRenderer
extends WaypointRenderer {
    @Override
    protected void render(PoseStack poseStack, MultiBufferSource buffers, Waypoint waypoint, float partialTicks, long gameTime, float[] rgba, float fadeAlpha, double shiftX, double shiftY, double shiftZ, Vec3 playerVec, Vec3 waypointVec, double viewDistance, double actualDistance, double scale) {
        boolean showStaticInnerBeam = this.waypointProperties.showStaticBeam.get();
        boolean showRotatingOuterBeam = this.waypointProperties.showRotatingBeam.get();
        if (showStaticInnerBeam || showRotatingOuterBeam) {
            poseStack.m_85836_();
            poseStack.m_85837_(shiftX, -180.0, shiftZ);
            this.renderBeamSegment(poseStack, buffers, partialTicks, gameTime, 1, 360, rgba, 0.2f, 0.25f, showStaticInnerBeam, showRotatingOuterBeam);
            poseStack.m_85849_();
        }
    }

    public void renderBeamSegment(PoseStack poseStack, MultiBufferSource buffer, float partialTicks, long gameTime, int yOffset, int height, float[] colors, float beamRadius, float glowRadius, boolean showStaticInnerBeam, boolean showRotatingOuterBeam) {
        float texScale = 1.0f;
        int heightOffset = yOffset + height;
        float rotation = (float)Math.floorMod(gameTime, 40L) + partialTicks;
        float texOffset = -((float)(-gameTime) * 0.2f - (float)Mth.m_14143_((float)((float)(-gameTime) * 0.1f))) * 0.6f;
        float red = colors[0];
        float blue = colors[1];
        float green = colors[2];
        float alpha = colors[3];
        VertexConsumer beamBuffer = buffer.m_6299_(WaypointRenderTypes.BEAM_RENDER_TYPE);
        poseStack.m_85836_();
        if (!showStaticInnerBeam) {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(rotation * 2.25f - 45.0f));
        }
        float V2 = -1.0f + texOffset;
        float innerV1 = (float)height * texScale * (0.5f / beamRadius) + V2;
        this.renderPart(poseStack, beamBuffer, red, blue, green, alpha, yOffset, heightOffset, 0.0f, beamRadius, beamRadius, 0.0f, -beamRadius, 0.0f, 0.0f, -beamRadius, 0.0f, 1.0f, innerV1, V2);
        poseStack.m_85849_();
        float outerV1 = (float)height * texScale + V2;
        poseStack.m_85836_();
        if (showRotatingOuterBeam) {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(rotation * 2.25f - 45.0f));
        }
        this.renderPart(poseStack, beamBuffer, red, blue, green, alpha, yOffset, heightOffset, -glowRadius, -glowRadius, glowRadius, -glowRadius, -glowRadius, glowRadius, glowRadius, glowRadius, 0.0f, 1.0f, outerV1, V2);
        poseStack.m_85849_();
    }

    private void renderPart(PoseStack poseStack, VertexConsumer buffer, float red, float green, float blue, float alpha, int yMin, int yMax, float p1, float p2, float p3, float p4, float p5, float p6, float p7, float p8, float u1, float u2, float v1, float v2) {
        PoseStack.Pose entry = poseStack.m_85850_();
        Matrix4f matrixPos = entry.m_252922_();
        Matrix3f normal = entry.m_252943_();
        this.addQuad(matrixPos, normal, buffer, red, green, blue, alpha, yMin, yMax, p1, p2, p3, p4, u1, u2, v1, v2);
        this.addQuad(matrixPos, normal, buffer, red, green, blue, alpha, yMin, yMax, p7, p8, p5, p6, u1, u2, v1, v2);
        this.addQuad(matrixPos, normal, buffer, red, green, blue, alpha, yMin, yMax, p3, p4, p7, p8, u1, u2, v1, v2);
        this.addQuad(matrixPos, normal, buffer, red, green, blue, alpha, yMin, yMax, p5, p6, p1, p2, u1, u2, v1, v2);
    }

    private void addQuad(Matrix4f matrixPos, Matrix3f normal, VertexConsumer bufferIn, float red, float green, float blue, float alpha, int yMin, int yMax, float x1, float z1, float x2, float z2, float u1, float u2, float v1, float v2) {
        MatrixDrawUtil.addVertexUV(matrixPos, normal, bufferIn, red, green, blue, alpha, yMax, x1, z1, u2, v1);
        MatrixDrawUtil.addVertexUV(matrixPos, normal, bufferIn, red, green, blue, alpha, yMin, x1, z1, u2, v2);
        MatrixDrawUtil.addVertexUV(matrixPos, normal, bufferIn, red, green, blue, alpha, yMin, x2, z2, u1, v2);
        MatrixDrawUtil.addVertexUV(matrixPos, normal, bufferIn, red, green, blue, alpha, yMax, x2, z2, u1, v1);
    }
}

