/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.attributesmod.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.puffish.attributesmod.AttributesMod;
import net.puffish.attributesmod.api.DynamicModification;
import net.puffish.attributesmod.util.DamageKind;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={LivingEntity.class}, priority=1100)
public abstract class LivingEntityMixin {
    @ModifyExpressionValue(method={"createLivingAttributes"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/attribute/DefaultAttributeContainer;builder()Lnet/minecraft/entity/attribute/DefaultAttributeContainer$Builder;")})
    private static AttributeSupplier.Builder modifyExpressionValueAtBuilder(AttributeSupplier.Builder builder) {
        return builder.m_22266_(AttributesMod.MAGIC_DAMAGE).m_22266_(AttributesMod.MELEE_DAMAGE).m_22266_(AttributesMod.RANGED_DAMAGE).m_22266_(AttributesMod.HEALING).m_22266_(AttributesMod.JUMP).m_22266_(AttributesMod.RESISTANCE).m_22266_(AttributesMod.MAGIC_RESISTANCE).m_22266_(AttributesMod.MELEE_RESISTANCE).m_22266_(AttributesMod.RANGED_RESISTANCE).m_22266_(AttributesMod.ARMOR_SHRED).m_22266_(AttributesMod.TOUGHNESS_SHRED).m_22266_(AttributesMod.PROTECTION_SHRED).m_22266_(AttributesMod.RESISTANCE_SHRED).m_22266_(AttributesMod.MAGIC_RESISTANCE_SHRED).m_22266_(AttributesMod.MELEE_RESISTANCE_SHRED).m_22266_(AttributesMod.RANGED_RESISTANCE_SHRED).m_22266_(AttributesMod.STEALTH).m_22266_(AttributesMod.LIFE_STEAL).m_22266_(AttributesMod.FALL_REDUCTION).m_22266_(AttributesMod.BOW_PROJECTILE_SPEED).m_22266_(AttributesMod.CROSSBOW_PROJECTILE_SPEED);
    }

    @ModifyVariable(method={"damage"}, at=@At(value="HEAD"), argsOnly=true, ordinal=0)
    private float modifyVariableAtDamage(float damage, DamageSource source) {
        if (damage < 0.0f) {
            return damage;
        }
        Entity entity = source.m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            DynamicModification dm = DynamicModification.create();
            DamageKind kind = DamageKind.of(source);
            if (kind.isMagic()) {
                dm.withPositive(AttributesMod.MAGIC_DAMAGE, attacker);
            } else {
                if (kind.isProjectile()) {
                    dm.withPositive(AttributesMod.RANGED_DAMAGE, attacker);
                }
                if (kind.isMelee()) {
                    dm.withPositive(AttributesMod.MELEE_DAMAGE, attacker);
                }
            }
            damage = dm.applyTo(damage);
        }
        return damage;
    }

    @WrapOperation(method={"applyArmorToDamage"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/DamageUtil;getDamageLeft(FFF)F")})
    private float wrapOperationAtApplyArmorToDamage(float damage, float armor, float toughness, Operation<Float> operation, @Local(argsOnly=true) DamageSource source) {
        Entity entity = source.m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            armor = Math.max(0.0f, DynamicModification.create().withNegative(AttributesMod.ARMOR_SHRED, attacker).applyTo(armor));
            toughness = Math.max(0.0f, DynamicModification.create().withNegative(AttributesMod.TOUGHNESS_SHRED, attacker).applyTo(toughness));
        }
        return ((Float)operation.call(new Object[]{Float.valueOf(damage), Float.valueOf(armor), Float.valueOf(toughness)})).floatValue();
    }

    @WrapOperation(method={"modifyAppliedDamage"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/DamageUtil;getInflictedDamage(FF)F")})
    private float wrapOperationAtModifyAppliedDamage(float damageDealt, float protection, Operation<Float> original, @Local(argsOnly=true) DamageSource source) {
        Entity entity = source.m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            protection = Math.max(0.0f, DynamicModification.create().withNegative(AttributesMod.PROTECTION_SHRED, attacker).applyTo(protection));
        }
        return ((Float)original.call(new Object[]{Float.valueOf(damageDealt), Float.valueOf(protection)})).floatValue();
    }

    @ModifyVariable(method={"heal"}, at=@At(value="HEAD"), argsOnly=true, ordinal=0)
    private float modifyVariableAtHeal(float amount) {
        if (amount < 0.0f) {
            return amount;
        }
        return DynamicModification.create().withPositive(AttributesMod.HEALING, (LivingEntity)this).applyTo(amount);
    }

    @ModifyReturnValue(method={"getJumpVelocity"}, at={@At(value="RETURN")})
    private float injectAtGetJumpVelocity(float jump) {
        return DynamicModification.create().withPositive(AttributesMod.JUMP, (LivingEntity)this).applyTo(jump);
    }

    @ModifyVariable(method={"computeFallDamage"}, at=@At(value="HEAD"), argsOnly=true, ordinal=0)
    private float modifyVariableAtComputeFallDamage(float fallDistance) {
        return DynamicModification.create().withNegative(AttributesMod.FALL_REDUCTION, (LivingEntity)this).applyTo(fallDistance) - DynamicModification.create().withPositive(AttributesMod.JUMP, (LivingEntity)this).relativeTo(1.0f) * 10.0f;
    }

    @ModifyReturnValue(method={"modifyAppliedDamage"}, at={@At(value="TAIL")})
    private float injectAtModifyAppliedDamage(float damage, @Local(argsOnly=true) DamageSource source) {
        if (damage > 1.1342745E38f) {
            return damage;
        }
        LivingEntity entity = (LivingEntity)this;
        DamageKind kind = DamageKind.of(source);
        DynamicModification dmResistance = DynamicModification.create();
        dmResistance.withNegative(AttributesMod.RESISTANCE, entity);
        if (kind.isMagic()) {
            dmResistance.withNegative(AttributesMod.MAGIC_RESISTANCE, entity);
        } else {
            if (kind.isProjectile()) {
                dmResistance.withNegative(AttributesMod.RANGED_RESISTANCE, entity);
            }
            if (kind.isMelee()) {
                dmResistance.withNegative(AttributesMod.MELEE_RESISTANCE, entity);
            }
        }
        float resistance = damage - dmResistance.applyTo(damage);
        Entity entity2 = source.m_7639_();
        if (entity2 instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity2;
            DynamicModification dmShred = DynamicModification.create();
            dmShred.withNegative(AttributesMod.RESISTANCE_SHRED, attacker);
            if (kind.isMagic()) {
                dmShred.withNegative(AttributesMod.MAGIC_RESISTANCE_SHRED, attacker);
            } else {
                if (kind.isProjectile()) {
                    dmShred.withNegative(AttributesMod.MAGIC_RESISTANCE_SHRED, attacker);
                }
                if (kind.isMelee()) {
                    dmShred.withNegative(AttributesMod.MAGIC_RESISTANCE_SHRED, attacker);
                }
            }
            resistance = Math.max(0.0f, dmShred.applyTo(resistance));
        }
        return Math.max(0.0f, damage - resistance);
    }
}

