/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.world.module;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.material.MapColor;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.world.block.MyaliteCrystalBlock;
import org.violetmoon.quark.content.world.gen.SpiralSpireGenerator;
import org.violetmoon.quark.content.world.module.CorundumModule;
import org.violetmoon.zeta.advancement.ManualTrigger;
import org.violetmoon.zeta.block.IZetaBlock;
import org.violetmoon.zeta.block.OldMaterials;
import org.violetmoon.zeta.block.ZetaBlock;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.config.type.CompoundBiomeConfig;
import org.violetmoon.zeta.config.type.DimensionConfig;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZCommonSetup;
import org.violetmoon.zeta.event.load.ZGatherHints;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.event.play.entity.ZEntityTeleport;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.Hint;
import org.violetmoon.zeta.world.WorldGenHandler;
import org.violetmoon.zeta.world.generator.Generator;

@ZetaLoadModule(category="world")
public class SpiralSpiresModule
extends ZetaModule {
    @Config
    public static DimensionConfig dimensions = DimensionConfig.end((boolean)false);
    @Config
    public static CompoundBiomeConfig biomes = CompoundBiomeConfig.fromBiomeReslocs((boolean)false, (String[])new String[]{"minecraft:end_highlands"});
    @Config
    public static int rarity = 200;
    @Config
    public static int radius = 15;
    @Config(flag="myalite_viaduct")
    public static boolean enableMyaliteViaducts = true;
    @Config
    @Config.Min(value=2.0)
    @Config.Max(value=1024.0)
    public static int myaliteConduitDistance = 24;
    @Config
    public static boolean renewableMyalite = true;
    public static ManualTrigger useViaductTrigger;
    @Hint
    public static Block dusky_myalite;
    public static Block myalite_crystal;

    @LoadEvent
    public final void register(ZRegister event) {
        BlockBehaviour.Properties props = OldMaterials.stone().m_284180_(MapColor.f_283892_).m_60999_().m_60913_(1.5f, 6.0f);
        dusky_myalite = new ZetaBlock("dusky_myalite", (ZetaModule)this, props).setCreativeTab(CreativeModeTabs.f_256788_, (ItemLike)Blocks.f_50492_, true);
        myalite_crystal = new MyaliteCrystalBlock(this);
        ((IZetaBlock)dusky_myalite).setCreativeTab(CreativeModeTabs.f_256776_, (ItemLike)Blocks.f_50259_, false);
        ((IZetaBlock)myalite_crystal).setCreativeTab(CreativeModeTabs.f_256776_, (ItemLike)Blocks.f_50259_, false);
        useViaductTrigger = event.getAdvancementModifierRegistry().registerManualTrigger("use_viaduct");
    }

    @LoadEvent
    public final void setup(ZCommonSetup event) {
        WorldGenHandler.addGenerator((ZetaModule)this, (Generator)new SpiralSpireGenerator(dimensions), (GenerationStep.Decoration)GenerationStep.Decoration.SURFACE_STRUCTURES, (int)0);
    }

    @LoadEvent
    public void addAdditionalHints(ZGatherHints event) {
        MutableComponent comp = Component.m_237115_((String)"quark.jei.hint.myalite_crystal_get");
        if (enableMyaliteViaducts) {
            comp = comp.m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"quark.jei.hint.myalite_crystal_viaduct"));
        }
        if (renewableMyalite && Quark.ZETA.modules.isEnabled(CorundumModule.class)) {
            comp = comp.m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"quark.jei.hint.myalite_crystal_grow"));
        }
        event.accept((ItemLike)myalite_crystal.m_5456_(), (Component)comp);
    }

    @PlayEvent
    public void onTeleport(ZEntityTeleport event) {
        BlockPos pos;
        if (!enableMyaliteViaducts) {
            return;
        }
        Entity entity = event.getEntity();
        Level world = entity.m_9236_();
        if (!world.m_46749_(pos = BlockPos.m_274561_((double)event.getTargetX(), (double)event.getTargetY(), (double)event.getTargetZ()))) {
            return;
        }
        List<BlockPos> myalite = SpiralSpiresModule.getAdjacentMyalite(null, world, pos, null);
        if (myalite == null || myalite.isEmpty()) {
            pos = pos.m_7495_();
            myalite = SpiralSpiresModule.getAdjacentMyalite(null, world, pos, null);
        }
        if (myalite == null || myalite.isEmpty()) {
            pos = pos.m_121945_(event.getEntity().m_6350_());
            myalite = SpiralSpiresModule.getAdjacentMyalite(null, world, pos, null);
        }
        if (myalite != null && !myalite.isEmpty()) {
            BlockPos test;
            ArrayList<BlockPos> found;
            block12: {
                BlockPos prev;
                BlockPos cond = pos;
                found = new ArrayList<BlockPos>();
                int moves = 0;
                do {
                    prev = cond;
                    cond = myalite.get(world.f_46441_.m_188503_(myalite.size()));
                    found.add(cond);
                    myalite = SpiralSpiresModule.getAdjacentMyalite(found, world, cond, null);
                    if (myalite != null && ++moves <= myaliteConduitDistance) continue;
                    return;
                } while (!myalite.isEmpty());
                test = cond.m_7918_(cond.m_123341_() - prev.m_123341_(), cond.m_123342_() - prev.m_123342_(), cond.m_123343_() - prev.m_123343_());
                if (!world.m_8055_(test).m_60795_()) {
                    for (Direction d : Direction.values()) {
                        test = cond.m_121945_(d);
                        if (!world.m_8055_(test).m_60795_()) continue;
                        if (d.m_122434_() == Direction.Axis.Y) {
                            test = test.m_121945_(d);
                        }
                        break block12;
                    }
                    return;
                }
            }
            event.setTargetX((double)test.m_123341_() + 0.5);
            event.setTargetY((double)test.m_123342_() + 0.5);
            event.setTargetZ((double)test.m_123343_() + 0.5);
            Entity entity2 = event.getEntity();
            if (entity2 instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)entity2;
                useViaductTrigger.trigger(sp);
            }
            if (world instanceof ServerLevel) {
                ServerLevel sworld = (ServerLevel)world;
                for (BlockPos f : found) {
                    sworld.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, myalite_crystal.m_49966_()), (double)f.m_123341_() + 0.5, (double)f.m_123342_() + 0.5, (double)f.m_123343_() + 0.5, 30, 0.25, 0.25, 0.25, 0.0);
                }
            }
        }
    }

    private static List<BlockPos> getAdjacentMyalite(List<BlockPos> found, Level world, BlockPos pos, Direction ignore) {
        ArrayList<BlockPos> ret = new ArrayList<BlockPos>(6);
        ArrayList<BlockPos> collisions = new ArrayList<BlockPos>();
        for (Direction d : Direction.values()) {
            BlockPos off;
            if (d == ignore || world.m_8055_(off = pos.m_121945_(d)).m_60734_() != myalite_crystal) continue;
            if (found != null && found.contains(off)) {
                collisions.add(off);
                continue;
            }
            ret.add(off);
        }
        if (ret.isEmpty() && collisions.size() > 1) {
            return null;
        }
        return ret;
    }
}

