/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.cerbons_api.capability.providers;

import com.cerbon.cerbons_api.api.general.data.HistoricalData;
import com.cerbon.cerbons_api.api.static_utilities.VecUtils;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.AutoRegisterCapability;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@AutoRegisterCapability
public class Vec3HistoryProvider
implements ICapabilitySerializable<CompoundTag> {
    private final Vec3 initialValue;
    private final int maxHistory;
    private final boolean persistData;
    private Vec3History positionalHistory;
    private final LazyOptional<Vec3History> optional = LazyOptional.of(this::createHistoricalData);
    public static final Capability<Vec3History> HISTORICAL_DATA = CapabilityManager.get((CapabilityToken)new CapabilityToken<Vec3History>(){});

    public Vec3HistoryProvider(Vec3 initialValue, int maxHistory, boolean persistData) {
        this.initialValue = initialValue;
        this.maxHistory = maxHistory;
        this.persistData = persistData;
    }

    public Vec3HistoryProvider(int maxHistory, boolean persistData) {
        this(Vec3.f_82478_, maxHistory, persistData);
    }

    private Vec3History createHistoricalData() {
        if (this.positionalHistory == null) {
            this.positionalHistory = new Vec3History(this.initialValue, this.maxHistory);
        }
        return this.positionalHistory;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        if (this.positionalHistory == null || !this.persistData) {
            return tag;
        }
        tag.m_128388_("LastVec3s", this.positionalHistory.stream().map(BlockPos::m_274446_).mapToLong(BlockPos::m_121878_).toArray());
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (!tag.m_128441_("LastVec3s") || !this.persistData) {
            return;
        }
        List<Vec3> vec3s = Arrays.stream(tag.m_128467_("LastVec3s")).mapToObj(BlockPos::m_122022_).map(VecUtils::asVec3).toList();
        this.positionalHistory = new Vec3History(Vec3.f_82478_, this.maxHistory);
        this.positionalHistory.remove(0);
        this.positionalHistory.addAll(vec3s);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return HISTORICAL_DATA.orEmpty(cap, this.optional);
    }

    public static class Vec3History
    extends HistoricalData<Vec3> {
        public Vec3History(Vec3 initialValue, int maxHistory) {
            super(initialValue, maxHistory);
        }
    }
}

