/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.herbalbrews.core.items;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlaskItem
extends Item {
    public FlaskItem(Item.Properties properties) {
        super(properties.m_41487_(16));
    }

    @NotNull
    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public int m_8105_(ItemStack stack) {
        return 32;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41782_() || !Objects.requireNonNull(stack.m_41783_()).m_128441_("CustomModelData")) {
            this.setRandomTexture(level, stack);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    @NotNull
    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entity) {
        if (!level.f_46443_ && entity instanceof Player) {
            Player player = (Player)entity;
            this.applyPotionEffects(stack, player);
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
        }
        return stack;
    }

    private void setRandomTexture(@Nullable Level level, ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_("CustomModelData")) {
            int randomTexture = level != null ? level.m_213780_().m_188503_(6) + 1 : (int)(Math.random() * 6.0) + 1;
            tag.m_128405_("CustomModelData", randomTexture);
            System.out.println("Set CustomModelData: " + randomTexture);
        }
    }

    private void applyPotionEffects(ItemStack stack, Player player) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_("CustomPotionEffects", 9)) {
            ListTag effects = tag.m_128437_("CustomPotionEffects", 10);
            for (int i = 0; i < effects.size(); ++i) {
                CompoundTag effectTag = effects.m_128728_(i);
                int effectId = effectTag.m_128451_("Id");
                MobEffect effect = (MobEffect)BuiltInRegistries.f_256974_.m_7942_(effectId);
                if (effect == null) continue;
                int duration = effectTag.m_128451_("Duration");
                byte amplifier = effectTag.m_128445_("Amplifier");
                MobEffectInstance effectInstance = new MobEffectInstance(effect, duration, (int)amplifier);
                player.m_7292_(effectInstance);
            }
        }
    }

    public void m_7836_(ItemStack stack, Level world, Player player) {
        super.m_7836_(stack, world, player);
        this.setRandomTexture(world, stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_("CustomPotionEffects", 9)) {
            ListTag effects = tag.m_128437_("CustomPotionEffects", 10);
            for (int i = 0; i < effects.size(); ++i) {
                CompoundTag effectTag = effects.m_128728_(i);
                int effectId = effectTag.m_128451_("Id");
                MobEffect effect = (MobEffect)BuiltInRegistries.f_256974_.m_7942_(effectId);
                if (effect == null) continue;
                int duration = effectTag.m_128451_("Duration");
                byte amplifier = effectTag.m_128445_("Amplifier");
                MobEffectInstance effectInstance = new MobEffectInstance(effect, duration, (int)amplifier);
                MutableComponent effectName = Component.m_237115_((String)effect.m_19481_());
                if (amplifier >= 0) {
                    effectName = effectName.m_130946_(" " + this.toRomanNumerals(amplifier + 1));
                }
                if (effectInstance.m_19557_() > 20) {
                    effectName = Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{effectName, MobEffectUtil.m_267641_((MobEffectInstance)effectInstance, (float)1.0f)});
                }
                tooltip.add((Component)effectName.m_130940_(effect.m_19483_().m_19497_()));
            }
        } else {
            tooltip.add((Component)Component.m_237115_((String)"effect.none").m_130940_(ChatFormatting.GRAY));
        }
        ArrayList list3 = Lists.newArrayList();
        if (tag != null && tag.m_128441_("AttributeModifiers")) {
            ListTag modifiers = tag.m_128437_("AttributeModifiers", 10);
            for (int i = 0; i < modifiers.size(); ++i) {
                CompoundTag modifierTag = modifiers.m_128728_(i);
                String attributeName = modifierTag.m_128461_("AttributeName");
                Attribute attribute = (Attribute)BuiltInRegistries.f_256951_.m_7745_(new ResourceLocation(attributeName));
                if (attribute == null) continue;
                double amount = modifierTag.m_128459_("Amount");
                AttributeModifier.Operation op = AttributeModifier.Operation.values()[modifierTag.m_128445_("Operation")];
                String uuid = modifierTag.m_128461_("UUID");
                AttributeModifier modifier = new AttributeModifier(UUID.fromString(uuid), modifierTag.m_128461_("Name"), amount, op);
                list3.add(new Pair((Object)attribute, (Object)modifier));
            }
        }
        if (!list3.isEmpty()) {
            tooltip.add((Component)Component.m_237119_());
            tooltip.add((Component)Component.m_237115_((String)"potion.whenDrank").m_130940_(ChatFormatting.DARK_PURPLE));
            for (Pair pair : list3) {
                AttributeModifier modifier = (AttributeModifier)pair.getSecond();
                double d = modifier.m_22218_();
                double e = modifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && modifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? modifier.m_22218_() : modifier.m_22218_() * 100.0;
                if (d > 0.0) {
                    tooltip.add((Component)Component.m_237110_((String)("attribute.modifier.plus." + modifier.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(e), Component.m_237115_((String)((Attribute)pair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.BLUE));
                    continue;
                }
                if (!(d < 0.0)) continue;
                tooltip.add((Component)Component.m_237110_((String)("attribute.modifier.take." + modifier.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(e *= -1.0), Component.m_237115_((String)((Attribute)pair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.RED));
            }
        }
    }

    private String toRomanNumerals(int number) {
        if (number < 1 || number > 3999) {
            return String.valueOf(number);
        }
        StringBuilder sb = new StringBuilder();
        int[] values = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
        String[] numerals = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
        for (int i = 0; i < values.length; ++i) {
            while (number >= values[i]) {
                number -= values[i];
                sb.append(numerals[i]);
            }
        }
        return sb.toString();
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        if (!(world.f_46443_ || stack.m_41782_() && Objects.requireNonNull(stack.m_41783_()).m_128441_("CustomModelData"))) {
            this.setRandomTexture(world, stack);
        }
    }
}

