/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.herbalbrews.core.blocks;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.herbalbrews.core.blocks.entity.TeaKettleBlockEntity;
import net.satisfy.herbalbrews.core.registry.EntityTypeRegistry;
import net.satisfy.herbalbrews.core.registry.SoundEventRegistry;
import net.satisfy.herbalbrews.core.util.HerbalBrewsUtil;
import org.jetbrains.annotations.NotNull;

public class TeaKettleBlock
extends BaseEntityBlock {
    private static final Supplier<VoxelShape> voxelShapeSupplier = () -> {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)0.5, (double)0.8125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.125, (double)0.4375, (double)0.1875, (double)0.5, (double)0.5625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.3125, (double)0.5, (double)0.3125, (double)0.6875, (double)0.5625, (double)0.6875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.4375, (double)0.5625, (double)0.4375, (double)0.5625, (double)0.625, (double)0.5625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.5, (double)0.4375, (double)0.1875, (double)0.625, (double)0.5625), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    };
    public static final Map<Direction, VoxelShape> SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL.m_122557_().toList()) {
            map.put(direction, HerbalBrewsUtil.rotateShape(Direction.NORTH, direction, voxelShapeSupplier.get()));
        }
    });
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty LIT = BooleanProperty.m_61465_((String)"lit");
    public static final BooleanProperty COOKING = BooleanProperty.m_61465_((String)"cooking");

    public TeaKettleBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)COOKING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_());
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE.get(state.m_61143_((Property)FACING));
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity entity = world.m_7702_(pos);
        if (entity instanceof MenuProvider) {
            MenuProvider factory = (MenuProvider)entity;
            player.m_5893_(factory);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof TeaKettleBlockEntity) {
                TeaKettleBlockEntity pot = (TeaKettleBlockEntity)blockEntity;
                if (world instanceof ServerLevel) {
                    Containers.m_19002_((Level)world, (BlockPos)pos, (Container)pot);
                }
                world.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, world, pos, newState, moved);
        }
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity;
        if (world.m_5776_() && (blockEntity = world.m_7702_(pos)) instanceof TeaKettleBlockEntity) {
            TeaKettleBlockEntity be = (TeaKettleBlockEntity)blockEntity;
            if (be.doEffect) {
                double d = (double)pos.m_123341_() + 0.5;
                double e = (double)pos.m_123342_() + 0.5;
                double f = (double)pos.m_123343_() + 0.5;
                world.m_7785_(d, e, f, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                double radius = 0.75;
                int particleCount = 16;
                for (int i = 0; i < particleCount; ++i) {
                    double angle = Math.PI * 2 * (double)i / (double)particleCount;
                    double offsetX = radius * Math.cos(angle);
                    double offsetZ = radius * Math.sin(angle);
                    double px = d + offsetX;
                    double pz = f + offsetZ;
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123744_, px, e, pz, 0.0, 0.02, 0.0);
                }
                be.doEffect = false;
            }
        }
        if (((Boolean)state.m_61143_((Property)COOKING)).booleanValue() || ((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            double d = (double)pos.m_123341_() + 0.5;
            double e = (float)pos.m_123342_() + 8.0f + 5.0f;
            double f = (double)pos.m_123343_() + 0.5;
            if (random.m_188500_() < 0.3) {
                world.m_7785_(d, e, f, (SoundEvent)SoundEventRegistry.TEA_KETTLE_BOILING.get(), SoundSource.BLOCKS, 0.05f, 1.0f, false);
            }
            SimpleParticleType cozySmokeParticle = ParticleTypes.f_123762_;
            this.addParticle(world, (ParticleOptions)cozySmokeParticle, pos.m_123341_(), (double)pos.m_123342_() + 0.5, pos.m_123343_(), random, 0.02);
            this.addParticle(world, (ParticleOptions)ParticleTypes.f_123762_, pos.m_123341_(), (double)pos.m_123342_() + 2.2, pos.m_123343_(), random, 0.002);
        }
    }

    private void addParticle(Level world, ParticleOptions particleOptions, double x, double y, double z, RandomSource random, double velocityY) {
        world.m_7107_(particleOptions, x + 0.5 + random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), y + random.m_188500_() + random.m_188500_(), z + 0.5 + random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), 0.0, velocityY, 0.0);
    }

    public void m_141947_(Level world, BlockPos pos, BlockState state, Entity entity) {
        LivingEntity livingEntity;
        boolean isLit = (Boolean)state.m_61143_((Property)LIT);
        if (isLit && !entity.m_5825_() && entity instanceof LivingEntity && !EnchantmentHelper.m_44938_((LivingEntity)(livingEntity = (LivingEntity)entity))) {
            entity.m_6469_(world.m_269111_().m_269047_(), 1.0f);
        }
        super.m_141947_(world, pos, state, entity);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, COOKING, LIT});
    }

    @NotNull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return TeaKettleBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)EntityTypeRegistry.TEA_KETTLE_BLOCK_ENTITY.get()), (world1, pos, state1, be) -> be.tick(world1, pos, state1));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TeaKettleBlockEntity(pos, state);
    }

    public void m_5871_(ItemStack itemStack, BlockGetter world, List<Component> tooltip, TooltipFlag tooltipContext) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.herbalbrews.canbeplaced").m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)13467442)).m_131155_(Boolean.valueOf(true))));
    }
}

